/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the values that an admin sets for each job or session parameter configured in a Glue usage profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationObject implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationObject.Builder, ConfigurationObject> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(ConfigurationObject::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedValues")
            .getter(getter(ConfigurationObject::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MIN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinValue").getter(getter(ConfigurationObject::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()).build();

    private static final SdkField<String> MAX_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxValue").getter(getter(ConfigurationObject::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            ALLOWED_VALUES_FIELD, MIN_VALUE_FIELD, MAX_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DefaultValue", DEFAULT_VALUE_FIELD);
                    put("AllowedValues", ALLOWED_VALUES_FIELD);
                    put("MinValue", MIN_VALUE_FIELD);
                    put("MaxValue", MAX_VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String defaultValue;

    private final List<String> allowedValues;

    private final String minValue;

    private final String maxValue;

    private ConfigurationObject(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.allowedValues = builder.allowedValues;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    /**
     * <p>
     * A default value for the parameter.
     * </p>
     * 
     * @return A default value for the parameter.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedValues() {
        return allowedValues != null && !(allowedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed values for the parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedValues} method.
     * </p>
     * 
     * @return A list of allowed values for the parameter.
     */
    public final List<String> allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * A minimum allowed value for the parameter.
     * </p>
     * 
     * @return A minimum allowed value for the parameter.
     */
    public final String minValue() {
        return minValue;
    }

    /**
     * <p>
     * A maximum allowed value for the parameter.
     * </p>
     * 
     * @return A maximum allowed value for the parameter.
     */
    public final String maxValue() {
        return maxValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedValues() ? allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationObject)) {
            return false;
        }
        ConfigurationObject other = (ConfigurationObject) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && hasAllowedValues() == other.hasAllowedValues()
                && Objects.equals(allowedValues(), other.allowedValues()) && Objects.equals(minValue(), other.minValue())
                && Objects.equals(maxValue(), other.maxValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationObject").add("DefaultValue", defaultValue())
                .add("AllowedValues", hasAllowedValues() ? allowedValues() : null).add("MinValue", minValue())
                .add("MaxValue", maxValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationObject, T> g) {
        return obj -> g.apply((ConfigurationObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationObject> {
        /**
         * <p>
         * A default value for the parameter.
         * </p>
         * 
         * @param defaultValue
         *        A default value for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * A list of allowed values for the parameter.
         * </p>
         * 
         * @param allowedValues
         *        A list of allowed values for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<String> allowedValues);

        /**
         * <p>
         * A list of allowed values for the parameter.
         * </p>
         * 
         * @param allowedValues
         *        A list of allowed values for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String... allowedValues);

        /**
         * <p>
         * A minimum allowed value for the parameter.
         * </p>
         * 
         * @param minValue
         *        A minimum allowed value for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(String minValue);

        /**
         * <p>
         * A maximum allowed value for the parameter.
         * </p>
         * 
         * @param maxValue
         *        A maximum allowed value for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(String maxValue);
    }

    static final class BuilderImpl implements Builder {
        private String defaultValue;

        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private String minValue;

        private String maxValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationObject model) {
            defaultValue(model.defaultValue);
            allowedValues(model.allowedValues);
            minValue(model.minValue);
            maxValue(model.maxValue);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesStringListCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesStringListCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final String getMinValue() {
            return minValue;
        }

        public final void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(String minValue) {
            this.minValue = minValue;
            return this;
        }

        public final String getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        @Override
        public ConfigurationObject build() {
            return new ConfigurationObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
