/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of fields, comparators and value that you can use to filter the crawler runs for a specified crawler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrawlsFilter implements SdkPojo, Serializable, ToCopyableBuilder<CrawlsFilter.Builder, CrawlsFilter> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(CrawlsFilter::fieldNameAsString)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> FILTER_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterOperator").getter(getter(CrawlsFilter::filterOperatorAsString))
            .setter(setter(Builder::filterOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperator").build()).build();

    private static final SdkField<String> FIELD_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldValue").getter(getter(CrawlsFilter::fieldValue)).setter(setter(Builder::fieldValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            FILTER_OPERATOR_FIELD, FIELD_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FieldName", FIELD_NAME_FIELD);
                    put("FilterOperator", FILTER_OPERATOR_FIELD);
                    put("FieldValue", FIELD_VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String filterOperator;

    private final String fieldValue;

    private CrawlsFilter(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.filterOperator = builder.filterOperator;
        this.fieldValue = builder.fieldValue;
    }

    /**
     * <p>
     * A key used to filter the crawler runs for a specified crawler. Valid values for each of the field names are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CRAWL_ID</code>: A string representing the UUID identifier for a crawl.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STATE</code>: A string representing the state of the crawl.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>START_TIME</code> and <code>END_TIME</code>: The epoch timestamp in milliseconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DPU_HOUR</code>: The number of data processing unit (DPU) hours used for the crawl.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link FieldName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldNameAsString}.
     * </p>
     * 
     * @return A key used to filter the crawler runs for a specified crawler. Valid values for each of the field names
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CRAWL_ID</code>: A string representing the UUID identifier for a crawl.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STATE</code>: A string representing the state of the crawl.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>START_TIME</code> and <code>END_TIME</code>: The epoch timestamp in milliseconds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DPU_HOUR</code>: The number of data processing unit (DPU) hours used for the crawl.
     *         </p>
     *         </li>
     * @see FieldName
     */
    public final FieldName fieldName() {
        return FieldName.fromValue(fieldName);
    }

    /**
     * <p>
     * A key used to filter the crawler runs for a specified crawler. Valid values for each of the field names are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CRAWL_ID</code>: A string representing the UUID identifier for a crawl.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STATE</code>: A string representing the state of the crawl.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>START_TIME</code> and <code>END_TIME</code>: The epoch timestamp in milliseconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DPU_HOUR</code>: The number of data processing unit (DPU) hours used for the crawl.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link FieldName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldNameAsString}.
     * </p>
     * 
     * @return A key used to filter the crawler runs for a specified crawler. Valid values for each of the field names
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CRAWL_ID</code>: A string representing the UUID identifier for a crawl.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STATE</code>: A string representing the state of the crawl.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>START_TIME</code> and <code>END_TIME</code>: The epoch timestamp in milliseconds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DPU_HOUR</code>: The number of data processing unit (DPU) hours used for the crawl.
     *         </p>
     *         </li>
     * @see FieldName
     */
    public final String fieldNameAsString() {
        return fieldName;
    }

    /**
     * <p>
     * A defined comparator that operates on the value. The available operators are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>GT</code>: Greater than.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GE</code>: Greater than or equal to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LT</code>: Less than.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LE</code>: Less than or equal to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EQ</code>: Equal to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NE</code>: Not equal to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterOperator}
     * will return {@link FilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filterOperatorAsString}.
     * </p>
     * 
     * @return A defined comparator that operates on the value. The available operators are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>GT</code>: Greater than.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GE</code>: Greater than or equal to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LT</code>: Less than.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LE</code>: Less than or equal to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EQ</code>: Equal to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NE</code>: Not equal to.
     *         </p>
     *         </li>
     * @see FilterOperator
     */
    public final FilterOperator filterOperator() {
        return FilterOperator.fromValue(filterOperator);
    }

    /**
     * <p>
     * A defined comparator that operates on the value. The available operators are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>GT</code>: Greater than.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GE</code>: Greater than or equal to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LT</code>: Less than.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LE</code>: Less than or equal to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EQ</code>: Equal to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NE</code>: Not equal to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterOperator}
     * will return {@link FilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filterOperatorAsString}.
     * </p>
     * 
     * @return A defined comparator that operates on the value. The available operators are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>GT</code>: Greater than.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GE</code>: Greater than or equal to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LT</code>: Less than.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LE</code>: Less than or equal to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EQ</code>: Equal to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NE</code>: Not equal to.
     *         </p>
     *         </li>
     * @see FilterOperator
     */
    public final String filterOperatorAsString() {
        return filterOperator;
    }

    /**
     * <p>
     * The value provided for comparison on the crawl field.
     * </p>
     * 
     * @return The value provided for comparison on the crawl field.
     */
    public final String fieldValue() {
        return fieldValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlsFilter)) {
            return false;
        }
        CrawlsFilter other = (CrawlsFilter) obj;
        return Objects.equals(fieldNameAsString(), other.fieldNameAsString())
                && Objects.equals(filterOperatorAsString(), other.filterOperatorAsString())
                && Objects.equals(fieldValue(), other.fieldValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrawlsFilter").add("FieldName", fieldNameAsString())
                .add("FilterOperator", filterOperatorAsString()).add("FieldValue", fieldValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldNameAsString()));
        case "FilterOperator":
            return Optional.ofNullable(clazz.cast(filterOperatorAsString()));
        case "FieldValue":
            return Optional.ofNullable(clazz.cast(fieldValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CrawlsFilter, T> g) {
        return obj -> g.apply((CrawlsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrawlsFilter> {
        /**
         * <p>
         * A key used to filter the crawler runs for a specified crawler. Valid values for each of the field names are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CRAWL_ID</code>: A string representing the UUID identifier for a crawl.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STATE</code>: A string representing the state of the crawl.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>START_TIME</code> and <code>END_TIME</code>: The epoch timestamp in milliseconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DPU_HOUR</code>: The number of data processing unit (DPU) hours used for the crawl.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fieldName
         *        A key used to filter the crawler runs for a specified crawler. Valid values for each of the field
         *        names are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CRAWL_ID</code>: A string representing the UUID identifier for a crawl.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STATE</code>: A string representing the state of the crawl.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>START_TIME</code> and <code>END_TIME</code>: The epoch timestamp in milliseconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DPU_HOUR</code>: The number of data processing unit (DPU) hours used for the crawl.
         *        </p>
         *        </li>
         * @see FieldName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldName
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * A key used to filter the crawler runs for a specified crawler. Valid values for each of the field names are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CRAWL_ID</code>: A string representing the UUID identifier for a crawl.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STATE</code>: A string representing the state of the crawl.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>START_TIME</code> and <code>END_TIME</code>: The epoch timestamp in milliseconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DPU_HOUR</code>: The number of data processing unit (DPU) hours used for the crawl.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fieldName
         *        A key used to filter the crawler runs for a specified crawler. Valid values for each of the field
         *        names are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CRAWL_ID</code>: A string representing the UUID identifier for a crawl.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STATE</code>: A string representing the state of the crawl.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>START_TIME</code> and <code>END_TIME</code>: The epoch timestamp in milliseconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DPU_HOUR</code>: The number of data processing unit (DPU) hours used for the crawl.
         *        </p>
         *        </li>
         * @see FieldName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldName
         */
        Builder fieldName(FieldName fieldName);

        /**
         * <p>
         * A defined comparator that operates on the value. The available operators are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GT</code>: Greater than.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GE</code>: Greater than or equal to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LT</code>: Less than.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LE</code>: Less than or equal to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EQ</code>: Equal to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NE</code>: Not equal to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filterOperator
         *        A defined comparator that operates on the value. The available operators are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GT</code>: Greater than.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GE</code>: Greater than or equal to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LT</code>: Less than.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LE</code>: Less than or equal to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EQ</code>: Equal to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NE</code>: Not equal to.
         *        </p>
         *        </li>
         * @see FilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperator
         */
        Builder filterOperator(String filterOperator);

        /**
         * <p>
         * A defined comparator that operates on the value. The available operators are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GT</code>: Greater than.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GE</code>: Greater than or equal to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LT</code>: Less than.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LE</code>: Less than or equal to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EQ</code>: Equal to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NE</code>: Not equal to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filterOperator
         *        A defined comparator that operates on the value. The available operators are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GT</code>: Greater than.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GE</code>: Greater than or equal to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LT</code>: Less than.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LE</code>: Less than or equal to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EQ</code>: Equal to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NE</code>: Not equal to.
         *        </p>
         *        </li>
         * @see FilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperator
         */
        Builder filterOperator(FilterOperator filterOperator);

        /**
         * <p>
         * The value provided for comparison on the crawl field.
         * </p>
         * 
         * @param fieldValue
         *        The value provided for comparison on the crawl field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldValue(String fieldValue);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String filterOperator;

        private String fieldValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlsFilter model) {
            fieldName(model.fieldName);
            filterOperator(model.filterOperator);
            fieldValue(model.fieldValue);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public final Builder fieldName(FieldName fieldName) {
            this.fieldName(fieldName == null ? null : fieldName.toString());
            return this;
        }

        public final String getFilterOperator() {
            return filterOperator;
        }

        public final void setFilterOperator(String filterOperator) {
            this.filterOperator = filterOperator;
        }

        @Override
        public final Builder filterOperator(String filterOperator) {
            this.filterOperator = filterOperator;
            return this;
        }

        @Override
        public final Builder filterOperator(FilterOperator filterOperator) {
            this.filterOperator(filterOperator == null ? null : filterOperator.toString());
            return this;
        }

        public final String getFieldValue() {
            return fieldValue;
        }

        public final void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        @Override
        public final Builder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        @Override
        public CrawlsFilter build() {
            return new CrawlsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
