/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information for maintaining Data Catalog security.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCatalogEncryptionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DataCatalogEncryptionSettings.Builder, DataCatalogEncryptionSettings> {
    private static final SdkField<EncryptionAtRest> ENCRYPTION_AT_REST_FIELD = SdkField
            .<EncryptionAtRest> builder(MarshallingType.SDK_POJO).memberName("EncryptionAtRest")
            .getter(getter(DataCatalogEncryptionSettings::encryptionAtRest)).setter(setter(Builder::encryptionAtRest))
            .constructor(EncryptionAtRest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRest").build()).build();

    private static final SdkField<ConnectionPasswordEncryption> CONNECTION_PASSWORD_ENCRYPTION_FIELD = SdkField
            .<ConnectionPasswordEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionPasswordEncryption")
            .getter(getter(DataCatalogEncryptionSettings::connectionPasswordEncryption))
            .setter(setter(Builder::connectionPasswordEncryption))
            .constructor(ConnectionPasswordEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPasswordEncryption")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_AT_REST_FIELD,
            CONNECTION_PASSWORD_ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EncryptionAtRest", ENCRYPTION_AT_REST_FIELD);
                    put("ConnectionPasswordEncryption", CONNECTION_PASSWORD_ENCRYPTION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final EncryptionAtRest encryptionAtRest;

    private final ConnectionPasswordEncryption connectionPasswordEncryption;

    private DataCatalogEncryptionSettings(BuilderImpl builder) {
        this.encryptionAtRest = builder.encryptionAtRest;
        this.connectionPasswordEncryption = builder.connectionPasswordEncryption;
    }

    /**
     * <p>
     * Specifies the encryption-at-rest configuration for the Data Catalog.
     * </p>
     * 
     * @return Specifies the encryption-at-rest configuration for the Data Catalog.
     */
    public final EncryptionAtRest encryptionAtRest() {
        return encryptionAtRest;
    }

    /**
     * <p>
     * When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the
     * password as part of <code>CreateConnection</code> or <code>UpdateConnection</code> and store it in the
     * <code>ENCRYPTED_PASSWORD</code> field in the connection properties. You can enable catalog encryption or only
     * password encryption.
     * </p>
     * 
     * @return When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt
     *         the password as part of <code>CreateConnection</code> or <code>UpdateConnection</code> and store it in
     *         the <code>ENCRYPTED_PASSWORD</code> field in the connection properties. You can enable catalog encryption
     *         or only password encryption.
     */
    public final ConnectionPasswordEncryption connectionPasswordEncryption() {
        return connectionPasswordEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRest());
        hashCode = 31 * hashCode + Objects.hashCode(connectionPasswordEncryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogEncryptionSettings)) {
            return false;
        }
        DataCatalogEncryptionSettings other = (DataCatalogEncryptionSettings) obj;
        return Objects.equals(encryptionAtRest(), other.encryptionAtRest())
                && Objects.equals(connectionPasswordEncryption(), other.connectionPasswordEncryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataCatalogEncryptionSettings").add("EncryptionAtRest", encryptionAtRest())
                .add("ConnectionPasswordEncryption", connectionPasswordEncryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionAtRest":
            return Optional.ofNullable(clazz.cast(encryptionAtRest()));
        case "ConnectionPasswordEncryption":
            return Optional.ofNullable(clazz.cast(connectionPasswordEncryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataCatalogEncryptionSettings, T> g) {
        return obj -> g.apply((DataCatalogEncryptionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCatalogEncryptionSettings> {
        /**
         * <p>
         * Specifies the encryption-at-rest configuration for the Data Catalog.
         * </p>
         * 
         * @param encryptionAtRest
         *        Specifies the encryption-at-rest configuration for the Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRest(EncryptionAtRest encryptionAtRest);

        /**
         * <p>
         * Specifies the encryption-at-rest configuration for the Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionAtRest.Builder} avoiding the
         * need to create one manually via {@link EncryptionAtRest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionAtRest.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionAtRest(EncryptionAtRest)}.
         * 
         * @param encryptionAtRest
         *        a consumer that will call methods on {@link EncryptionAtRest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRest(EncryptionAtRest)
         */
        default Builder encryptionAtRest(Consumer<EncryptionAtRest.Builder> encryptionAtRest) {
            return encryptionAtRest(EncryptionAtRest.builder().applyMutation(encryptionAtRest).build());
        }

        /**
         * <p>
         * When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the
         * password as part of <code>CreateConnection</code> or <code>UpdateConnection</code> and store it in the
         * <code>ENCRYPTED_PASSWORD</code> field in the connection properties. You can enable catalog encryption or only
         * password encryption.
         * </p>
         * 
         * @param connectionPasswordEncryption
         *        When connection password protection is enabled, the Data Catalog uses a customer-provided key to
         *        encrypt the password as part of <code>CreateConnection</code> or <code>UpdateConnection</code> and
         *        store it in the <code>ENCRYPTED_PASSWORD</code> field in the connection properties. You can enable
         *        catalog encryption or only password encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPasswordEncryption(ConnectionPasswordEncryption connectionPasswordEncryption);

        /**
         * <p>
         * When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the
         * password as part of <code>CreateConnection</code> or <code>UpdateConnection</code> and store it in the
         * <code>ENCRYPTED_PASSWORD</code> field in the connection properties. You can enable catalog encryption or only
         * password encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionPasswordEncryption.Builder}
         * avoiding the need to create one manually via {@link ConnectionPasswordEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPasswordEncryption.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionPasswordEncryption(ConnectionPasswordEncryption)}.
         * 
         * @param connectionPasswordEncryption
         *        a consumer that will call methods on {@link ConnectionPasswordEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionPasswordEncryption(ConnectionPasswordEncryption)
         */
        default Builder connectionPasswordEncryption(Consumer<ConnectionPasswordEncryption.Builder> connectionPasswordEncryption) {
            return connectionPasswordEncryption(ConnectionPasswordEncryption.builder()
                    .applyMutation(connectionPasswordEncryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EncryptionAtRest encryptionAtRest;

        private ConnectionPasswordEncryption connectionPasswordEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogEncryptionSettings model) {
            encryptionAtRest(model.encryptionAtRest);
            connectionPasswordEncryption(model.connectionPasswordEncryption);
        }

        public final EncryptionAtRest.Builder getEncryptionAtRest() {
            return encryptionAtRest != null ? encryptionAtRest.toBuilder() : null;
        }

        public final void setEncryptionAtRest(EncryptionAtRest.BuilderImpl encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest != null ? encryptionAtRest.build() : null;
        }

        @Override
        public final Builder encryptionAtRest(EncryptionAtRest encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest;
            return this;
        }

        public final ConnectionPasswordEncryption.Builder getConnectionPasswordEncryption() {
            return connectionPasswordEncryption != null ? connectionPasswordEncryption.toBuilder() : null;
        }

        public final void setConnectionPasswordEncryption(ConnectionPasswordEncryption.BuilderImpl connectionPasswordEncryption) {
            this.connectionPasswordEncryption = connectionPasswordEncryption != null ? connectionPasswordEncryption.build()
                    : null;
        }

        @Override
        public final Builder connectionPasswordEncryption(ConnectionPasswordEncryption connectionPasswordEncryption) {
            this.connectionPasswordEncryption = connectionPasswordEncryption;
            return this;
        }

        @Override
        public DataCatalogEncryptionSettings build() {
            return new DataCatalogEncryptionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
