/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A specified entity does not exist
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityNotFoundException extends GlueException implements
        ToCopyableBuilder<EntityNotFoundException.Builder, EntityNotFoundException> {
    private static final SdkField<Boolean> FROM_FEDERATION_SOURCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FromFederationSource").getter(getter(EntityNotFoundException::fromFederationSource))
            .setter(setter(Builder::fromFederationSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromFederationSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FEDERATION_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FromFederationSource", FROM_FEDERATION_SOURCE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean fromFederationSource;

    private EntityNotFoundException(BuilderImpl builder) {
        super(builder);
        this.fromFederationSource = builder.fromFederationSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Indicates whether or not the exception relates to a federated source.
     * </p>
     * 
     * @return Indicates whether or not the exception relates to a federated source.
     */
    public Boolean fromFederationSource() {
        return fromFederationSource;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EntityNotFoundException, T> g) {
        return obj -> g.apply((EntityNotFoundException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityNotFoundException>, GlueException.Builder {
        /**
         * <p>
         * Indicates whether or not the exception relates to a federated source.
         * </p>
         * 
         * @param fromFederationSource
         *        Indicates whether or not the exception relates to a federated source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromFederationSource(Boolean fromFederationSource);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends GlueException.BuilderImpl implements Builder {
        private Boolean fromFederationSource;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityNotFoundException model) {
            super(model);
            fromFederationSource(model.fromFederationSource);
        }

        public final Boolean getFromFederationSource() {
            return fromFederationSource;
        }

        public final void setFromFederationSource(Boolean fromFederationSource) {
            this.fromFederationSource = fromFederationSource;
        }

        @Override
        public final Builder fromFederationSource(Boolean fromFederationSource) {
            this.fromFederationSource = fromFederationSource;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public EntityNotFoundException build() {
            return new EntityNotFoundException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
