/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCrawlerResponse extends GlueResponse implements
        ToCopyableBuilder<GetCrawlerResponse.Builder, GetCrawlerResponse> {
    private static final SdkField<Crawler> CRAWLER_FIELD = SdkField.<Crawler> builder(MarshallingType.SDK_POJO)
            .memberName("Crawler").getter(getter(GetCrawlerResponse::crawler)).setter(setter(Builder::crawler))
            .constructor(Crawler::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Crawler").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Crawler", CRAWLER_FIELD);
                }
            });

    private final Crawler crawler;

    private GetCrawlerResponse(BuilderImpl builder) {
        super(builder);
        this.crawler = builder.crawler;
    }

    /**
     * <p>
     * The metadata for the specified crawler.
     * </p>
     * 
     * @return The metadata for the specified crawler.
     */
    public final Crawler crawler() {
        return crawler;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crawler());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCrawlerResponse)) {
            return false;
        }
        GetCrawlerResponse other = (GetCrawlerResponse) obj;
        return Objects.equals(crawler(), other.crawler());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCrawlerResponse").add("Crawler", crawler()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Crawler":
            return Optional.ofNullable(clazz.cast(crawler()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCrawlerResponse, T> g) {
        return obj -> g.apply((GetCrawlerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCrawlerResponse> {
        /**
         * <p>
         * The metadata for the specified crawler.
         * </p>
         * 
         * @param crawler
         *        The metadata for the specified crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawler(Crawler crawler);

        /**
         * <p>
         * The metadata for the specified crawler.
         * </p>
         * This is a convenience method that creates an instance of the {@link Crawler.Builder} avoiding the need to
         * create one manually via {@link Crawler#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Crawler.Builder#build()} is called immediately and its result is
         * passed to {@link #crawler(Crawler)}.
         * 
         * @param crawler
         *        a consumer that will call methods on {@link Crawler.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crawler(Crawler)
         */
        default Builder crawler(Consumer<Crawler.Builder> crawler) {
            return crawler(Crawler.builder().applyMutation(crawler).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Crawler crawler;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCrawlerResponse model) {
            super(model);
            crawler(model.crawler);
        }

        public final Crawler.Builder getCrawler() {
            return crawler != null ? crawler.toBuilder() : null;
        }

        public final void setCrawler(Crawler.BuilderImpl crawler) {
            this.crawler = crawler != null ? crawler.build() : null;
        }

        @Override
        public final Builder crawler(Crawler crawler) {
            this.crawler = crawler;
            return this;
        }

        @Override
        public GetCrawlerResponse build() {
            return new GetCrawlerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
