/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a data store in Amazon Simple Storage Service (Amazon S3).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Target implements SdkPojo, Serializable, ToCopyableBuilder<S3Target.Builder, S3Target> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(S3Target::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<List<String>> EXCLUSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Exclusions")
            .getter(getter(S3Target::exclusions))
            .setter(setter(Builder::exclusions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(S3Target::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<Integer> SAMPLE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleSize").getter(getter(S3Target::sampleSize)).setter(setter(Builder::sampleSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleSize").build()).build();

    private static final SdkField<String> EVENT_QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventQueueArn").getter(getter(S3Target::eventQueueArn)).setter(setter(Builder::eventQueueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventQueueArn").build()).build();

    private static final SdkField<String> DLQ_EVENT_QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DlqEventQueueArn").getter(getter(S3Target::dlqEventQueueArn)).setter(setter(Builder::dlqEventQueueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlqEventQueueArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, EXCLUSIONS_FIELD,
            CONNECTION_NAME_FIELD, SAMPLE_SIZE_FIELD, EVENT_QUEUE_ARN_FIELD, DLQ_EVENT_QUEUE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Path", PATH_FIELD);
                    put("Exclusions", EXCLUSIONS_FIELD);
                    put("ConnectionName", CONNECTION_NAME_FIELD);
                    put("SampleSize", SAMPLE_SIZE_FIELD);
                    put("EventQueueArn", EVENT_QUEUE_ARN_FIELD);
                    put("DlqEventQueueArn", DLQ_EVENT_QUEUE_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String path;

    private final List<String> exclusions;

    private final String connectionName;

    private final Integer sampleSize;

    private final String eventQueueArn;

    private final String dlqEventQueueArn;

    private S3Target(BuilderImpl builder) {
        this.path = builder.path;
        this.exclusions = builder.exclusions;
        this.connectionName = builder.connectionName;
        this.sampleSize = builder.sampleSize;
        this.eventQueueArn = builder.eventQueueArn;
        this.dlqEventQueueArn = builder.dlqEventQueueArn;
    }

    /**
     * <p>
     * The path to the Amazon S3 target.
     * </p>
     * 
     * @return The path to the Amazon S3 target.
     */
    public final String path() {
        return path;
    }

    /**
     * For responses, this returns true if the service returned a value for the Exclusions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExclusions() {
        return exclusions != null && !(exclusions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of glob patterns used to exclude from the crawl. For more information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusions} method.
     * </p>
     * 
     * @return A list of glob patterns used to exclude from the crawl. For more information, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
     */
    public final List<String> exclusions() {
        return exclusions;
    }

    /**
     * <p>
     * The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual
     * Private Cloud environment (Amazon VPC).
     * </p>
     * 
     * @return The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon
     *         Virtual Private Cloud environment (Amazon VPC).
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set,
     * all the files are crawled. A valid value is an integer between 1 and 249.
     * </p>
     * 
     * @return Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If
     *         not set, all the files are crawled. A valid value is an integer between 1 and 249.
     */
    public final Integer sampleSize() {
        return sampleSize;
    }

    /**
     * <p>
     * A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.
     * </p>
     * 
     * @return A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.
     */
    public final String eventQueueArn() {
        return eventQueueArn;
    }

    /**
     * <p>
     * A valid Amazon dead-letter SQS ARN. For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code>.
     * </p>
     * 
     * @return A valid Amazon dead-letter SQS ARN. For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code>.
     */
    public final String dlqEventQueueArn() {
        return dlqEventQueueArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusions() ? exclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(eventQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(dlqEventQueueArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Target)) {
            return false;
        }
        S3Target other = (S3Target) obj;
        return Objects.equals(path(), other.path()) && hasExclusions() == other.hasExclusions()
                && Objects.equals(exclusions(), other.exclusions()) && Objects.equals(connectionName(), other.connectionName())
                && Objects.equals(sampleSize(), other.sampleSize()) && Objects.equals(eventQueueArn(), other.eventQueueArn())
                && Objects.equals(dlqEventQueueArn(), other.dlqEventQueueArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Target").add("Path", path()).add("Exclusions", hasExclusions() ? exclusions() : null)
                .add("ConnectionName", connectionName()).add("SampleSize", sampleSize()).add("EventQueueArn", eventQueueArn())
                .add("DlqEventQueueArn", dlqEventQueueArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Exclusions":
            return Optional.ofNullable(clazz.cast(exclusions()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "SampleSize":
            return Optional.ofNullable(clazz.cast(sampleSize()));
        case "EventQueueArn":
            return Optional.ofNullable(clazz.cast(eventQueueArn()));
        case "DlqEventQueueArn":
            return Optional.ofNullable(clazz.cast(dlqEventQueueArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3Target, T> g) {
        return obj -> g.apply((S3Target) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Target> {
        /**
         * <p>
         * The path to the Amazon S3 target.
         * </p>
         * 
         * @param path
         *        The path to the Amazon S3 target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * A list of glob patterns used to exclude from the crawl. For more information, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
         * </p>
         * 
         * @param exclusions
         *        A list of glob patterns used to exclude from the crawl. For more information, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusions(Collection<String> exclusions);

        /**
         * <p>
         * A list of glob patterns used to exclude from the crawl. For more information, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
         * </p>
         * 
         * @param exclusions
         *        A list of glob patterns used to exclude from the crawl. For more information, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusions(String... exclusions);

        /**
         * <p>
         * The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual
         * Private Cloud environment (Amazon VPC).
         * </p>
         * 
         * @param connectionName
         *        The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon
         *        Virtual Private Cloud environment (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not
         * set, all the files are crawled. A valid value is an integer between 1 and 249.
         * </p>
         * 
         * @param sampleSize
         *        Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If
         *        not set, all the files are crawled. A valid value is an integer between 1 and 249.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleSize(Integer sampleSize);

        /**
         * <p>
         * A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.
         * </p>
         * 
         * @param eventQueueArn
         *        A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventQueueArn(String eventQueueArn);

        /**
         * <p>
         * A valid Amazon dead-letter SQS ARN. For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code>.
         * </p>
         * 
         * @param dlqEventQueueArn
         *        A valid Amazon dead-letter SQS ARN. For example,
         *        <code>arn:aws:sqs:region:account:deadLetterQueue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dlqEventQueueArn(String dlqEventQueueArn);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private List<String> exclusions = DefaultSdkAutoConstructList.getInstance();

        private String connectionName;

        private Integer sampleSize;

        private String eventQueueArn;

        private String dlqEventQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Target model) {
            path(model.path);
            exclusions(model.exclusions);
            connectionName(model.connectionName);
            sampleSize(model.sampleSize);
            eventQueueArn(model.eventQueueArn);
            dlqEventQueueArn(model.dlqEventQueueArn);
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Collection<String> getExclusions() {
            if (exclusions instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusions;
        }

        public final void setExclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
        }

        @Override
        public final Builder exclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusions(String... exclusions) {
            exclusions(Arrays.asList(exclusions));
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Integer getSampleSize() {
            return sampleSize;
        }

        public final void setSampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getEventQueueArn() {
            return eventQueueArn;
        }

        public final void setEventQueueArn(String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
        }

        @Override
        public final Builder eventQueueArn(String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
            return this;
        }

        public final String getDlqEventQueueArn() {
            return dlqEventQueueArn;
        }

        public final void setDlqEventQueueArn(String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
        }

        @Override
        public final Builder dlqEventQueueArn(String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
            return this;
        }

        @Override
        public S3Target build() {
            return new S3Target(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
