/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a version of a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableVersion implements SdkPojo, Serializable, ToCopyableBuilder<TableVersion.Builder, TableVersion> {
    private static final SdkField<Table> TABLE_FIELD = SdkField.<Table> builder(MarshallingType.SDK_POJO).memberName("Table")
            .getter(getter(TableVersion::table)).setter(setter(Builder::table)).constructor(Table::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(TableVersion::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TABLE_FIELD, VERSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Table", TABLE_FIELD);
                    put("VersionId", VERSION_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Table table;

    private final String versionId;

    private TableVersion(BuilderImpl builder) {
        this.table = builder.table;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * The table in question.
     * </p>
     * 
     * @return The table in question.
     */
    public final Table table() {
        return table;
    }

    /**
     * <p>
     * The ID value that identifies this table version. A <code>VersionId</code> is a string representation of an
     * integer. Each version is incremented by 1.
     * </p>
     * 
     * @return The ID value that identifies this table version. A <code>VersionId</code> is a string representation of
     *         an integer. Each version is incremented by 1.
     */
    public final String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableVersion)) {
            return false;
        }
        TableVersion other = (TableVersion) obj;
        return Objects.equals(table(), other.table()) && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableVersion").add("Table", table()).add("VersionId", versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableVersion, T> g) {
        return obj -> g.apply((TableVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableVersion> {
        /**
         * <p>
         * The table in question.
         * </p>
         * 
         * @param table
         *        The table in question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(Table table);

        /**
         * <p>
         * The table in question.
         * </p>
         * This is a convenience method that creates an instance of the {@link Table.Builder} avoiding the need to
         * create one manually via {@link Table#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Table.Builder#build()} is called immediately and its result is
         * passed to {@link #table(Table)}.
         * 
         * @param table
         *        a consumer that will call methods on {@link Table.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #table(Table)
         */
        default Builder table(Consumer<Table.Builder> table) {
            return table(Table.builder().applyMutation(table).build());
        }

        /**
         * <p>
         * The ID value that identifies this table version. A <code>VersionId</code> is a string representation of an
         * integer. Each version is incremented by 1.
         * </p>
         * 
         * @param versionId
         *        The ID value that identifies this table version. A <code>VersionId</code> is a string representation
         *        of an integer. Each version is incremented by 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl implements Builder {
        private Table table;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(TableVersion model) {
            table(model.table);
            versionId(model.versionId);
        }

        public final Table.Builder getTable() {
            return table != null ? table.toBuilder() : null;
        }

        public final void setTable(Table.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(Table table) {
            this.table = table;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public TableVersion build() {
            return new TableVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
