/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DQResultsPublishingOptions;
import software.amazon.awssdk.services.glue.model.DQStopJobOnFailureOptions;
import software.amazon.awssdk.services.glue.model.DQTransformOutput;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateDataQuality
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluateDataQuality> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EvaluateDataQuality.getter(EvaluateDataQuality::name)).setter(EvaluateDataQuality.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(EvaluateDataQuality.getter(EvaluateDataQuality::inputs)).setter(EvaluateDataQuality.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ruleset").getter(EvaluateDataQuality.getter(EvaluateDataQuality::ruleset)).setter(EvaluateDataQuality.setter(Builder::ruleset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ruleset").build()}).build();
    private static final SdkField<String> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Output").getter(EvaluateDataQuality.getter(EvaluateDataQuality::outputAsString)).setter(EvaluateDataQuality.setter(Builder::output)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<DQResultsPublishingOptions> PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublishingOptions").getter(EvaluateDataQuality.getter(EvaluateDataQuality::publishingOptions)).setter(EvaluateDataQuality.setter(Builder::publishingOptions)).constructor(DQResultsPublishingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishingOptions").build()}).build();
    private static final SdkField<DQStopJobOnFailureOptions> STOP_JOB_ON_FAILURE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StopJobOnFailureOptions").getter(EvaluateDataQuality.getter(EvaluateDataQuality::stopJobOnFailureOptions)).setter(EvaluateDataQuality.setter(Builder::stopJobOnFailureOptions)).constructor(DQStopJobOnFailureOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopJobOnFailureOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, RULESET_FIELD, OUTPUT_FIELD, PUBLISHING_OPTIONS_FIELD, STOP_JOB_ON_FAILURE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Inputs", INPUTS_FIELD);
            this.put("Ruleset", RULESET_FIELD);
            this.put("Output", OUTPUT_FIELD);
            this.put("PublishingOptions", PUBLISHING_OPTIONS_FIELD);
            this.put("StopJobOnFailureOptions", STOP_JOB_ON_FAILURE_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final String ruleset;
    private final String output;
    private final DQResultsPublishingOptions publishingOptions;
    private final DQStopJobOnFailureOptions stopJobOnFailureOptions;

    private EvaluateDataQuality(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.ruleset = builder.ruleset;
        this.output = builder.output;
        this.publishingOptions = builder.publishingOptions;
        this.stopJobOnFailureOptions = builder.stopJobOnFailureOptions;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final String ruleset() {
        return this.ruleset;
    }

    public final DQTransformOutput output() {
        return DQTransformOutput.fromValue(this.output);
    }

    public final String outputAsString() {
        return this.output;
    }

    public final DQResultsPublishingOptions publishingOptions() {
        return this.publishingOptions;
    }

    public final DQStopJobOnFailureOptions stopJobOnFailureOptions() {
        return this.stopJobOnFailureOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleset());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopJobOnFailureOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateDataQuality)) {
            return false;
        }
        EvaluateDataQuality other = (EvaluateDataQuality)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.ruleset(), other.ruleset()) && Objects.equals(this.outputAsString(), other.outputAsString()) && Objects.equals(this.publishingOptions(), other.publishingOptions()) && Objects.equals(this.stopJobOnFailureOptions(), other.stopJobOnFailureOptions());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateDataQuality").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Ruleset", (Object)this.ruleset()).add("Output", (Object)this.outputAsString()).add("PublishingOptions", (Object)this.publishingOptions()).add("StopJobOnFailureOptions", (Object)this.stopJobOnFailureOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Ruleset": {
                return Optional.ofNullable(clazz.cast(this.ruleset()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.outputAsString()));
            }
            case "PublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.publishingOptions()));
            }
            case "StopJobOnFailureOptions": {
                return Optional.ofNullable(clazz.cast(this.stopJobOnFailureOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateDataQuality, T> g) {
        return obj -> g.apply((EvaluateDataQuality)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private String ruleset;
        private String output;
        private DQResultsPublishingOptions publishingOptions;
        private DQStopJobOnFailureOptions stopJobOnFailureOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateDataQuality model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.ruleset(model.ruleset);
            this.output(model.output);
            this.publishingOptions(model.publishingOptions);
            this.stopJobOnFailureOptions(model.stopJobOnFailureOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getRuleset() {
            return this.ruleset;
        }

        public final void setRuleset(String ruleset) {
            this.ruleset = ruleset;
        }

        @Override
        public final Builder ruleset(String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        public final String getOutput() {
            return this.output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        @Override
        public final Builder output(DQTransformOutput output) {
            this.output(output == null ? null : output.toString());
            return this;
        }

        public final DQResultsPublishingOptions.Builder getPublishingOptions() {
            return this.publishingOptions != null ? this.publishingOptions.toBuilder() : null;
        }

        public final void setPublishingOptions(DQResultsPublishingOptions.BuilderImpl publishingOptions) {
            this.publishingOptions = publishingOptions != null ? publishingOptions.build() : null;
        }

        @Override
        public final Builder publishingOptions(DQResultsPublishingOptions publishingOptions) {
            this.publishingOptions = publishingOptions;
            return this;
        }

        public final DQStopJobOnFailureOptions.Builder getStopJobOnFailureOptions() {
            return this.stopJobOnFailureOptions != null ? this.stopJobOnFailureOptions.toBuilder() : null;
        }

        public final void setStopJobOnFailureOptions(DQStopJobOnFailureOptions.BuilderImpl stopJobOnFailureOptions) {
            this.stopJobOnFailureOptions = stopJobOnFailureOptions != null ? stopJobOnFailureOptions.build() : null;
        }

        @Override
        public final Builder stopJobOnFailureOptions(DQStopJobOnFailureOptions stopJobOnFailureOptions) {
            this.stopJobOnFailureOptions = stopJobOnFailureOptions;
            return this;
        }

        public EvaluateDataQuality build() {
            return new EvaluateDataQuality(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluateDataQuality> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder ruleset(String var1);

        public Builder output(String var1);

        public Builder output(DQTransformOutput var1);

        public Builder publishingOptions(DQResultsPublishingOptions var1);

        default public Builder publishingOptions(Consumer<DQResultsPublishingOptions.Builder> publishingOptions) {
            return this.publishingOptions((DQResultsPublishingOptions)((DQResultsPublishingOptions.Builder)DQResultsPublishingOptions.builder().applyMutation(publishingOptions)).build());
        }

        public Builder stopJobOnFailureOptions(DQStopJobOnFailureOptions var1);

        default public Builder stopJobOnFailureOptions(Consumer<DQStopJobOnFailureOptions.Builder> stopJobOnFailureOptions) {
            return this.stopJobOnFailureOptions((DQStopJobOnFailureOptions)((DQStopJobOnFailureOptions.Builder)DQStopJobOnFailureOptions.builder().applyMutation(stopJobOnFailureOptions)).build());
        }
    }
}

