/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ConnectionTypeBrief;
import software.amazon.awssdk.services.glue.model.ConnectionTypeListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectionTypesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListConnectionTypesResponse> {
    private static final SdkField<List<ConnectionTypeBrief>> CONNECTION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionTypes").getter(ListConnectionTypesResponse.getter(ListConnectionTypesResponse::connectionTypes)).setter(ListConnectionTypesResponse.setter(Builder::connectionTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionTypeBrief::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConnectionTypesResponse.getter(ListConnectionTypesResponse::nextToken)).setter(ListConnectionTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConnectionTypes", CONNECTION_TYPES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConnectionTypeBrief> connectionTypes;
    private final String nextToken;

    private ListConnectionTypesResponse(BuilderImpl builder) {
        super(builder);
        this.connectionTypes = builder.connectionTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConnectionTypes() {
        return this.connectionTypes != null && !(this.connectionTypes instanceof SdkAutoConstructList);
    }

    public final List<ConnectionTypeBrief> connectionTypes() {
        return this.connectionTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionTypes() ? this.connectionTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionTypesResponse)) {
            return false;
        }
        ListConnectionTypesResponse other = (ListConnectionTypesResponse)((Object)obj);
        return this.hasConnectionTypes() == other.hasConnectionTypes() && Objects.equals(this.connectionTypes(), other.connectionTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectionTypesResponse").add("ConnectionTypes", this.hasConnectionTypes() ? this.connectionTypes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionTypes": {
                return Optional.ofNullable(clazz.cast(this.connectionTypes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionTypesResponse, T> g) {
        return obj -> g.apply((ListConnectionTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<ConnectionTypeBrief> connectionTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionTypesResponse model) {
            super(model);
            this.connectionTypes(model.connectionTypes);
            this.nextToken(model.nextToken);
        }

        public final List<ConnectionTypeBrief.Builder> getConnectionTypes() {
            List<ConnectionTypeBrief.Builder> result = ConnectionTypeListCopier.copyToBuilder(this.connectionTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionTypes(Collection<ConnectionTypeBrief.BuilderImpl> connectionTypes) {
            this.connectionTypes = ConnectionTypeListCopier.copyFromBuilder(connectionTypes);
        }

        @Override
        public final Builder connectionTypes(Collection<ConnectionTypeBrief> connectionTypes) {
            this.connectionTypes = ConnectionTypeListCopier.copy(connectionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionTypes(ConnectionTypeBrief ... connectionTypes) {
            this.connectionTypes(Arrays.asList(connectionTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionTypes(Consumer<ConnectionTypeBrief.Builder> ... connectionTypes) {
            this.connectionTypes(Stream.of(connectionTypes).map(c -> (ConnectionTypeBrief)((ConnectionTypeBrief.Builder)ConnectionTypeBrief.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectionTypesResponse build() {
            return new ListConnectionTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectionTypesResponse> {
        public Builder connectionTypes(Collection<ConnectionTypeBrief> var1);

        public Builder connectionTypes(ConnectionTypeBrief ... var1);

        public Builder connectionTypes(Consumer<ConnectionTypeBrief.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

