/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AdditionalContextMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuerySessionContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuerySessionContext> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(QuerySessionContext.getter(QuerySessionContext::queryId)).setter(QuerySessionContext.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<Instant> QUERY_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("QueryStartTime").getter(QuerySessionContext.getter(QuerySessionContext::queryStartTime)).setter(QuerySessionContext.setter(Builder::queryStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStartTime").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(QuerySessionContext.getter(QuerySessionContext::clusterId)).setter(QuerySessionContext.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> QUERY_AUTHORIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryAuthorizationId").getter(QuerySessionContext.getter(QuerySessionContext::queryAuthorizationId)).setter(QuerySessionContext.setter(Builder::queryAuthorizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAuthorizationId").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalContext").getter(QuerySessionContext.getter(QuerySessionContext::additionalContext)).setter(QuerySessionContext.setter(Builder::additionalContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, QUERY_START_TIME_FIELD, CLUSTER_ID_FIELD, QUERY_AUTHORIZATION_ID_FIELD, ADDITIONAL_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QueryId", QUERY_ID_FIELD);
            this.put("QueryStartTime", QUERY_START_TIME_FIELD);
            this.put("ClusterId", CLUSTER_ID_FIELD);
            this.put("QueryAuthorizationId", QUERY_AUTHORIZATION_ID_FIELD);
            this.put("AdditionalContext", ADDITIONAL_CONTEXT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String queryId;
    private final Instant queryStartTime;
    private final String clusterId;
    private final String queryAuthorizationId;
    private final Map<String, String> additionalContext;

    private QuerySessionContext(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryStartTime = builder.queryStartTime;
        this.clusterId = builder.clusterId;
        this.queryAuthorizationId = builder.queryAuthorizationId;
        this.additionalContext = builder.additionalContext;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final Instant queryStartTime() {
        return this.queryStartTime;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String queryAuthorizationId() {
        return this.queryAuthorizationId;
    }

    public final boolean hasAdditionalContext() {
        return this.additionalContext != null && !(this.additionalContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalContext() {
        return this.additionalContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAuthorizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalContext() ? this.additionalContext() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySessionContext)) {
            return false;
        }
        QuerySessionContext other = (QuerySessionContext)obj;
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.queryStartTime(), other.queryStartTime()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.queryAuthorizationId(), other.queryAuthorizationId()) && this.hasAdditionalContext() == other.hasAdditionalContext() && Objects.equals(this.additionalContext(), other.additionalContext());
    }

    public final String toString() {
        return ToString.builder((String)"QuerySessionContext").add("QueryId", (Object)this.queryId()).add("QueryStartTime", (Object)this.queryStartTime()).add("ClusterId", (Object)this.clusterId()).add("QueryAuthorizationId", (Object)this.queryAuthorizationId()).add("AdditionalContext", this.hasAdditionalContext() ? this.additionalContext() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "QueryStartTime": {
                return Optional.ofNullable(clazz.cast(this.queryStartTime()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "QueryAuthorizationId": {
                return Optional.ofNullable(clazz.cast(this.queryAuthorizationId()));
            }
            case "AdditionalContext": {
                return Optional.ofNullable(clazz.cast(this.additionalContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QuerySessionContext, T> g) {
        return obj -> g.apply((QuerySessionContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryId;
        private Instant queryStartTime;
        private String clusterId;
        private String queryAuthorizationId;
        private Map<String, String> additionalContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySessionContext model) {
            this.queryId(model.queryId);
            this.queryStartTime(model.queryStartTime);
            this.clusterId(model.clusterId);
            this.queryAuthorizationId(model.queryAuthorizationId);
            this.additionalContext(model.additionalContext);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final Instant getQueryStartTime() {
            return this.queryStartTime;
        }

        public final void setQueryStartTime(Instant queryStartTime) {
            this.queryStartTime = queryStartTime;
        }

        @Override
        public final Builder queryStartTime(Instant queryStartTime) {
            this.queryStartTime = queryStartTime;
            return this;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getQueryAuthorizationId() {
            return this.queryAuthorizationId;
        }

        public final void setQueryAuthorizationId(String queryAuthorizationId) {
            this.queryAuthorizationId = queryAuthorizationId;
        }

        @Override
        public final Builder queryAuthorizationId(String queryAuthorizationId) {
            this.queryAuthorizationId = queryAuthorizationId;
            return this;
        }

        public final Map<String, String> getAdditionalContext() {
            if (this.additionalContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalContext;
        }

        public final void setAdditionalContext(Map<String, String> additionalContext) {
            this.additionalContext = AdditionalContextMapCopier.copy(additionalContext);
        }

        @Override
        public final Builder additionalContext(Map<String, String> additionalContext) {
            this.additionalContext = AdditionalContextMapCopier.copy(additionalContext);
            return this;
        }

        public QuerySessionContext build() {
            return new QuerySessionContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuerySessionContext> {
        public Builder queryId(String var1);

        public Builder queryStartTime(Instant var1);

        public Builder clusterId(String var1);

        public Builder queryAuthorizationId(String var1);

        public Builder additionalContext(Map<String, String> var1);
    }
}

