/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RunIdentifier> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(RunIdentifier.getter(RunIdentifier::runId)).setter(RunIdentifier.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobRunId").getter(RunIdentifier.getter(RunIdentifier::jobRunId)).setter(RunIdentifier.setter(Builder::jobRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD, JOB_RUN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RunId", RUN_ID_FIELD);
            this.put("JobRunId", JOB_RUN_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String runId;
    private final String jobRunId;

    private RunIdentifier(BuilderImpl builder) {
        this.runId = builder.runId;
        this.jobRunId = builder.jobRunId;
    }

    public final String runId() {
        return this.runId;
    }

    public final String jobRunId() {
        return this.jobRunId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunIdentifier)) {
            return false;
        }
        RunIdentifier other = (RunIdentifier)obj;
        return Objects.equals(this.runId(), other.runId()) && Objects.equals(this.jobRunId(), other.jobRunId());
    }

    public final String toString() {
        return ToString.builder((String)"RunIdentifier").add("RunId", (Object)this.runId()).add("JobRunId", (Object)this.jobRunId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "JobRunId": {
                return Optional.ofNullable(clazz.cast(this.jobRunId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RunIdentifier, T> g) {
        return obj -> g.apply((RunIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String runId;
        private String jobRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(RunIdentifier model) {
            this.runId(model.runId);
            this.jobRunId(model.jobRunId);
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getJobRunId() {
            return this.jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public RunIdentifier build() {
            return new RunIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RunIdentifier> {
        public Builder runId(String var1);

        public Builder jobRunId(String var1);
    }
}

