/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.IntegrationPartition;
import software.amazon.awssdk.services.glue.model.IntegrationPartitionSpecListCopier;
import software.amazon.awssdk.services.glue.model.UnnestSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetTableConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetTableConfig> {
    private static final SdkField<String> UNNEST_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnnestSpec").getter(TargetTableConfig.getter(TargetTableConfig::unnestSpecAsString)).setter(TargetTableConfig.setter(Builder::unnestSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnnestSpec").build()}).build();
    private static final SdkField<List<IntegrationPartition>> PARTITION_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionSpec").getter(TargetTableConfig.getter(TargetTableConfig::partitionSpec)).setter(TargetTableConfig.setter(Builder::partitionSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSpec").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegrationPartition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetTableName").getter(TargetTableConfig.getter(TargetTableConfig::targetTableName)).setter(TargetTableConfig.setter(Builder::targetTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNNEST_SPEC_FIELD, PARTITION_SPEC_FIELD, TARGET_TABLE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UnnestSpec", UNNEST_SPEC_FIELD);
            this.put("PartitionSpec", PARTITION_SPEC_FIELD);
            this.put("TargetTableName", TARGET_TABLE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String unnestSpec;
    private final List<IntegrationPartition> partitionSpec;
    private final String targetTableName;

    private TargetTableConfig(BuilderImpl builder) {
        this.unnestSpec = builder.unnestSpec;
        this.partitionSpec = builder.partitionSpec;
        this.targetTableName = builder.targetTableName;
    }

    public final UnnestSpec unnestSpec() {
        return UnnestSpec.fromValue(this.unnestSpec);
    }

    public final String unnestSpecAsString() {
        return this.unnestSpec;
    }

    public final boolean hasPartitionSpec() {
        return this.partitionSpec != null && !(this.partitionSpec instanceof SdkAutoConstructList);
    }

    public final List<IntegrationPartition> partitionSpec() {
        return this.partitionSpec;
    }

    public final String targetTableName() {
        return this.targetTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unnestSpecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionSpec() ? this.partitionSpec() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTableConfig)) {
            return false;
        }
        TargetTableConfig other = (TargetTableConfig)obj;
        return Objects.equals(this.unnestSpecAsString(), other.unnestSpecAsString()) && this.hasPartitionSpec() == other.hasPartitionSpec() && Objects.equals(this.partitionSpec(), other.partitionSpec()) && Objects.equals(this.targetTableName(), other.targetTableName());
    }

    public final String toString() {
        return ToString.builder((String)"TargetTableConfig").add("UnnestSpec", (Object)this.unnestSpecAsString()).add("PartitionSpec", this.hasPartitionSpec() ? this.partitionSpec() : null).add("TargetTableName", (Object)this.targetTableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnnestSpec": {
                return Optional.ofNullable(clazz.cast(this.unnestSpecAsString()));
            }
            case "PartitionSpec": {
                return Optional.ofNullable(clazz.cast(this.partitionSpec()));
            }
            case "TargetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TargetTableConfig, T> g) {
        return obj -> g.apply((TargetTableConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String unnestSpec;
        private List<IntegrationPartition> partitionSpec = DefaultSdkAutoConstructList.getInstance();
        private String targetTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTableConfig model) {
            this.unnestSpec(model.unnestSpec);
            this.partitionSpec(model.partitionSpec);
            this.targetTableName(model.targetTableName);
        }

        public final String getUnnestSpec() {
            return this.unnestSpec;
        }

        public final void setUnnestSpec(String unnestSpec) {
            this.unnestSpec = unnestSpec;
        }

        @Override
        public final Builder unnestSpec(String unnestSpec) {
            this.unnestSpec = unnestSpec;
            return this;
        }

        @Override
        public final Builder unnestSpec(UnnestSpec unnestSpec) {
            this.unnestSpec(unnestSpec == null ? null : unnestSpec.toString());
            return this;
        }

        public final List<IntegrationPartition.Builder> getPartitionSpec() {
            List<IntegrationPartition.Builder> result = IntegrationPartitionSpecListCopier.copyToBuilder(this.partitionSpec);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionSpec(Collection<IntegrationPartition.BuilderImpl> partitionSpec) {
            this.partitionSpec = IntegrationPartitionSpecListCopier.copyFromBuilder(partitionSpec);
        }

        @Override
        public final Builder partitionSpec(Collection<IntegrationPartition> partitionSpec) {
            this.partitionSpec = IntegrationPartitionSpecListCopier.copy(partitionSpec);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSpec(IntegrationPartition ... partitionSpec) {
            this.partitionSpec(Arrays.asList(partitionSpec));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSpec(Consumer<IntegrationPartition.Builder> ... partitionSpec) {
            this.partitionSpec(Stream.of(partitionSpec).map(c -> (IntegrationPartition)((IntegrationPartition.Builder)IntegrationPartition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public TargetTableConfig build() {
            return new TargetTableConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetTableConfig> {
        public Builder unnestSpec(String var1);

        public Builder unnestSpec(UnnestSpec var1);

        public Builder partitionSpec(Collection<IntegrationPartition> var1);

        public Builder partitionSpec(IntegrationPartition ... var1);

        public Builder partitionSpec(Consumer<IntegrationPartition.Builder> ... var1);

        public Builder targetTableName(String var1);
    }
}

