/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object that shows the details of the column stats run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnStatisticsTaskRun implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnStatisticsTaskRun.Builder, ColumnStatisticsTaskRun> {
    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerId").getter(getter(ColumnStatisticsTaskRun::customerId)).setter(setter(Builder::customerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerId").build()).build();

    private static final SdkField<String> COLUMN_STATISTICS_TASK_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnStatisticsTaskRunId").getter(getter(ColumnStatisticsTaskRun::columnStatisticsTaskRunId))
            .setter(setter(Builder::columnStatisticsTaskRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRunId").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(ColumnStatisticsTaskRun::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(ColumnStatisticsTaskRun::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<List<String>> COLUMN_NAME_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ColumnNameList")
            .getter(getter(ColumnStatisticsTaskRun::columnNameList))
            .setter(setter(Builder::columnNameList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNameList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogID").getter(getter(ColumnStatisticsTaskRun::catalogID)).setter(setter(Builder::catalogID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogID").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(ColumnStatisticsTaskRun::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<Double> SAMPLE_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SampleSize").getter(getter(ColumnStatisticsTaskRun::sampleSize)).setter(setter(Builder::sampleSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleSize").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(ColumnStatisticsTaskRun::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(ColumnStatisticsTaskRun::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkerType").getter(getter(ColumnStatisticsTaskRun::workerType)).setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()).build();

    private static final SdkField<String> COMPUTATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputationType").getter(getter(ColumnStatisticsTaskRun::computationTypeAsString))
            .setter(setter(Builder::computationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ColumnStatisticsTaskRun::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ColumnStatisticsTaskRun::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(ColumnStatisticsTaskRun::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ColumnStatisticsTaskRun::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ColumnStatisticsTaskRun::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(ColumnStatisticsTaskRun::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Double> DPU_SECONDS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DPUSeconds").getter(getter(ColumnStatisticsTaskRun::dpuSeconds)).setter(setter(Builder::dpuSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPUSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ID_FIELD,
            COLUMN_STATISTICS_TASK_RUN_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, COLUMN_NAME_LIST_FIELD, CATALOG_ID_FIELD,
            ROLE_FIELD, SAMPLE_SIZE_FIELD, SECURITY_CONFIGURATION_FIELD, NUMBER_OF_WORKERS_FIELD, WORKER_TYPE_FIELD,
            COMPUTATION_TYPE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            ERROR_MESSAGE_FIELD, DPU_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customerId;

    private final String columnStatisticsTaskRunId;

    private final String databaseName;

    private final String tableName;

    private final List<String> columnNameList;

    private final String catalogID;

    private final String role;

    private final Double sampleSize;

    private final String securityConfiguration;

    private final Integer numberOfWorkers;

    private final String workerType;

    private final String computationType;

    private final String status;

    private final Instant creationTime;

    private final Instant lastUpdated;

    private final Instant startTime;

    private final Instant endTime;

    private final String errorMessage;

    private final Double dpuSeconds;

    private ColumnStatisticsTaskRun(BuilderImpl builder) {
        this.customerId = builder.customerId;
        this.columnStatisticsTaskRunId = builder.columnStatisticsTaskRunId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.columnNameList = builder.columnNameList;
        this.catalogID = builder.catalogID;
        this.role = builder.role;
        this.sampleSize = builder.sampleSize;
        this.securityConfiguration = builder.securityConfiguration;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.workerType = builder.workerType;
        this.computationType = builder.computationType;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.errorMessage = builder.errorMessage;
        this.dpuSeconds = builder.dpuSeconds;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String customerId() {
        return customerId;
    }

    /**
     * <p>
     * The identifier for the particular column statistics task run.
     * </p>
     * 
     * @return The identifier for the particular column statistics task run.
     */
    public final String columnStatisticsTaskRunId() {
        return columnStatisticsTaskRunId;
    }

    /**
     * <p>
     * The database where the table resides.
     * </p>
     * 
     * @return The database where the table resides.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table for which column statistics is generated.
     * </p>
     * 
     * @return The name of the table for which column statistics is generated.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnNameList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnNameList() {
        return columnNameList != null && !(columnNameList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the column names. If none is supplied, all column names for the table will be used by default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnNameList} method.
     * </p>
     * 
     * @return A list of the column names. If none is supplied, all column names for the table will be used by default.
     */
    public final List<String> columnNameList() {
        return columnNameList;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the table resides. If none is supplied, the Amazon Web Services account ID is
     * used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the table resides. If none is supplied, the Amazon Web Services account
     *         ID is used by default.
     */
    public final String catalogID() {
        return catalogID;
    }

    /**
     * <p>
     * The IAM role that the service assumes to generate statistics.
     * </p>
     * 
     * @return The IAM role that the service assumes to generate statistics.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The percentage of rows used to generate statistics. If none is supplied, the entire table will be used to
     * generate stats.
     * </p>
     * 
     * @return The percentage of rows used to generate statistics. If none is supplied, the entire table will be used to
     *         generate stats.
     */
    public final Double sampleSize() {
        return sampleSize;
    }

    /**
     * <p>
     * Name of the security configuration that is used to encrypt CloudWatch logs for the column stats task run.
     * </p>
     * 
     * @return Name of the security configuration that is used to encrypt CloudWatch logs for the column stats task run.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * <p>
     * The number of workers used to generate column statistics. The job is preconfigured to autoscale up to 25
     * instances.
     * </p>
     * 
     * @return The number of workers used to generate column statistics. The job is preconfigured to autoscale up to 25
     *         instances.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The type of workers being used for generating stats. The default is <code>g.1x</code>.
     * </p>
     * 
     * @return The type of workers being used for generating stats. The default is <code>g.1x</code>.
     */
    public final String workerType() {
        return workerType;
    }

    /**
     * <p>
     * The type of column statistics computation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computationType}
     * will return {@link ComputationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computationTypeAsString}.
     * </p>
     * 
     * @return The type of column statistics computation.
     * @see ComputationType
     */
    public final ComputationType computationType() {
        return ComputationType.fromValue(computationType);
    }

    /**
     * <p>
     * The type of column statistics computation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computationType}
     * will return {@link ComputationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computationTypeAsString}.
     * </p>
     * 
     * @return The type of column statistics computation.
     * @see ComputationType
     */
    public final String computationTypeAsString() {
        return computationType;
    }

    /**
     * <p>
     * The status of the task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ColumnStatisticsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task run.
     * @see ColumnStatisticsState
     */
    public final ColumnStatisticsState status() {
        return ColumnStatisticsState.fromValue(status);
    }

    /**
     * <p>
     * The status of the task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ColumnStatisticsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task run.
     * @see ColumnStatisticsState
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time that this task was created.
     * </p>
     * 
     * @return The time that this task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last point in time when this task was modified.
     * </p>
     * 
     * @return The last point in time when this task was modified.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The start time of the task.
     * </p>
     * 
     * @return The start time of the task.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the task.
     * </p>
     * 
     * @return The end time of the task.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The error message for the job.
     * </p>
     * 
     * @return The error message for the job.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The calculated DPU usage in seconds for all autoscaled workers.
     * </p>
     * 
     * @return The calculated DPU usage in seconds for all autoscaled workers.
     */
    public final Double dpuSeconds() {
        return dpuSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerId());
        hashCode = 31 * hashCode + Objects.hashCode(columnStatisticsTaskRunId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnNameList() ? columnNameList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(catalogID());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(workerType());
        hashCode = 31 * hashCode + Objects.hashCode(computationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(dpuSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatisticsTaskRun)) {
            return false;
        }
        ColumnStatisticsTaskRun other = (ColumnStatisticsTaskRun) obj;
        return Objects.equals(customerId(), other.customerId())
                && Objects.equals(columnStatisticsTaskRunId(), other.columnStatisticsTaskRunId())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && hasColumnNameList() == other.hasColumnNameList() && Objects.equals(columnNameList(), other.columnNameList())
                && Objects.equals(catalogID(), other.catalogID()) && Objects.equals(role(), other.role())
                && Objects.equals(sampleSize(), other.sampleSize())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(workerType(), other.workerType())
                && Objects.equals(computationTypeAsString(), other.computationTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(lastUpdated(), other.lastUpdated())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(dpuSeconds(), other.dpuSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnStatisticsTaskRun").add("CustomerId", customerId())
                .add("ColumnStatisticsTaskRunId", columnStatisticsTaskRunId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("ColumnNameList", hasColumnNameList() ? columnNameList() : null)
                .add("CatalogID", catalogID()).add("Role", role()).add("SampleSize", sampleSize())
                .add("SecurityConfiguration", securityConfiguration()).add("NumberOfWorkers", numberOfWorkers())
                .add("WorkerType", workerType()).add("ComputationType", computationTypeAsString())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).add("LastUpdated", lastUpdated())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("ErrorMessage", errorMessage())
                .add("DPUSeconds", dpuSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerId":
            return Optional.ofNullable(clazz.cast(customerId()));
        case "ColumnStatisticsTaskRunId":
            return Optional.ofNullable(clazz.cast(columnStatisticsTaskRunId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "ColumnNameList":
            return Optional.ofNullable(clazz.cast(columnNameList()));
        case "CatalogID":
            return Optional.ofNullable(clazz.cast(catalogID()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "SampleSize":
            return Optional.ofNullable(clazz.cast(sampleSize()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "WorkerType":
            return Optional.ofNullable(clazz.cast(workerType()));
        case "ComputationType":
            return Optional.ofNullable(clazz.cast(computationTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "DPUSeconds":
            return Optional.ofNullable(clazz.cast(dpuSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatisticsTaskRun, T> g) {
        return obj -> g.apply((ColumnStatisticsTaskRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnStatisticsTaskRun> {
        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param customerId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerId(String customerId);

        /**
         * <p>
         * The identifier for the particular column statistics task run.
         * </p>
         * 
         * @param columnStatisticsTaskRunId
         *        The identifier for the particular column statistics task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsTaskRunId(String columnStatisticsTaskRunId);

        /**
         * <p>
         * The database where the table resides.
         * </p>
         * 
         * @param databaseName
         *        The database where the table resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table for which column statistics is generated.
         * </p>
         * 
         * @param tableName
         *        The name of the table for which column statistics is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A list of the column names. If none is supplied, all column names for the table will be used by default.
         * </p>
         * 
         * @param columnNameList
         *        A list of the column names. If none is supplied, all column names for the table will be used by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNameList(Collection<String> columnNameList);

        /**
         * <p>
         * A list of the column names. If none is supplied, all column names for the table will be used by default.
         * </p>
         * 
         * @param columnNameList
         *        A list of the column names. If none is supplied, all column names for the table will be used by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNameList(String... columnNameList);

        /**
         * <p>
         * The ID of the Data Catalog where the table resides. If none is supplied, the Amazon Web Services account ID
         * is used by default.
         * </p>
         * 
         * @param catalogID
         *        The ID of the Data Catalog where the table resides. If none is supplied, the Amazon Web Services
         *        account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogID(String catalogID);

        /**
         * <p>
         * The IAM role that the service assumes to generate statistics.
         * </p>
         * 
         * @param role
         *        The IAM role that the service assumes to generate statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The percentage of rows used to generate statistics. If none is supplied, the entire table will be used to
         * generate stats.
         * </p>
         * 
         * @param sampleSize
         *        The percentage of rows used to generate statistics. If none is supplied, the entire table will be used
         *        to generate stats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleSize(Double sampleSize);

        /**
         * <p>
         * Name of the security configuration that is used to encrypt CloudWatch logs for the column stats task run.
         * </p>
         * 
         * @param securityConfiguration
         *        Name of the security configuration that is used to encrypt CloudWatch logs for the column stats task
         *        run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * The number of workers used to generate column statistics. The job is preconfigured to autoscale up to 25
         * instances.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers used to generate column statistics. The job is preconfigured to autoscale up to
         *        25 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The type of workers being used for generating stats. The default is <code>g.1x</code>.
         * </p>
         * 
         * @param workerType
         *        The type of workers being used for generating stats. The default is <code>g.1x</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerType(String workerType);

        /**
         * <p>
         * The type of column statistics computation.
         * </p>
         * 
         * @param computationType
         *        The type of column statistics computation.
         * @see ComputationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationType
         */
        Builder computationType(String computationType);

        /**
         * <p>
         * The type of column statistics computation.
         * </p>
         * 
         * @param computationType
         *        The type of column statistics computation.
         * @see ComputationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationType
         */
        Builder computationType(ComputationType computationType);

        /**
         * <p>
         * The status of the task run.
         * </p>
         * 
         * @param status
         *        The status of the task run.
         * @see ColumnStatisticsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnStatisticsState
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the task run.
         * </p>
         * 
         * @param status
         *        The status of the task run.
         * @see ColumnStatisticsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnStatisticsState
         */
        Builder status(ColumnStatisticsState status);

        /**
         * <p>
         * The time that this task was created.
         * </p>
         * 
         * @param creationTime
         *        The time that this task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last point in time when this task was modified.
         * </p>
         * 
         * @param lastUpdated
         *        The last point in time when this task was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The start time of the task.
         * </p>
         * 
         * @param startTime
         *        The start time of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the task.
         * </p>
         * 
         * @param endTime
         *        The end time of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The error message for the job.
         * </p>
         * 
         * @param errorMessage
         *        The error message for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The calculated DPU usage in seconds for all autoscaled workers.
         * </p>
         * 
         * @param dpuSeconds
         *        The calculated DPU usage in seconds for all autoscaled workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpuSeconds(Double dpuSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String customerId;

        private String columnStatisticsTaskRunId;

        private String databaseName;

        private String tableName;

        private List<String> columnNameList = DefaultSdkAutoConstructList.getInstance();

        private String catalogID;

        private String role;

        private Double sampleSize;

        private String securityConfiguration;

        private Integer numberOfWorkers;

        private String workerType;

        private String computationType;

        private String status;

        private Instant creationTime;

        private Instant lastUpdated;

        private Instant startTime;

        private Instant endTime;

        private String errorMessage;

        private Double dpuSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatisticsTaskRun model) {
            customerId(model.customerId);
            columnStatisticsTaskRunId(model.columnStatisticsTaskRunId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            columnNameList(model.columnNameList);
            catalogID(model.catalogID);
            role(model.role);
            sampleSize(model.sampleSize);
            securityConfiguration(model.securityConfiguration);
            numberOfWorkers(model.numberOfWorkers);
            workerType(model.workerType);
            computationType(model.computationType);
            status(model.status);
            creationTime(model.creationTime);
            lastUpdated(model.lastUpdated);
            startTime(model.startTime);
            endTime(model.endTime);
            errorMessage(model.errorMessage);
            dpuSeconds(model.dpuSeconds);
        }

        public final String getCustomerId() {
            return customerId;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final String getColumnStatisticsTaskRunId() {
            return columnStatisticsTaskRunId;
        }

        public final void setColumnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
        }

        @Override
        public final Builder columnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Collection<String> getColumnNameList() {
            if (columnNameList instanceof SdkAutoConstructList) {
                return null;
            }
            return columnNameList;
        }

        public final void setColumnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
        }

        @Override
        public final Builder columnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNameList(String... columnNameList) {
            columnNameList(Arrays.asList(columnNameList));
            return this;
        }

        public final String getCatalogID() {
            return catalogID;
        }

        public final void setCatalogID(String catalogID) {
            this.catalogID = catalogID;
        }

        @Override
        public final Builder catalogID(String catalogID) {
            this.catalogID = catalogID;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Double getSampleSize() {
            return sampleSize;
        }

        public final void setSampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getWorkerType() {
            return workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        public final String getComputationType() {
            return computationType;
        }

        public final void setComputationType(String computationType) {
            this.computationType = computationType;
        }

        @Override
        public final Builder computationType(String computationType) {
            this.computationType = computationType;
            return this;
        }

        @Override
        public final Builder computationType(ComputationType computationType) {
            this.computationType(computationType == null ? null : computationType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ColumnStatisticsState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Double getDpuSeconds() {
            return dpuSeconds;
        }

        public final void setDpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
        }

        @Override
        public final Builder dpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
            return this;
        }

        @Override
        public ColumnStatisticsTaskRun build() {
            return new ColumnStatisticsTaskRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
