/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A development endpoint where a developer can remotely debug extract, transform, and load (ETL) scripts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DevEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<DevEndpoint.Builder, DevEndpoint> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(DevEndpoint::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DevEndpoint::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(DevEndpoint::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(DevEndpoint::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> YARN_ENDPOINT_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("YarnEndpointAddress").getter(getter(DevEndpoint::yarnEndpointAddress))
            .setter(setter(Builder::yarnEndpointAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YarnEndpointAddress").build())
            .build();

    private static final SdkField<String> PRIVATE_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateAddress").getter(getter(DevEndpoint::privateAddress)).setter(setter(Builder::privateAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateAddress").build()).build();

    private static final SdkField<Integer> ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ZeppelinRemoteSparkInterpreterPort")
            .getter(getter(DevEndpoint::zeppelinRemoteSparkInterpreterPort))
            .setter(setter(Builder::zeppelinRemoteSparkInterpreterPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZeppelinRemoteSparkInterpreterPort")
                    .build()).build();

    private static final SdkField<String> PUBLIC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicAddress").getter(getter(DevEndpoint::publicAddress)).setter(setter(Builder::publicAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAddress").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DevEndpoint::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkerType").getter(getter(DevEndpoint::workerTypeAsString)).setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()).build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlueVersion").getter(getter(DevEndpoint::glueVersion)).setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(DevEndpoint::numberOfWorkers)).setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfNodes").getter(getter(DevEndpoint::numberOfNodes)).setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(DevEndpoint::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(DevEndpoint::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> EXTRA_PYTHON_LIBS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtraPythonLibsS3Path").getter(getter(DevEndpoint::extraPythonLibsS3Path))
            .setter(setter(Builder::extraPythonLibsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraPythonLibsS3Path").build())
            .build();

    private static final SdkField<String> EXTRA_JARS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtraJarsS3Path").getter(getter(DevEndpoint::extraJarsS3Path)).setter(setter(Builder::extraJarsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraJarsS3Path").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DevEndpoint::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> LAST_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdateStatus").getter(getter(DevEndpoint::lastUpdateStatus))
            .setter(setter(Builder::lastUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(DevEndpoint::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimestamp").getter(getter(DevEndpoint::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build())
            .build();

    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicKey").getter(getter(DevEndpoint::publicKey)).setter(setter(Builder::publicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()).build();

    private static final SdkField<List<String>> PUBLIC_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PublicKeys")
            .getter(getter(DevEndpoint::publicKeys))
            .setter(setter(Builder::publicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(DevEndpoint::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Arguments")
            .getter(getter(DevEndpoint::arguments))
            .setter(setter(Builder::arguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            ROLE_ARN_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, YARN_ENDPOINT_ADDRESS_FIELD, PRIVATE_ADDRESS_FIELD,
            ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD, PUBLIC_ADDRESS_FIELD, STATUS_FIELD, WORKER_TYPE_FIELD,
            GLUE_VERSION_FIELD, NUMBER_OF_WORKERS_FIELD, NUMBER_OF_NODES_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD,
            EXTRA_PYTHON_LIBS_S3_PATH_FIELD, EXTRA_JARS_S3_PATH_FIELD, FAILURE_REASON_FIELD, LAST_UPDATE_STATUS_FIELD,
            CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, PUBLIC_KEY_FIELD, PUBLIC_KEYS_FIELD,
            SECURITY_CONFIGURATION_FIELD, ARGUMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointName;

    private final String roleArn;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final String yarnEndpointAddress;

    private final String privateAddress;

    private final Integer zeppelinRemoteSparkInterpreterPort;

    private final String publicAddress;

    private final String status;

    private final String workerType;

    private final String glueVersion;

    private final Integer numberOfWorkers;

    private final Integer numberOfNodes;

    private final String availabilityZone;

    private final String vpcId;

    private final String extraPythonLibsS3Path;

    private final String extraJarsS3Path;

    private final String failureReason;

    private final String lastUpdateStatus;

    private final Instant createdTimestamp;

    private final Instant lastModifiedTimestamp;

    private final String publicKey;

    private final List<String> publicKeys;

    private final String securityConfiguration;

    private final Map<String, String> arguments;

    private DevEndpoint(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.roleArn = builder.roleArn;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.yarnEndpointAddress = builder.yarnEndpointAddress;
        this.privateAddress = builder.privateAddress;
        this.zeppelinRemoteSparkInterpreterPort = builder.zeppelinRemoteSparkInterpreterPort;
        this.publicAddress = builder.publicAddress;
        this.status = builder.status;
        this.workerType = builder.workerType;
        this.glueVersion = builder.glueVersion;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.numberOfNodes = builder.numberOfNodes;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
        this.failureReason = builder.failureReason;
        this.lastUpdateStatus = builder.lastUpdateStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.publicKey = builder.publicKey;
        this.publicKeys = builder.publicKeys;
        this.securityConfiguration = builder.securityConfiguration;
        this.arguments = builder.arguments;
    }

    /**
     * <p>
     * The name of the <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The name of the <code>DevEndpoint</code>.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used in this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used in this <code>DevEndpoint</code>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security group identifiers used in this <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of security group identifiers used in this <code>DevEndpoint</code>.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The subnet ID for this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The subnet ID for this <code>DevEndpoint</code>.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The YARN endpoint address used by this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The YARN endpoint address used by this <code>DevEndpoint</code>.
     */
    public final String yarnEndpointAddress() {
        return yarnEndpointAddress;
    }

    /**
     * <p>
     * A private IP address to access the <code>DevEndpoint</code> within a VPC if the <code>DevEndpoint</code> is
     * created within one. The <code>PrivateAddress</code> field is present only when you create the
     * <code>DevEndpoint</code> within your VPC.
     * </p>
     * 
     * @return A private IP address to access the <code>DevEndpoint</code> within a VPC if the <code>DevEndpoint</code>
     *         is created within one. The <code>PrivateAddress</code> field is present only when you create the
     *         <code>DevEndpoint</code> within your VPC.
     */
    public final String privateAddress() {
        return privateAddress;
    }

    /**
     * <p>
     * The Apache Zeppelin port for the remote Apache Spark interpreter.
     * </p>
     * 
     * @return The Apache Zeppelin port for the remote Apache Spark interpreter.
     */
    public final Integer zeppelinRemoteSparkInterpreterPort() {
        return zeppelinRemoteSparkInterpreterPort;
    }

    /**
     * <p>
     * The public IP address used by this <code>DevEndpoint</code>. The <code>PublicAddress</code> field is present only
     * when you create a non-virtual private cloud (VPC) <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The public IP address used by this <code>DevEndpoint</code>. The <code>PublicAddress</code> field is
     *         present only when you create a non-virtual private cloud (VPC) <code>DevEndpoint</code>.
     */
    public final String publicAddress() {
        return publicAddress;
    }

    /**
     * <p>
     * The current status of this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The current status of this <code>DevEndpoint</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X,
     * or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
     * configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB
     * disk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard,
     *         G.1X, or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
     *         configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a
     *         64 GB disk.
     * @see WorkerType
     */
    public final WorkerType workerType() {
        return WorkerType.fromValue(workerType);
    }

    /**
     * <p>
     * The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X,
     * or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
     * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
     * configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB
     * disk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard,
     *         G.1X, or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk),
     *         and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
     *         configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a
     *         64 GB disk.
     * @see WorkerType
     */
    public final String workerTypeAsString() {
        return workerType;
    }

    /**
     * <p>
     * Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates
     * the version supported for running your ETL scripts on development endpoints.
     * </p>
     * <p>
     * For more information about the available Glue versions and corresponding Spark and Python versions, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
     * </p>
     * <p>
     * Development endpoints that are created without specifying a Glue version default to Glue 0.9.
     * </p>
     * <p>
     * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
     * provided, the version defaults to Python 2.
     * </p>
     * 
     * @return Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version
     *         indicates the version supported for running your ETL scripts on development endpoints. </p>
     *         <p>
     *         For more information about the available Glue versions and corresponding Spark and Python versions, see
     *         <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer
     *         guide.
     *         </p>
     *         <p>
     *         Development endpoints that are created without specifying a Glue version default to Glue 0.9.
     *         </p>
     *         <p>
     *         You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     *         parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments
     *         are provided, the version defaults to Python 2.
     */
    public final String glueVersion() {
        return glueVersion;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
     * </p>
     * <p>
     * The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>.
     * </p>
     * 
     * @return The number of workers of a defined <code>workerType</code> that are allocated to the development
     *         endpoint.</p>
     *         <p>
     *         The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The number of Glue Data Processing Units (DPUs) allocated to this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The number of Glue Data Processing Units (DPUs) allocated to this <code>DevEndpoint</code>.
     */
    public final Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * The Amazon Web Services Availability Zone where this <code>DevEndpoint</code> is located.
     * </p>
     * 
     * @return The Amazon Web Services Availability Zone where this <code>DevEndpoint</code> is located.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your
     * <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.
     * </p>
     * <note>
     * <p>
     * You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C extensions, such
     * as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are not currently supported.
     * </p>
     * </note>
     * 
     * @return The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your
     *         <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.</p> <note>
     *         <p>
     *         You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C
     *         extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are
     *         not currently supported.
     *         </p>
     */
    public final String extraPythonLibsS3Path() {
        return extraPythonLibsS3Path;
    }

    /**
     * <p>
     * The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
     * <code>DevEndpoint</code>.
     * </p>
     * <note>
     * <p>
     * You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.
     * </p>
     * </note>
     * 
     * @return The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
     *         <code>DevEndpoint</code>.</p> <note>
     *         <p>
     *         You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.
     *         </p>
     */
    public final String extraJarsS3Path() {
        return extraJarsS3Path;
    }

    /**
     * <p>
     * The reason for a current failure in this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The reason for a current failure in this <code>DevEndpoint</code>.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The status of the last update.
     * </p>
     * 
     * @return The status of the last update.
     */
    public final String lastUpdateStatus() {
        return lastUpdateStatus;
    }

    /**
     * <p>
     * The point in time at which this DevEndpoint was created.
     * </p>
     * 
     * @return The point in time at which this DevEndpoint was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The point in time at which this <code>DevEndpoint</code> was last modified.
     * </p>
     * 
     * @return The point in time at which this <code>DevEndpoint</code> was last modified.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is provided for
     * backward compatibility because the recommended attribute to use is public keys.
     * </p>
     * 
     * @return The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is provided
     *         for backward compatibility because the recommended attribute to use is public keys.
     */
    public final String publicKey() {
        return publicKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublicKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPublicKeys() {
        return publicKeys != null && !(publicKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of public keys to be used by the <code>DevEndpoints</code> for authentication. Using this attribute is
     * preferred over a single public key because the public keys allow you to have a different private key per client.
     * </p>
     * <note>
     * <p>
     * If you previously created an endpoint with a public key, you must remove that key to be able to set a list of
     * public keys. Call the <code>UpdateDevEndpoint</code> API operation with the public key content in the
     * <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code> attribute.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublicKeys} method.
     * </p>
     * 
     * @return A list of public keys to be used by the <code>DevEndpoints</code> for authentication. Using this
     *         attribute is preferred over a single public key because the public keys allow you to have a different
     *         private key per client.</p> <note>
     *         <p>
     *         If you previously created an endpoint with a public key, you must remove that key to be able to set a
     *         list of public keys. Call the <code>UpdateDevEndpoint</code> API operation with the public key content in
     *         the <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code>
     *         attribute.
     *         </p>
     */
    public final List<String> publicKeys() {
        return publicKeys;
    }

    /**
     * <p>
     * The name of the <code>SecurityConfiguration</code> structure to be used with this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The name of the <code>SecurityConfiguration</code> structure to be used with this
     *         <code>DevEndpoint</code>.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arguments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasArguments() {
        return arguments != null && !(arguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of arguments used to configure the <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Valid arguments are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"--enable-glue-datacatalog": ""</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
     * provided, the version defaults to Python 2.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArguments} method.
     * </p>
     * 
     * @return A map of arguments used to configure the <code>DevEndpoint</code>.</p>
     *         <p>
     *         Valid arguments are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"--enable-glue-datacatalog": ""</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     *         parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments
     *         are provided, the version defaults to Python 2.
     */
    public final Map<String, String> arguments() {
        return arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(yarnEndpointAddress());
        hashCode = 31 * hashCode + Objects.hashCode(privateAddress());
        hashCode = 31 * hashCode + Objects.hashCode(zeppelinRemoteSparkInterpreterPort());
        hashCode = 31 * hashCode + Objects.hashCode(publicAddress());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(extraJarsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicKeys() ? publicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasArguments() ? arguments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevEndpoint)) {
            return false;
        }
        DevEndpoint other = (DevEndpoint) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(roleArn(), other.roleArn())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(yarnEndpointAddress(), other.yarnEndpointAddress())
                && Objects.equals(privateAddress(), other.privateAddress())
                && Objects.equals(zeppelinRemoteSparkInterpreterPort(), other.zeppelinRemoteSparkInterpreterPort())
                && Objects.equals(publicAddress(), other.publicAddress()) && Objects.equals(status(), other.status())
                && Objects.equals(workerTypeAsString(), other.workerTypeAsString())
                && Objects.equals(glueVersion(), other.glueVersion())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers())
                && Objects.equals(numberOfNodes(), other.numberOfNodes())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(extraPythonLibsS3Path(), other.extraPythonLibsS3Path())
                && Objects.equals(extraJarsS3Path(), other.extraJarsS3Path())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(lastUpdateStatus(), other.lastUpdateStatus())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(publicKey(), other.publicKey()) && hasPublicKeys() == other.hasPublicKeys()
                && Objects.equals(publicKeys(), other.publicKeys())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && hasArguments() == other.hasArguments() && Objects.equals(arguments(), other.arguments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DevEndpoint").add("EndpointName", endpointName()).add("RoleArn", roleArn())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("SubnetId", subnetId())
                .add("YarnEndpointAddress", yarnEndpointAddress()).add("PrivateAddress", privateAddress())
                .add("ZeppelinRemoteSparkInterpreterPort", zeppelinRemoteSparkInterpreterPort())
                .add("PublicAddress", publicAddress()).add("Status", status()).add("WorkerType", workerTypeAsString())
                .add("GlueVersion", glueVersion()).add("NumberOfWorkers", numberOfWorkers())
                .add("NumberOfNodes", numberOfNodes()).add("AvailabilityZone", availabilityZone()).add("VpcId", vpcId())
                .add("ExtraPythonLibsS3Path", extraPythonLibsS3Path()).add("ExtraJarsS3Path", extraJarsS3Path())
                .add("FailureReason", failureReason()).add("LastUpdateStatus", lastUpdateStatus())
                .add("CreatedTimestamp", createdTimestamp()).add("LastModifiedTimestamp", lastModifiedTimestamp())
                .add("PublicKey", publicKey()).add("PublicKeys", hasPublicKeys() ? publicKeys() : null)
                .add("SecurityConfiguration", securityConfiguration()).add("Arguments", hasArguments() ? arguments() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "YarnEndpointAddress":
            return Optional.ofNullable(clazz.cast(yarnEndpointAddress()));
        case "PrivateAddress":
            return Optional.ofNullable(clazz.cast(privateAddress()));
        case "ZeppelinRemoteSparkInterpreterPort":
            return Optional.ofNullable(clazz.cast(zeppelinRemoteSparkInterpreterPort()));
        case "PublicAddress":
            return Optional.ofNullable(clazz.cast(publicAddress()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "WorkerType":
            return Optional.ofNullable(clazz.cast(workerTypeAsString()));
        case "GlueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "ExtraPythonLibsS3Path":
            return Optional.ofNullable(clazz.cast(extraPythonLibsS3Path()));
        case "ExtraJarsS3Path":
            return Optional.ofNullable(clazz.cast(extraJarsS3Path()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "LastUpdateStatus":
            return Optional.ofNullable(clazz.cast(lastUpdateStatus()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "PublicKey":
            return Optional.ofNullable(clazz.cast(publicKey()));
        case "PublicKeys":
            return Optional.ofNullable(clazz.cast(publicKeys()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "Arguments":
            return Optional.ofNullable(clazz.cast(arguments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DevEndpoint, T> g) {
        return obj -> g.apply((DevEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DevEndpoint> {
        /**
         * <p>
         * The name of the <code>DevEndpoint</code>.
         * </p>
         * 
         * @param endpointName
         *        The name of the <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used in this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role used in this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of security group identifiers used in this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group identifiers used in this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of security group identifiers used in this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group identifiers used in this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The subnet ID for this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID for this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The YARN endpoint address used by this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param yarnEndpointAddress
         *        The YARN endpoint address used by this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yarnEndpointAddress(String yarnEndpointAddress);

        /**
         * <p>
         * A private IP address to access the <code>DevEndpoint</code> within a VPC if the <code>DevEndpoint</code> is
         * created within one. The <code>PrivateAddress</code> field is present only when you create the
         * <code>DevEndpoint</code> within your VPC.
         * </p>
         * 
         * @param privateAddress
         *        A private IP address to access the <code>DevEndpoint</code> within a VPC if the
         *        <code>DevEndpoint</code> is created within one. The <code>PrivateAddress</code> field is present only
         *        when you create the <code>DevEndpoint</code> within your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateAddress(String privateAddress);

        /**
         * <p>
         * The Apache Zeppelin port for the remote Apache Spark interpreter.
         * </p>
         * 
         * @param zeppelinRemoteSparkInterpreterPort
         *        The Apache Zeppelin port for the remote Apache Spark interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort);

        /**
         * <p>
         * The public IP address used by this <code>DevEndpoint</code>. The <code>PublicAddress</code> field is present
         * only when you create a non-virtual private cloud (VPC) <code>DevEndpoint</code>.
         * </p>
         * 
         * @param publicAddress
         *        The public IP address used by this <code>DevEndpoint</code>. The <code>PublicAddress</code> field is
         *        present only when you create a non-virtual private cloud (VPC) <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAddress(String publicAddress);

        /**
         * <p>
         * The current status of this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param status
         *        The current status of this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard,
         * G.1X, or G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
         * configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64
         * GB disk.
         * </p>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated to the development endpoint. Accepts a value of
         *        Standard, G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
         *        configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and
         *        a 64 GB disk.
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(String workerType);

        /**
         * <p>
         * The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard,
         * G.1X, or G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and
         * provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
         * configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64
         * GB disk.
         * </p>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated to the development endpoint. Accepts a value of
         *        Standard, G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB
         *        disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code>
         *        configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and
         *        a 64 GB disk.
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(WorkerType workerType);

        /**
         * <p>
         * Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version
         * indicates the version supported for running your ETL scripts on development endpoints.
         * </p>
         * <p>
         * For more information about the available Glue versions and corresponding Spark and Python versions, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
         * </p>
         * <p>
         * Development endpoints that are created without specifying a Glue version default to Glue 0.9.
         * </p>
         * <p>
         * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
         * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
         * provided, the version defaults to Python 2.
         * </p>
         * 
         * @param glueVersion
         *        Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version
         *        indicates the version supported for running your ETL scripts on development endpoints. </p>
         *        <p>
         *        For more information about the available Glue versions and corresponding Spark and Python versions,
         *        see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the
         *        developer guide.
         *        </p>
         *        <p>
         *        Development endpoints that are created without specifying a Glue version default to Glue 0.9.
         *        </p>
         *        <p>
         *        You can specify a version of Python support for development endpoints by using the
         *        <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or
         *        <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);

        /**
         * <p>
         * The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
         * </p>
         * <p>
         * The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers of a defined <code>workerType</code> that are allocated to the development
         *        endpoint.</p>
         *        <p>
         *        The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for
         *        <code>G.2X</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The number of Glue Data Processing Units (DPUs) allocated to this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of Glue Data Processing Units (DPUs) allocated to this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * The Amazon Web Services Availability Zone where this <code>DevEndpoint</code> is located.
         * </p>
         * 
         * @param availabilityZone
         *        The Amazon Web Services Availability Zone where this <code>DevEndpoint</code> is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param vpcId
         *        The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your
         * <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.
         * </p>
         * <note>
         * <p>
         * You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C extensions,
         * such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are not currently
         * supported.
         * </p>
         * </note>
         * 
         * @param extraPythonLibsS3Path
         *        The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your
         *        <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.</p> <note>
         *        <p>
         *        You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C
         *        extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library,
         *        are not currently supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraPythonLibsS3Path(String extraPythonLibsS3Path);

        /**
         * <p>
         * The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
         * <code>DevEndpoint</code>.
         * </p>
         * <note>
         * <p>
         * You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.
         * </p>
         * </note>
         * 
         * @param extraJarsS3Path
         *        The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
         *        <code>DevEndpoint</code>.</p> <note>
         *        <p>
         *        You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraJarsS3Path(String extraJarsS3Path);

        /**
         * <p>
         * The reason for a current failure in this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param failureReason
         *        The reason for a current failure in this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The status of the last update.
         * </p>
         * 
         * @param lastUpdateStatus
         *        The status of the last update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateStatus(String lastUpdateStatus);

        /**
         * <p>
         * The point in time at which this DevEndpoint was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The point in time at which this DevEndpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The point in time at which this <code>DevEndpoint</code> was last modified.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The point in time at which this <code>DevEndpoint</code> was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is provided for
         * backward compatibility because the recommended attribute to use is public keys.
         * </p>
         * 
         * @param publicKey
         *        The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is
         *        provided for backward compatibility because the recommended attribute to use is public keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);

        /**
         * <p>
         * A list of public keys to be used by the <code>DevEndpoints</code> for authentication. Using this attribute is
         * preferred over a single public key because the public keys allow you to have a different private key per
         * client.
         * </p>
         * <note>
         * <p>
         * If you previously created an endpoint with a public key, you must remove that key to be able to set a list of
         * public keys. Call the <code>UpdateDevEndpoint</code> API operation with the public key content in the
         * <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code>
         * attribute.
         * </p>
         * </note>
         * 
         * @param publicKeys
         *        A list of public keys to be used by the <code>DevEndpoints</code> for authentication. Using this
         *        attribute is preferred over a single public key because the public keys allow you to have a different
         *        private key per client.</p> <note>
         *        <p>
         *        If you previously created an endpoint with a public key, you must remove that key to be able to set a
         *        list of public keys. Call the <code>UpdateDevEndpoint</code> API operation with the public key content
         *        in the <code>deletePublicKeys</code> attribute, and the list of new keys in the
         *        <code>addPublicKeys</code> attribute.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeys(Collection<String> publicKeys);

        /**
         * <p>
         * A list of public keys to be used by the <code>DevEndpoints</code> for authentication. Using this attribute is
         * preferred over a single public key because the public keys allow you to have a different private key per
         * client.
         * </p>
         * <note>
         * <p>
         * If you previously created an endpoint with a public key, you must remove that key to be able to set a list of
         * public keys. Call the <code>UpdateDevEndpoint</code> API operation with the public key content in the
         * <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code>
         * attribute.
         * </p>
         * </note>
         * 
         * @param publicKeys
         *        A list of public keys to be used by the <code>DevEndpoints</code> for authentication. Using this
         *        attribute is preferred over a single public key because the public keys allow you to have a different
         *        private key per client.</p> <note>
         *        <p>
         *        If you previously created an endpoint with a public key, you must remove that key to be able to set a
         *        list of public keys. Call the <code>UpdateDevEndpoint</code> API operation with the public key content
         *        in the <code>deletePublicKeys</code> attribute, and the list of new keys in the
         *        <code>addPublicKeys</code> attribute.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeys(String... publicKeys);

        /**
         * <p>
         * The name of the <code>SecurityConfiguration</code> structure to be used with this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of the <code>SecurityConfiguration</code> structure to be used with this
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * A map of arguments used to configure the <code>DevEndpoint</code>.
         * </p>
         * <p>
         * Valid arguments are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"--enable-glue-datacatalog": ""</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
         * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
         * provided, the version defaults to Python 2.
         * </p>
         * 
         * @param arguments
         *        A map of arguments used to configure the <code>DevEndpoint</code>.</p>
         *        <p>
         *        Valid arguments are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"--enable-glue-datacatalog": ""</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can specify a version of Python support for development endpoints by using the
         *        <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or
         *        <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arguments(Map<String, String> arguments);
    }

    static final class BuilderImpl implements Builder {
        private String endpointName;

        private String roleArn;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private String yarnEndpointAddress;

        private String privateAddress;

        private Integer zeppelinRemoteSparkInterpreterPort;

        private String publicAddress;

        private String status;

        private String workerType;

        private String glueVersion;

        private Integer numberOfWorkers;

        private Integer numberOfNodes;

        private String availabilityZone;

        private String vpcId;

        private String extraPythonLibsS3Path;

        private String extraJarsS3Path;

        private String failureReason;

        private String lastUpdateStatus;

        private Instant createdTimestamp;

        private Instant lastModifiedTimestamp;

        private String publicKey;

        private List<String> publicKeys = DefaultSdkAutoConstructList.getInstance();

        private String securityConfiguration;

        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DevEndpoint model) {
            endpointName(model.endpointName);
            roleArn(model.roleArn);
            securityGroupIds(model.securityGroupIds);
            subnetId(model.subnetId);
            yarnEndpointAddress(model.yarnEndpointAddress);
            privateAddress(model.privateAddress);
            zeppelinRemoteSparkInterpreterPort(model.zeppelinRemoteSparkInterpreterPort);
            publicAddress(model.publicAddress);
            status(model.status);
            workerType(model.workerType);
            glueVersion(model.glueVersion);
            numberOfWorkers(model.numberOfWorkers);
            numberOfNodes(model.numberOfNodes);
            availabilityZone(model.availabilityZone);
            vpcId(model.vpcId);
            extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            extraJarsS3Path(model.extraJarsS3Path);
            failureReason(model.failureReason);
            lastUpdateStatus(model.lastUpdateStatus);
            createdTimestamp(model.createdTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            publicKey(model.publicKey);
            publicKeys(model.publicKeys);
            securityConfiguration(model.securityConfiguration);
            arguments(model.arguments);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getYarnEndpointAddress() {
            return yarnEndpointAddress;
        }

        public final void setYarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
        }

        @Override
        public final Builder yarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
            return this;
        }

        public final String getPrivateAddress() {
            return privateAddress;
        }

        public final void setPrivateAddress(String privateAddress) {
            this.privateAddress = privateAddress;
        }

        @Override
        public final Builder privateAddress(String privateAddress) {
            this.privateAddress = privateAddress;
            return this;
        }

        public final Integer getZeppelinRemoteSparkInterpreterPort() {
            return zeppelinRemoteSparkInterpreterPort;
        }

        public final void setZeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
        }

        @Override
        public final Builder zeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
            return this;
        }

        public final String getPublicAddress() {
            return publicAddress;
        }

        public final void setPublicAddress(String publicAddress) {
            this.publicAddress = publicAddress;
        }

        @Override
        public final Builder publicAddress(String publicAddress) {
            this.publicAddress = publicAddress;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getWorkerType() {
            return workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getExtraPythonLibsS3Path() {
            return extraPythonLibsS3Path;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        @Override
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final String getExtraJarsS3Path() {
            return extraJarsS3Path;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        @Override
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getLastUpdateStatus() {
            return lastUpdateStatus;
        }

        public final void setLastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
        }

        @Override
        public final Builder lastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getPublicKey() {
            return publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final Collection<String> getPublicKeys() {
            if (publicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return publicKeys;
        }

        public final void setPublicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
        }

        @Override
        public final Builder publicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeys(String... publicKeys) {
            publicKeys(Arrays.asList(publicKeys));
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final Map<String, String> getArguments() {
            if (arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
            return this;
        }

        @Override
        public DevEndpoint build() {
            return new DevEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
