/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The OAuth2 client app used for the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuth2ClientApplication implements SdkPojo, Serializable,
        ToCopyableBuilder<OAuth2ClientApplication.Builder, OAuth2ClientApplication> {
    private static final SdkField<String> USER_MANAGED_CLIENT_APPLICATION_CLIENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserManagedClientApplicationClientId")
            .getter(getter(OAuth2ClientApplication::userManagedClientApplicationClientId))
            .setter(setter(Builder::userManagedClientApplicationClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UserManagedClientApplicationClientId").build()).build();

    private static final SdkField<String> AWS_MANAGED_CLIENT_APPLICATION_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AWSManagedClientApplicationReference")
            .getter(getter(OAuth2ClientApplication::awsManagedClientApplicationReference))
            .setter(setter(Builder::awsManagedClientApplicationReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AWSManagedClientApplicationReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            USER_MANAGED_CLIENT_APPLICATION_CLIENT_ID_FIELD, AWS_MANAGED_CLIENT_APPLICATION_REFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userManagedClientApplicationClientId;

    private final String awsManagedClientApplicationReference;

    private OAuth2ClientApplication(BuilderImpl builder) {
        this.userManagedClientApplicationClientId = builder.userManagedClientApplicationClientId;
        this.awsManagedClientApplicationReference = builder.awsManagedClientApplicationReference;
    }

    /**
     * <p>
     * The client application clientID if the ClientAppType is <code>USER_MANAGED</code>.
     * </p>
     * 
     * @return The client application clientID if the ClientAppType is <code>USER_MANAGED</code>.
     */
    public final String userManagedClientApplicationClientId() {
        return userManagedClientApplicationClientId;
    }

    /**
     * <p>
     * The reference to the SaaS-side client app that is Amazon Web Services managed.
     * </p>
     * 
     * @return The reference to the SaaS-side client app that is Amazon Web Services managed.
     */
    public final String awsManagedClientApplicationReference() {
        return awsManagedClientApplicationReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userManagedClientApplicationClientId());
        hashCode = 31 * hashCode + Objects.hashCode(awsManagedClientApplicationReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2ClientApplication)) {
            return false;
        }
        OAuth2ClientApplication other = (OAuth2ClientApplication) obj;
        return Objects.equals(userManagedClientApplicationClientId(), other.userManagedClientApplicationClientId())
                && Objects.equals(awsManagedClientApplicationReference(), other.awsManagedClientApplicationReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuth2ClientApplication")
                .add("UserManagedClientApplicationClientId", userManagedClientApplicationClientId())
                .add("AWSManagedClientApplicationReference", awsManagedClientApplicationReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserManagedClientApplicationClientId":
            return Optional.ofNullable(clazz.cast(userManagedClientApplicationClientId()));
        case "AWSManagedClientApplicationReference":
            return Optional.ofNullable(clazz.cast(awsManagedClientApplicationReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OAuth2ClientApplication, T> g) {
        return obj -> g.apply((OAuth2ClientApplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuth2ClientApplication> {
        /**
         * <p>
         * The client application clientID if the ClientAppType is <code>USER_MANAGED</code>.
         * </p>
         * 
         * @param userManagedClientApplicationClientId
         *        The client application clientID if the ClientAppType is <code>USER_MANAGED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userManagedClientApplicationClientId(String userManagedClientApplicationClientId);

        /**
         * <p>
         * The reference to the SaaS-side client app that is Amazon Web Services managed.
         * </p>
         * 
         * @param awsManagedClientApplicationReference
         *        The reference to the SaaS-side client app that is Amazon Web Services managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsManagedClientApplicationReference(String awsManagedClientApplicationReference);
    }

    static final class BuilderImpl implements Builder {
        private String userManagedClientApplicationClientId;

        private String awsManagedClientApplicationReference;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2ClientApplication model) {
            userManagedClientApplicationClientId(model.userManagedClientApplicationClientId);
            awsManagedClientApplicationReference(model.awsManagedClientApplicationReference);
        }

        public final String getUserManagedClientApplicationClientId() {
            return userManagedClientApplicationClientId;
        }

        public final void setUserManagedClientApplicationClientId(String userManagedClientApplicationClientId) {
            this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
        }

        @Override
        public final Builder userManagedClientApplicationClientId(String userManagedClientApplicationClientId) {
            this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
            return this;
        }

        public final String getAwsManagedClientApplicationReference() {
            return awsManagedClientApplicationReference;
        }

        public final void setAwsManagedClientApplicationReference(String awsManagedClientApplicationReference) {
            this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
        }

        @Override
        public final Builder awsManagedClientApplicationReference(String awsManagedClientApplicationReference) {
            this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
            return this;
        }

        @Override
        public OAuth2ClientApplication build() {
            return new OAuth2ClientApplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
