/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing properties for OAuth2 authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuth2Properties implements SdkPojo, Serializable,
        ToCopyableBuilder<OAuth2Properties.Builder, OAuth2Properties> {
    private static final SdkField<String> O_AUTH2_GRANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OAuth2GrantType").getter(getter(OAuth2Properties::oAuth2GrantTypeAsString))
            .setter(setter(Builder::oAuth2GrantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2GrantType").build()).build();

    private static final SdkField<OAuth2ClientApplication> O_AUTH2_CLIENT_APPLICATION_FIELD = SdkField
            .<OAuth2ClientApplication> builder(MarshallingType.SDK_POJO).memberName("OAuth2ClientApplication")
            .getter(getter(OAuth2Properties::oAuth2ClientApplication)).setter(setter(Builder::oAuth2ClientApplication))
            .constructor(OAuth2ClientApplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2ClientApplication").build())
            .build();

    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenUrl").getter(getter(OAuth2Properties::tokenUrl)).setter(setter(Builder::tokenUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenUrl").build()).build();

    private static final SdkField<Map<String, String>> TOKEN_URL_PARAMETERS_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TokenUrlParametersMap")
            .getter(getter(OAuth2Properties::tokenUrlParametersMap))
            .setter(setter(Builder::tokenUrlParametersMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenUrlParametersMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(O_AUTH2_GRANT_TYPE_FIELD,
            O_AUTH2_CLIENT_APPLICATION_FIELD, TOKEN_URL_FIELD, TOKEN_URL_PARAMETERS_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String oAuth2GrantType;

    private final OAuth2ClientApplication oAuth2ClientApplication;

    private final String tokenUrl;

    private final Map<String, String> tokenUrlParametersMap;

    private OAuth2Properties(BuilderImpl builder) {
        this.oAuth2GrantType = builder.oAuth2GrantType;
        this.oAuth2ClientApplication = builder.oAuth2ClientApplication;
        this.tokenUrl = builder.tokenUrl;
        this.tokenUrlParametersMap = builder.tokenUrlParametersMap;
    }

    /**
     * <p>
     * The OAuth2 grant type. For example, <code>AUTHORIZATION_CODE</code>, <code>JWT_BEARER</code>, or
     * <code>CLIENT_CREDENTIALS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oAuth2GrantType}
     * will return {@link OAuth2GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oAuth2GrantTypeAsString}.
     * </p>
     * 
     * @return The OAuth2 grant type. For example, <code>AUTHORIZATION_CODE</code>, <code>JWT_BEARER</code>, or
     *         <code>CLIENT_CREDENTIALS</code>.
     * @see OAuth2GrantType
     */
    public final OAuth2GrantType oAuth2GrantType() {
        return OAuth2GrantType.fromValue(oAuth2GrantType);
    }

    /**
     * <p>
     * The OAuth2 grant type. For example, <code>AUTHORIZATION_CODE</code>, <code>JWT_BEARER</code>, or
     * <code>CLIENT_CREDENTIALS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oAuth2GrantType}
     * will return {@link OAuth2GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oAuth2GrantTypeAsString}.
     * </p>
     * 
     * @return The OAuth2 grant type. For example, <code>AUTHORIZATION_CODE</code>, <code>JWT_BEARER</code>, or
     *         <code>CLIENT_CREDENTIALS</code>.
     * @see OAuth2GrantType
     */
    public final String oAuth2GrantTypeAsString() {
        return oAuth2GrantType;
    }

    /**
     * <p>
     * The client application type. For example, AWS_MANAGED or USER_MANAGED.
     * </p>
     * 
     * @return The client application type. For example, AWS_MANAGED or USER_MANAGED.
     */
    public final OAuth2ClientApplication oAuth2ClientApplication() {
        return oAuth2ClientApplication;
    }

    /**
     * <p>
     * The URL of the provider's authentication server, to exchange an authorization code for an access token.
     * </p>
     * 
     * @return The URL of the provider's authentication server, to exchange an authorization code for an access token.
     */
    public final String tokenUrl() {
        return tokenUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the TokenUrlParametersMap property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTokenUrlParametersMap() {
        return tokenUrlParametersMap != null && !(tokenUrlParametersMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of parameters that are added to the token <code>GET</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTokenUrlParametersMap} method.
     * </p>
     * 
     * @return A map of parameters that are added to the token <code>GET</code> request.
     */
    public final Map<String, String> tokenUrlParametersMap() {
        return tokenUrlParametersMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2GrantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2ClientApplication());
        hashCode = 31 * hashCode + Objects.hashCode(tokenUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenUrlParametersMap() ? tokenUrlParametersMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Properties)) {
            return false;
        }
        OAuth2Properties other = (OAuth2Properties) obj;
        return Objects.equals(oAuth2GrantTypeAsString(), other.oAuth2GrantTypeAsString())
                && Objects.equals(oAuth2ClientApplication(), other.oAuth2ClientApplication())
                && Objects.equals(tokenUrl(), other.tokenUrl()) && hasTokenUrlParametersMap() == other.hasTokenUrlParametersMap()
                && Objects.equals(tokenUrlParametersMap(), other.tokenUrlParametersMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuth2Properties").add("OAuth2GrantType", oAuth2GrantTypeAsString())
                .add("OAuth2ClientApplication", oAuth2ClientApplication()).add("TokenUrl", tokenUrl())
                .add("TokenUrlParametersMap", hasTokenUrlParametersMap() ? tokenUrlParametersMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OAuth2GrantType":
            return Optional.ofNullable(clazz.cast(oAuth2GrantTypeAsString()));
        case "OAuth2ClientApplication":
            return Optional.ofNullable(clazz.cast(oAuth2ClientApplication()));
        case "TokenUrl":
            return Optional.ofNullable(clazz.cast(tokenUrl()));
        case "TokenUrlParametersMap":
            return Optional.ofNullable(clazz.cast(tokenUrlParametersMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OAuth2Properties, T> g) {
        return obj -> g.apply((OAuth2Properties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuth2Properties> {
        /**
         * <p>
         * The OAuth2 grant type. For example, <code>AUTHORIZATION_CODE</code>, <code>JWT_BEARER</code>, or
         * <code>CLIENT_CREDENTIALS</code>.
         * </p>
         * 
         * @param oAuth2GrantType
         *        The OAuth2 grant type. For example, <code>AUTHORIZATION_CODE</code>, <code>JWT_BEARER</code>, or
         *        <code>CLIENT_CREDENTIALS</code>.
         * @see OAuth2GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuth2GrantType
         */
        Builder oAuth2GrantType(String oAuth2GrantType);

        /**
         * <p>
         * The OAuth2 grant type. For example, <code>AUTHORIZATION_CODE</code>, <code>JWT_BEARER</code>, or
         * <code>CLIENT_CREDENTIALS</code>.
         * </p>
         * 
         * @param oAuth2GrantType
         *        The OAuth2 grant type. For example, <code>AUTHORIZATION_CODE</code>, <code>JWT_BEARER</code>, or
         *        <code>CLIENT_CREDENTIALS</code>.
         * @see OAuth2GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuth2GrantType
         */
        Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType);

        /**
         * <p>
         * The client application type. For example, AWS_MANAGED or USER_MANAGED.
         * </p>
         * 
         * @param oAuth2ClientApplication
         *        The client application type. For example, AWS_MANAGED or USER_MANAGED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth2ClientApplication(OAuth2ClientApplication oAuth2ClientApplication);

        /**
         * <p>
         * The client application type. For example, AWS_MANAGED or USER_MANAGED.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuth2ClientApplication.Builder} avoiding
         * the need to create one manually via {@link OAuth2ClientApplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuth2ClientApplication.Builder#build()} is called immediately
         * and its result is passed to {@link #oAuth2ClientApplication(OAuth2ClientApplication)}.
         * 
         * @param oAuth2ClientApplication
         *        a consumer that will call methods on {@link OAuth2ClientApplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth2ClientApplication(OAuth2ClientApplication)
         */
        default Builder oAuth2ClientApplication(Consumer<OAuth2ClientApplication.Builder> oAuth2ClientApplication) {
            return oAuth2ClientApplication(OAuth2ClientApplication.builder().applyMutation(oAuth2ClientApplication).build());
        }

        /**
         * <p>
         * The URL of the provider's authentication server, to exchange an authorization code for an access token.
         * </p>
         * 
         * @param tokenUrl
         *        The URL of the provider's authentication server, to exchange an authorization code for an access
         *        token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenUrl(String tokenUrl);

        /**
         * <p>
         * A map of parameters that are added to the token <code>GET</code> request.
         * </p>
         * 
         * @param tokenUrlParametersMap
         *        A map of parameters that are added to the token <code>GET</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenUrlParametersMap(Map<String, String> tokenUrlParametersMap);
    }

    static final class BuilderImpl implements Builder {
        private String oAuth2GrantType;

        private OAuth2ClientApplication oAuth2ClientApplication;

        private String tokenUrl;

        private Map<String, String> tokenUrlParametersMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2Properties model) {
            oAuth2GrantType(model.oAuth2GrantType);
            oAuth2ClientApplication(model.oAuth2ClientApplication);
            tokenUrl(model.tokenUrl);
            tokenUrlParametersMap(model.tokenUrlParametersMap);
        }

        public final String getOAuth2GrantType() {
            return oAuth2GrantType;
        }

        public final void setOAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
        }

        @Override
        public final Builder oAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
            return this;
        }

        @Override
        public final Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
            this.oAuth2GrantType(oAuth2GrantType == null ? null : oAuth2GrantType.toString());
            return this;
        }

        public final OAuth2ClientApplication.Builder getOAuth2ClientApplication() {
            return oAuth2ClientApplication != null ? oAuth2ClientApplication.toBuilder() : null;
        }

        public final void setOAuth2ClientApplication(OAuth2ClientApplication.BuilderImpl oAuth2ClientApplication) {
            this.oAuth2ClientApplication = oAuth2ClientApplication != null ? oAuth2ClientApplication.build() : null;
        }

        @Override
        public final Builder oAuth2ClientApplication(OAuth2ClientApplication oAuth2ClientApplication) {
            this.oAuth2ClientApplication = oAuth2ClientApplication;
            return this;
        }

        public final String getTokenUrl() {
            return tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public final Map<String, String> getTokenUrlParametersMap() {
            if (tokenUrlParametersMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return tokenUrlParametersMap;
        }

        public final void setTokenUrlParametersMap(Map<String, String> tokenUrlParametersMap) {
            this.tokenUrlParametersMap = TokenUrlParametersMapCopier.copy(tokenUrlParametersMap);
        }

        @Override
        public final Builder tokenUrlParametersMap(Map<String, String> tokenUrlParametersMap) {
            this.tokenUrlParametersMap = TokenUrlParametersMapCopier.copy(tokenUrlParametersMap);
            return this;
        }

        @Override
        public OAuth2Properties build() {
            return new OAuth2Properties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
