/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metrics for the optimizer run.
 * </p>
 * <p>
 * This structure is deprecated. See the individual metric members for compaction, retention, and orphan file deletion.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunMetrics implements SdkPojo, Serializable, ToCopyableBuilder<RunMetrics.Builder, RunMetrics> {
    private static final SdkField<String> NUMBER_OF_BYTES_COMPACTED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberOfBytesCompacted").getter(getter(RunMetrics::numberOfBytesCompacted))
            .setter(setter(Builder::numberOfBytesCompacted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBytesCompacted").build())
            .build();

    private static final SdkField<String> NUMBER_OF_FILES_COMPACTED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberOfFilesCompacted").getter(getter(RunMetrics::numberOfFilesCompacted))
            .setter(setter(Builder::numberOfFilesCompacted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFilesCompacted").build())
            .build();

    private static final SdkField<String> NUMBER_OF_DPUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberOfDpus").getter(getter(RunMetrics::numberOfDpus)).setter(setter(Builder::numberOfDpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDpus").build()).build();

    private static final SdkField<String> JOB_DURATION_IN_HOUR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDurationInHour").getter(getter(RunMetrics::jobDurationInHour))
            .setter(setter(Builder::jobDurationInHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_BYTES_COMPACTED_FIELD, NUMBER_OF_FILES_COMPACTED_FIELD, NUMBER_OF_DPUS_FIELD, JOB_DURATION_IN_HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String numberOfBytesCompacted;

    private final String numberOfFilesCompacted;

    private final String numberOfDpus;

    private final String jobDurationInHour;

    private RunMetrics(BuilderImpl builder) {
        this.numberOfBytesCompacted = builder.numberOfBytesCompacted;
        this.numberOfFilesCompacted = builder.numberOfFilesCompacted;
        this.numberOfDpus = builder.numberOfDpus;
        this.jobDurationInHour = builder.jobDurationInHour;
    }

    /**
     * <p>
     * The number of bytes removed by the compaction job run.
     * </p>
     * 
     * @return The number of bytes removed by the compaction job run.
     */
    public final String numberOfBytesCompacted() {
        return numberOfBytesCompacted;
    }

    /**
     * <p>
     * The number of files removed by the compaction job run.
     * </p>
     * 
     * @return The number of files removed by the compaction job run.
     */
    public final String numberOfFilesCompacted() {
        return numberOfFilesCompacted;
    }

    /**
     * <p>
     * The number of DPU hours consumed by the job.
     * </p>
     * 
     * @return The number of DPU hours consumed by the job.
     */
    public final String numberOfDpus() {
        return numberOfDpus;
    }

    /**
     * <p>
     * The duration of the job in hours.
     * </p>
     * 
     * @return The duration of the job in hours.
     */
    public final String jobDurationInHour() {
        return jobDurationInHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBytesCompacted());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfFilesCompacted());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDpus());
        hashCode = 31 * hashCode + Objects.hashCode(jobDurationInHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunMetrics)) {
            return false;
        }
        RunMetrics other = (RunMetrics) obj;
        return Objects.equals(numberOfBytesCompacted(), other.numberOfBytesCompacted())
                && Objects.equals(numberOfFilesCompacted(), other.numberOfFilesCompacted())
                && Objects.equals(numberOfDpus(), other.numberOfDpus())
                && Objects.equals(jobDurationInHour(), other.jobDurationInHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunMetrics").add("NumberOfBytesCompacted", numberOfBytesCompacted())
                .add("NumberOfFilesCompacted", numberOfFilesCompacted()).add("NumberOfDpus", numberOfDpus())
                .add("JobDurationInHour", jobDurationInHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfBytesCompacted":
            return Optional.ofNullable(clazz.cast(numberOfBytesCompacted()));
        case "NumberOfFilesCompacted":
            return Optional.ofNullable(clazz.cast(numberOfFilesCompacted()));
        case "NumberOfDpus":
            return Optional.ofNullable(clazz.cast(numberOfDpus()));
        case "JobDurationInHour":
            return Optional.ofNullable(clazz.cast(jobDurationInHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunMetrics, T> g) {
        return obj -> g.apply((RunMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunMetrics> {
        /**
         * <p>
         * The number of bytes removed by the compaction job run.
         * </p>
         * 
         * @param numberOfBytesCompacted
         *        The number of bytes removed by the compaction job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBytesCompacted(String numberOfBytesCompacted);

        /**
         * <p>
         * The number of files removed by the compaction job run.
         * </p>
         * 
         * @param numberOfFilesCompacted
         *        The number of files removed by the compaction job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFilesCompacted(String numberOfFilesCompacted);

        /**
         * <p>
         * The number of DPU hours consumed by the job.
         * </p>
         * 
         * @param numberOfDpus
         *        The number of DPU hours consumed by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDpus(String numberOfDpus);

        /**
         * <p>
         * The duration of the job in hours.
         * </p>
         * 
         * @param jobDurationInHour
         *        The duration of the job in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDurationInHour(String jobDurationInHour);
    }

    static final class BuilderImpl implements Builder {
        private String numberOfBytesCompacted;

        private String numberOfFilesCompacted;

        private String numberOfDpus;

        private String jobDurationInHour;

        private BuilderImpl() {
        }

        private BuilderImpl(RunMetrics model) {
            numberOfBytesCompacted(model.numberOfBytesCompacted);
            numberOfFilesCompacted(model.numberOfFilesCompacted);
            numberOfDpus(model.numberOfDpus);
            jobDurationInHour(model.jobDurationInHour);
        }

        public final String getNumberOfBytesCompacted() {
            return numberOfBytesCompacted;
        }

        public final void setNumberOfBytesCompacted(String numberOfBytesCompacted) {
            this.numberOfBytesCompacted = numberOfBytesCompacted;
        }

        @Override
        public final Builder numberOfBytesCompacted(String numberOfBytesCompacted) {
            this.numberOfBytesCompacted = numberOfBytesCompacted;
            return this;
        }

        public final String getNumberOfFilesCompacted() {
            return numberOfFilesCompacted;
        }

        public final void setNumberOfFilesCompacted(String numberOfFilesCompacted) {
            this.numberOfFilesCompacted = numberOfFilesCompacted;
        }

        @Override
        public final Builder numberOfFilesCompacted(String numberOfFilesCompacted) {
            this.numberOfFilesCompacted = numberOfFilesCompacted;
            return this;
        }

        public final String getNumberOfDpus() {
            return numberOfDpus;
        }

        public final void setNumberOfDpus(String numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
        }

        @Override
        public final Builder numberOfDpus(String numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
            return this;
        }

        public final String getJobDurationInHour() {
            return jobDurationInHour;
        }

        public final void setJobDurationInHour(String jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
        }

        @Override
        public final Builder jobDurationInHour(String jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
            return this;
        }

        @Override
        public RunMetrics build() {
            return new RunMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
