/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing details of a representation to update or create a Lake Formation view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewRepresentationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ViewRepresentationInput.Builder, ViewRepresentationInput> {
    private static final SdkField<String> DIALECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Dialect")
            .getter(getter(ViewRepresentationInput::dialectAsString)).setter(setter(Builder::dialect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dialect").build()).build();

    private static final SdkField<String> DIALECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DialectVersion").getter(getter(ViewRepresentationInput::dialectVersion))
            .setter(setter(Builder::dialectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DialectVersion").build()).build();

    private static final SdkField<String> VIEW_ORIGINAL_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewOriginalText").getter(getter(ViewRepresentationInput::viewOriginalText))
            .setter(setter(Builder::viewOriginalText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewOriginalText").build()).build();

    private static final SdkField<String> VALIDATION_CONNECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationConnection").getter(getter(ViewRepresentationInput::validationConnection))
            .setter(setter(Builder::validationConnection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationConnection").build())
            .build();

    private static final SdkField<String> VIEW_EXPANDED_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewExpandedText").getter(getter(ViewRepresentationInput::viewExpandedText))
            .setter(setter(Builder::viewExpandedText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewExpandedText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALECT_FIELD,
            DIALECT_VERSION_FIELD, VIEW_ORIGINAL_TEXT_FIELD, VALIDATION_CONNECTION_FIELD, VIEW_EXPANDED_TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dialect;

    private final String dialectVersion;

    private final String viewOriginalText;

    private final String validationConnection;

    private final String viewExpandedText;

    private ViewRepresentationInput(BuilderImpl builder) {
        this.dialect = builder.dialect;
        this.dialectVersion = builder.dialectVersion;
        this.viewOriginalText = builder.viewOriginalText;
        this.validationConnection = builder.validationConnection;
        this.viewExpandedText = builder.viewExpandedText;
    }

    /**
     * <p>
     * A parameter that specifies the engine type of a specific representation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialect} will
     * return {@link ViewDialect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialectAsString}.
     * </p>
     * 
     * @return A parameter that specifies the engine type of a specific representation.
     * @see ViewDialect
     */
    public final ViewDialect dialect() {
        return ViewDialect.fromValue(dialect);
    }

    /**
     * <p>
     * A parameter that specifies the engine type of a specific representation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialect} will
     * return {@link ViewDialect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialectAsString}.
     * </p>
     * 
     * @return A parameter that specifies the engine type of a specific representation.
     * @see ViewDialect
     */
    public final String dialectAsString() {
        return dialect;
    }

    /**
     * <p>
     * A parameter that specifies the version of the engine of a specific representation.
     * </p>
     * 
     * @return A parameter that specifies the version of the engine of a specific representation.
     */
    public final String dialectVersion() {
        return dialectVersion;
    }

    /**
     * <p>
     * A string that represents the original SQL query that describes the view.
     * </p>
     * 
     * @return A string that represents the original SQL query that describes the view.
     */
    public final String viewOriginalText() {
        return viewOriginalText;
    }

    /**
     * <p>
     * The name of the connection to be used to validate the specific representation of the view.
     * </p>
     * 
     * @return The name of the connection to be used to validate the specific representation of the view.
     */
    public final String validationConnection() {
        return validationConnection;
    }

    /**
     * <p>
     * A string that represents the SQL query that describes the view with expanded resource ARNs
     * </p>
     * 
     * @return A string that represents the SQL query that describes the view with expanded resource ARNs
     */
    public final String viewExpandedText() {
        return viewExpandedText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dialectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(viewOriginalText());
        hashCode = 31 * hashCode + Objects.hashCode(validationConnection());
        hashCode = 31 * hashCode + Objects.hashCode(viewExpandedText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewRepresentationInput)) {
            return false;
        }
        ViewRepresentationInput other = (ViewRepresentationInput) obj;
        return Objects.equals(dialectAsString(), other.dialectAsString())
                && Objects.equals(dialectVersion(), other.dialectVersion())
                && Objects.equals(viewOriginalText(), other.viewOriginalText())
                && Objects.equals(validationConnection(), other.validationConnection())
                && Objects.equals(viewExpandedText(), other.viewExpandedText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewRepresentationInput").add("Dialect", dialectAsString())
                .add("DialectVersion", dialectVersion()).add("ViewOriginalText", viewOriginalText())
                .add("ValidationConnection", validationConnection()).add("ViewExpandedText", viewExpandedText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dialect":
            return Optional.ofNullable(clazz.cast(dialectAsString()));
        case "DialectVersion":
            return Optional.ofNullable(clazz.cast(dialectVersion()));
        case "ViewOriginalText":
            return Optional.ofNullable(clazz.cast(viewOriginalText()));
        case "ValidationConnection":
            return Optional.ofNullable(clazz.cast(validationConnection()));
        case "ViewExpandedText":
            return Optional.ofNullable(clazz.cast(viewExpandedText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViewRepresentationInput, T> g) {
        return obj -> g.apply((ViewRepresentationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewRepresentationInput> {
        /**
         * <p>
         * A parameter that specifies the engine type of a specific representation.
         * </p>
         * 
         * @param dialect
         *        A parameter that specifies the engine type of a specific representation.
         * @see ViewDialect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewDialect
         */
        Builder dialect(String dialect);

        /**
         * <p>
         * A parameter that specifies the engine type of a specific representation.
         * </p>
         * 
         * @param dialect
         *        A parameter that specifies the engine type of a specific representation.
         * @see ViewDialect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewDialect
         */
        Builder dialect(ViewDialect dialect);

        /**
         * <p>
         * A parameter that specifies the version of the engine of a specific representation.
         * </p>
         * 
         * @param dialectVersion
         *        A parameter that specifies the version of the engine of a specific representation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialectVersion(String dialectVersion);

        /**
         * <p>
         * A string that represents the original SQL query that describes the view.
         * </p>
         * 
         * @param viewOriginalText
         *        A string that represents the original SQL query that describes the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewOriginalText(String viewOriginalText);

        /**
         * <p>
         * The name of the connection to be used to validate the specific representation of the view.
         * </p>
         * 
         * @param validationConnection
         *        The name of the connection to be used to validate the specific representation of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationConnection(String validationConnection);

        /**
         * <p>
         * A string that represents the SQL query that describes the view with expanded resource ARNs
         * </p>
         * 
         * @param viewExpandedText
         *        A string that represents the SQL query that describes the view with expanded resource ARNs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewExpandedText(String viewExpandedText);
    }

    static final class BuilderImpl implements Builder {
        private String dialect;

        private String dialectVersion;

        private String viewOriginalText;

        private String validationConnection;

        private String viewExpandedText;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewRepresentationInput model) {
            dialect(model.dialect);
            dialectVersion(model.dialectVersion);
            viewOriginalText(model.viewOriginalText);
            validationConnection(model.validationConnection);
            viewExpandedText(model.viewExpandedText);
        }

        public final String getDialect() {
            return dialect;
        }

        public final void setDialect(String dialect) {
            this.dialect = dialect;
        }

        @Override
        public final Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public final Builder dialect(ViewDialect dialect) {
            this.dialect(dialect == null ? null : dialect.toString());
            return this;
        }

        public final String getDialectVersion() {
            return dialectVersion;
        }

        public final void setDialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
        }

        @Override
        public final Builder dialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
            return this;
        }

        public final String getViewOriginalText() {
            return viewOriginalText;
        }

        public final void setViewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
        }

        @Override
        public final Builder viewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
            return this;
        }

        public final String getValidationConnection() {
            return validationConnection;
        }

        public final void setValidationConnection(String validationConnection) {
            this.validationConnection = validationConnection;
        }

        @Override
        public final Builder validationConnection(String validationConnection) {
            this.validationConnection = validationConnection;
            return this;
        }

        public final String getViewExpandedText() {
            return viewExpandedText;
        }

        public final void setViewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
        }

        @Override
        public final Builder viewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
            return this;
        }

        @Override
        public ViewRepresentationInput build() {
            return new ViewRepresentationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
