/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ConditionExpression;
import software.amazon.awssdk.services.glue.model.ConditionExpressionListCopier;
import software.amazon.awssdk.services.glue.model.RecipeAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecipeStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecipeStep> {
    private static final SdkField<RecipeAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(RecipeStep.getter(RecipeStep::action)).setter(RecipeStep.setter(Builder::action)).constructor(RecipeAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<List<ConditionExpression>> CONDITION_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConditionExpressions").getter(RecipeStep.getter(RecipeStep::conditionExpressions)).setter(RecipeStep.setter(Builder::conditionExpressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpressions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConditionExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, CONDITION_EXPRESSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final RecipeAction action;
    private final List<ConditionExpression> conditionExpressions;

    private RecipeStep(BuilderImpl builder) {
        this.action = builder.action;
        this.conditionExpressions = builder.conditionExpressions;
    }

    public final RecipeAction action() {
        return this.action;
    }

    public final boolean hasConditionExpressions() {
        return this.conditionExpressions != null && !(this.conditionExpressions instanceof SdkAutoConstructList);
    }

    public final List<ConditionExpression> conditionExpressions() {
        return this.conditionExpressions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditionExpressions() ? this.conditionExpressions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipeStep)) {
            return false;
        }
        RecipeStep other = (RecipeStep)obj;
        return Objects.equals(this.action(), other.action()) && this.hasConditionExpressions() == other.hasConditionExpressions() && Objects.equals(this.conditionExpressions(), other.conditionExpressions());
    }

    public final String toString() {
        return ToString.builder((String)"RecipeStep").add("Action", (Object)this.action()).add("ConditionExpressions", this.hasConditionExpressions() ? this.conditionExpressions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "ConditionExpressions": {
                return Optional.ofNullable(clazz.cast(this.conditionExpressions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecipeStep, T> g) {
        return obj -> g.apply((RecipeStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RecipeAction action;
        private List<ConditionExpression> conditionExpressions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecipeStep model) {
            this.action(model.action);
            this.conditionExpressions(model.conditionExpressions);
        }

        public final RecipeAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(RecipeAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(RecipeAction action) {
            this.action = action;
            return this;
        }

        public final List<ConditionExpression.Builder> getConditionExpressions() {
            List<ConditionExpression.Builder> result = ConditionExpressionListCopier.copyToBuilder(this.conditionExpressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditionExpressions(Collection<ConditionExpression.BuilderImpl> conditionExpressions) {
            this.conditionExpressions = ConditionExpressionListCopier.copyFromBuilder(conditionExpressions);
        }

        @Override
        public final Builder conditionExpressions(Collection<ConditionExpression> conditionExpressions) {
            this.conditionExpressions = ConditionExpressionListCopier.copy(conditionExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionExpressions(ConditionExpression ... conditionExpressions) {
            this.conditionExpressions(Arrays.asList(conditionExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionExpressions(Consumer<ConditionExpression.Builder> ... conditionExpressions) {
            this.conditionExpressions(Stream.of(conditionExpressions).map(c -> (ConditionExpression)((ConditionExpression.Builder)ConditionExpression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RecipeStep build() {
            return new RecipeStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecipeStep> {
        public Builder action(RecipeAction var1);

        default public Builder action(Consumer<RecipeAction.Builder> action) {
            return this.action((RecipeAction)((RecipeAction.Builder)RecipeAction.builder().applyMutation(action)).build());
        }

        public Builder conditionExpressions(Collection<ConditionExpression> var1);

        public Builder conditionExpressions(ConditionExpression ... var1);

        public Builder conditionExpressions(Consumer<ConditionExpression.Builder> ... var1);
    }
}

