/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AuthenticationConfigurationInput;
import software.amazon.awssdk.services.glue.model.ConnectionPropertiesCopier;
import software.amazon.awssdk.services.glue.model.ConnectionPropertyKey;
import software.amazon.awssdk.services.glue.model.ConnectionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestConnectionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestConnectionInput> {
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(TestConnectionInput.getter(TestConnectionInput::connectionTypeAsString)).setter(TestConnectionInput.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionProperties").getter(TestConnectionInput.getter(TestConnectionInput::connectionPropertiesAsStrings)).setter(TestConnectionInput.setter(Builder::connectionPropertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuthenticationConfigurationInput> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationConfiguration").getter(TestConnectionInput.getter(TestConnectionInput::authenticationConfiguration)).setter(TestConnectionInput.setter(Builder::authenticationConfiguration)).constructor(AuthenticationConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPE_FIELD, CONNECTION_PROPERTIES_FIELD, AUTHENTICATION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectionType;
    private final Map<String, String> connectionProperties;
    private final AuthenticationConfigurationInput authenticationConfiguration;

    private TestConnectionInput(BuilderImpl builder) {
        this.connectionType = builder.connectionType;
        this.connectionProperties = builder.connectionProperties;
        this.authenticationConfiguration = builder.authenticationConfiguration;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final Map<ConnectionPropertyKey, String> connectionProperties() {
        return ConnectionPropertiesCopier.copyStringToEnum(this.connectionProperties);
    }

    public final boolean hasConnectionProperties() {
        return this.connectionProperties != null && !(this.connectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectionPropertiesAsStrings() {
        return this.connectionProperties;
    }

    public final AuthenticationConfigurationInput authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionProperties() ? this.connectionPropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConnectionInput)) {
            return false;
        }
        TestConnectionInput other = (TestConnectionInput)obj;
        return Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && this.hasConnectionProperties() == other.hasConnectionProperties() && Objects.equals(this.connectionPropertiesAsStrings(), other.connectionPropertiesAsStrings()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TestConnectionInput").add("ConnectionType", (Object)this.connectionTypeAsString()).add("ConnectionProperties", this.hasConnectionProperties() ? this.connectionPropertiesAsStrings() : null).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "ConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.connectionPropertiesAsStrings()));
            }
            case "AuthenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestConnectionInput, T> g) {
        return obj -> g.apply((TestConnectionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionType;
        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private AuthenticationConfigurationInput authenticationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TestConnectionInput model) {
            this.connectionType(model.connectionType);
            this.connectionPropertiesWithStrings(model.connectionProperties);
            this.authenticationConfiguration(model.authenticationConfiguration);
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (this.connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        @Override
        public final Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copyEnumToString(connectionProperties);
            return this;
        }

        public final AuthenticationConfigurationInput.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfigurationInput.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfigurationInput authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public TestConnectionInput build() {
            return new TestConnectionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestConnectionInput> {
        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder connectionPropertiesWithStrings(Map<String, String> var1);

        public Builder connectionProperties(Map<ConnectionPropertyKey, String> var1);

        public Builder authenticationConfiguration(AuthenticationConfigurationInput var1);

        default public Builder authenticationConfiguration(Consumer<AuthenticationConfigurationInput.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthenticationConfigurationInput)((AuthenticationConfigurationInput.Builder)AuthenticationConfigurationInput.builder().applyMutation(authenticationConfiguration)).build());
        }
    }
}

