/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.services.glue.model.RecipeReference;
import software.amazon.awssdk.services.glue.model.RecipeStep;
import software.amazon.awssdk.services.glue.model.RecipeStepsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recipe
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recipe> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Recipe.getter(Recipe::name)).setter(Recipe.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(Recipe.getter(Recipe::inputs)).setter(Recipe.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecipeReference> RECIPE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecipeReference").getter(Recipe.getter(Recipe::recipeReference)).setter(Recipe.setter(Builder::recipeReference)).constructor(RecipeReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeReference").build()}).build();
    private static final SdkField<List<RecipeStep>> RECIPE_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecipeSteps").getter(Recipe.getter(Recipe::recipeSteps)).setter(Recipe.setter(Builder::recipeSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecipeStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, RECIPE_REFERENCE_FIELD, RECIPE_STEPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Recipe.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final RecipeReference recipeReference;
    private final List<RecipeStep> recipeSteps;

    private Recipe(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.recipeReference = builder.recipeReference;
        this.recipeSteps = builder.recipeSteps;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final RecipeReference recipeReference() {
        return this.recipeReference;
    }

    public final boolean hasRecipeSteps() {
        return this.recipeSteps != null && !(this.recipeSteps instanceof SdkAutoConstructList);
    }

    public final List<RecipeStep> recipeSteps() {
        return this.recipeSteps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecipeSteps() ? this.recipeSteps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.recipeReference(), other.recipeReference()) && this.hasRecipeSteps() == other.hasRecipeSteps() && Objects.equals(this.recipeSteps(), other.recipeSteps());
    }

    public final String toString() {
        return ToString.builder((String)"Recipe").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("RecipeReference", (Object)this.recipeReference()).add("RecipeSteps", this.hasRecipeSteps() ? this.recipeSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "RecipeReference": {
                return Optional.ofNullable(clazz.cast(this.recipeReference()));
            }
            case "RecipeSteps": {
                return Optional.ofNullable(clazz.cast(this.recipeSteps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("RecipeReference", RECIPE_REFERENCE_FIELD);
        map.put("RecipeSteps", RECIPE_STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recipe, T> g) {
        return obj -> g.apply((Recipe)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private RecipeReference recipeReference;
        private List<RecipeStep> recipeSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recipe model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.recipeReference(model.recipeReference);
            this.recipeSteps(model.recipeSteps);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final RecipeReference.Builder getRecipeReference() {
            return this.recipeReference != null ? this.recipeReference.toBuilder() : null;
        }

        public final void setRecipeReference(RecipeReference.BuilderImpl recipeReference) {
            this.recipeReference = recipeReference != null ? recipeReference.build() : null;
        }

        @Override
        public final Builder recipeReference(RecipeReference recipeReference) {
            this.recipeReference = recipeReference;
            return this;
        }

        public final List<RecipeStep.Builder> getRecipeSteps() {
            List<RecipeStep.Builder> result = RecipeStepsCopier.copyToBuilder(this.recipeSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecipeSteps(Collection<RecipeStep.BuilderImpl> recipeSteps) {
            this.recipeSteps = RecipeStepsCopier.copyFromBuilder(recipeSteps);
        }

        @Override
        public final Builder recipeSteps(Collection<RecipeStep> recipeSteps) {
            this.recipeSteps = RecipeStepsCopier.copy(recipeSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipeSteps(RecipeStep ... recipeSteps) {
            this.recipeSteps(Arrays.asList(recipeSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipeSteps(Consumer<RecipeStep.Builder> ... recipeSteps) {
            this.recipeSteps(Stream.of(recipeSteps).map(c -> (RecipeStep)((RecipeStep.Builder)RecipeStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Recipe build() {
            return new Recipe(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recipe> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder recipeReference(RecipeReference var1);

        default public Builder recipeReference(Consumer<RecipeReference.Builder> recipeReference) {
            return this.recipeReference((RecipeReference)((RecipeReference.Builder)RecipeReference.builder().applyMutation(recipeReference)).build());
        }

        public Builder recipeSteps(Collection<RecipeStep> var1);

        public Builder recipeSteps(RecipeStep ... var1);

        public Builder recipeSteps(Consumer<RecipeStep.Builder> ... var1);
    }
}

