/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FieldDataType {
    INT("INT"),
    SMALLINT("SMALLINT"),
    BIGINT("BIGINT"),
    FLOAT("FLOAT"),
    LONG("LONG"),
    DATE("DATE"),
    BOOLEAN("BOOLEAN"),
    MAP("MAP"),
    ARRAY("ARRAY"),
    STRING("STRING"),
    TIMESTAMP("TIMESTAMP"),
    DECIMAL("DECIMAL"),
    BYTE("BYTE"),
    SHORT("SHORT"),
    DOUBLE("DOUBLE"),
    STRUCT("STRUCT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FieldDataType> VALUE_MAP;
    private final String value;

    private FieldDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FieldDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FieldDataType> knownValues() {
        EnumSet<FieldDataType> knownValues = EnumSet.allOf(FieldDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FieldDataType.class, FieldDataType::toString);
    }
}

