/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.MLUserDataEncryptionModeString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MLUserDataEncryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MLUserDataEncryption> {
    private static final SdkField<String> ML_USER_DATA_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlUserDataEncryptionMode").getter(MLUserDataEncryption.getter(MLUserDataEncryption::mlUserDataEncryptionModeAsString)).setter(MLUserDataEncryption.setter(Builder::mlUserDataEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlUserDataEncryptionMode").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(MLUserDataEncryption.getter(MLUserDataEncryption::kmsKeyId)).setter(MLUserDataEncryption.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_USER_DATA_ENCRYPTION_MODE_FIELD, KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MLUserDataEncryption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mlUserDataEncryptionMode;
    private final String kmsKeyId;

    private MLUserDataEncryption(BuilderImpl builder) {
        this.mlUserDataEncryptionMode = builder.mlUserDataEncryptionMode;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final MLUserDataEncryptionModeString mlUserDataEncryptionMode() {
        return MLUserDataEncryptionModeString.fromValue(this.mlUserDataEncryptionMode);
    }

    public final String mlUserDataEncryptionModeAsString() {
        return this.mlUserDataEncryptionMode;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlUserDataEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLUserDataEncryption)) {
            return false;
        }
        MLUserDataEncryption other = (MLUserDataEncryption)obj;
        return Objects.equals(this.mlUserDataEncryptionModeAsString(), other.mlUserDataEncryptionModeAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"MLUserDataEncryption").add("MlUserDataEncryptionMode", (Object)this.mlUserDataEncryptionModeAsString()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MlUserDataEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.mlUserDataEncryptionModeAsString()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MlUserDataEncryptionMode", ML_USER_DATA_ENCRYPTION_MODE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MLUserDataEncryption, T> g) {
        return obj -> g.apply((MLUserDataEncryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mlUserDataEncryptionMode;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MLUserDataEncryption model) {
            this.mlUserDataEncryptionMode(model.mlUserDataEncryptionMode);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getMlUserDataEncryptionMode() {
            return this.mlUserDataEncryptionMode;
        }

        public final void setMlUserDataEncryptionMode(String mlUserDataEncryptionMode) {
            this.mlUserDataEncryptionMode = mlUserDataEncryptionMode;
        }

        @Override
        public final Builder mlUserDataEncryptionMode(String mlUserDataEncryptionMode) {
            this.mlUserDataEncryptionMode = mlUserDataEncryptionMode;
            return this;
        }

        @Override
        public final Builder mlUserDataEncryptionMode(MLUserDataEncryptionModeString mlUserDataEncryptionMode) {
            this.mlUserDataEncryptionMode(mlUserDataEncryptionMode == null ? null : mlUserDataEncryptionMode.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public MLUserDataEncryption build() {
            return new MLUserDataEncryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MLUserDataEncryption> {
        public Builder mlUserDataEncryptionMode(String var1);

        public Builder mlUserDataEncryptionMode(MLUserDataEncryptionModeString var1);

        public Builder kmsKeyId(String var1);
    }
}

