/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.EnclosedInStringPropertiesCopier;
import software.amazon.awssdk.services.glue.model.MappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Mapping> {
    private static final SdkField<String> TO_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ToKey").getter(Mapping.getter(Mapping::toKey)).setter(Mapping.setter(Builder::toKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToKey").build()}).build();
    private static final SdkField<List<String>> FROM_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FromPath").getter(Mapping.getter(Mapping::fromPath)).setter(Mapping.setter(Builder::fromPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FROM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromType").getter(Mapping.getter(Mapping::fromType)).setter(Mapping.setter(Builder::fromType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromType").build()}).build();
    private static final SdkField<String> TO_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ToType").getter(Mapping.getter(Mapping::toType)).setter(Mapping.setter(Builder::toType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToType").build()}).build();
    private static final SdkField<Boolean> DROPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Dropped").getter(Mapping.getter(Mapping::dropped)).setter(Mapping.setter(Builder::dropped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dropped").build()}).build();
    private static final SdkField<List<Mapping>> CHILDREN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Children").getter(Mapping.getter(Mapping::children)).setter(Mapping.setter(Builder::children)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Children").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Mapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_KEY_FIELD, FROM_PATH_FIELD, FROM_TYPE_FIELD, TO_TYPE_FIELD, DROPPED_FIELD, CHILDREN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Mapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String toKey;
    private final List<String> fromPath;
    private final String fromType;
    private final String toType;
    private final Boolean dropped;
    private final List<Mapping> children;

    private Mapping(BuilderImpl builder) {
        this.toKey = builder.toKey;
        this.fromPath = builder.fromPath;
        this.fromType = builder.fromType;
        this.toType = builder.toType;
        this.dropped = builder.dropped;
        this.children = builder.children;
    }

    public final String toKey() {
        return this.toKey;
    }

    public final boolean hasFromPath() {
        return this.fromPath != null && !(this.fromPath instanceof SdkAutoConstructList);
    }

    public final List<String> fromPath() {
        return this.fromPath;
    }

    public final String fromType() {
        return this.fromType;
    }

    public final String toType() {
        return this.toType;
    }

    public final Boolean dropped() {
        return this.dropped;
    }

    public final boolean hasChildren() {
        return this.children != null && !(this.children instanceof SdkAutoConstructList);
    }

    public final List<Mapping> children() {
        return this.children;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.toKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFromPath() ? this.fromPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fromType());
        hashCode = 31 * hashCode + Objects.hashCode(this.toType());
        hashCode = 31 * hashCode + Objects.hashCode(this.dropped());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildren() ? this.children() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping)obj;
        return Objects.equals(this.toKey(), other.toKey()) && this.hasFromPath() == other.hasFromPath() && Objects.equals(this.fromPath(), other.fromPath()) && Objects.equals(this.fromType(), other.fromType()) && Objects.equals(this.toType(), other.toType()) && Objects.equals(this.dropped(), other.dropped()) && this.hasChildren() == other.hasChildren() && Objects.equals(this.children(), other.children());
    }

    public final String toString() {
        return ToString.builder((String)"Mapping").add("ToKey", (Object)this.toKey()).add("FromPath", this.hasFromPath() ? this.fromPath() : null).add("FromType", (Object)this.fromType()).add("ToType", (Object)this.toType()).add("Dropped", (Object)this.dropped()).add("Children", this.hasChildren() ? this.children() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ToKey": {
                return Optional.ofNullable(clazz.cast(this.toKey()));
            }
            case "FromPath": {
                return Optional.ofNullable(clazz.cast(this.fromPath()));
            }
            case "FromType": {
                return Optional.ofNullable(clazz.cast(this.fromType()));
            }
            case "ToType": {
                return Optional.ofNullable(clazz.cast(this.toType()));
            }
            case "Dropped": {
                return Optional.ofNullable(clazz.cast(this.dropped()));
            }
            case "Children": {
                return Optional.ofNullable(clazz.cast(this.children()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ToKey", TO_KEY_FIELD);
        map.put("FromPath", FROM_PATH_FIELD);
        map.put("FromType", FROM_TYPE_FIELD);
        map.put("ToType", TO_TYPE_FIELD);
        map.put("Dropped", DROPPED_FIELD);
        map.put("Children", CHILDREN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mapping, T> g) {
        return obj -> g.apply((Mapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String toKey;
        private List<String> fromPath = DefaultSdkAutoConstructList.getInstance();
        private String fromType;
        private String toType;
        private Boolean dropped;
        private List<Mapping> children = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Mapping model) {
            this.toKey(model.toKey);
            this.fromPath(model.fromPath);
            this.fromType(model.fromType);
            this.toType(model.toType);
            this.dropped(model.dropped);
            this.children(model.children);
        }

        public final String getToKey() {
            return this.toKey;
        }

        public final void setToKey(String toKey) {
            this.toKey = toKey;
        }

        @Override
        public final Builder toKey(String toKey) {
            this.toKey = toKey;
            return this;
        }

        public final Collection<String> getFromPath() {
            if (this.fromPath instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fromPath;
        }

        public final void setFromPath(Collection<String> fromPath) {
            this.fromPath = EnclosedInStringPropertiesCopier.copy(fromPath);
        }

        @Override
        public final Builder fromPath(Collection<String> fromPath) {
            this.fromPath = EnclosedInStringPropertiesCopier.copy(fromPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromPath(String ... fromPath) {
            this.fromPath(Arrays.asList(fromPath));
            return this;
        }

        public final String getFromType() {
            return this.fromType;
        }

        public final void setFromType(String fromType) {
            this.fromType = fromType;
        }

        @Override
        public final Builder fromType(String fromType) {
            this.fromType = fromType;
            return this;
        }

        public final String getToType() {
            return this.toType;
        }

        public final void setToType(String toType) {
            this.toType = toType;
        }

        @Override
        public final Builder toType(String toType) {
            this.toType = toType;
            return this;
        }

        public final Boolean getDropped() {
            return this.dropped;
        }

        public final void setDropped(Boolean dropped) {
            this.dropped = dropped;
        }

        @Override
        public final Builder dropped(Boolean dropped) {
            this.dropped = dropped;
            return this;
        }

        public final List<Builder> getChildren() {
            List<Builder> result = MappingsCopier.copyToBuilder(this.children);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildren(Collection<BuilderImpl> children) {
            this.children = MappingsCopier.copyFromBuilder(children);
        }

        @Override
        public final Builder children(Collection<Mapping> children) {
            this.children = MappingsCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Mapping ... children) {
            this.children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<Builder> ... children) {
            this.children(Stream.of(children).map(c -> (Mapping)((Builder)Mapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Mapping build() {
            return new Mapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Mapping> {
        public Builder toKey(String var1);

        public Builder fromPath(Collection<String> var1);

        public Builder fromPath(String ... var1);

        public Builder fromType(String var1);

        public Builder toType(String var1);

        public Builder dropped(Boolean var1);

        public Builder children(Collection<Mapping> var1);

        public Builder children(Mapping ... var1);

        public Builder children(Consumer<Builder> ... var1);
    }
}

