/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about the connector definition version, which is a container for connectors.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorDefinitionVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorDefinitionVersion.Builder, ConnectorDefinitionVersion> {
    private static final SdkField<List<Connector>> CONNECTORS_FIELD = SdkField
            .<List<Connector>> builder(MarshallingType.LIST)
            .memberName("Connectors")
            .getter(getter(ConnectorDefinitionVersion::connectors))
            .setter(setter(Builder::connectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Connector> builder(MarshallingType.SDK_POJO)
                                            .constructor(Connector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Connector> connectors;

    private ConnectorDefinitionVersion(BuilderImpl builder) {
        this.connectors = builder.connectors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConnectors() {
        return connectors != null && !(connectors instanceof SdkAutoConstructList);
    }

    /**
     * A list of references to connectors in this version, with their corresponding configuration settings.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectors} method.
     * </p>
     * 
     * @return A list of references to connectors in this version, with their corresponding configuration settings.
     */
    public final List<Connector> connectors() {
        return connectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectors() ? connectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorDefinitionVersion)) {
            return false;
        }
        ConnectorDefinitionVersion other = (ConnectorDefinitionVersion) obj;
        return hasConnectors() == other.hasConnectors() && Objects.equals(connectors(), other.connectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorDefinitionVersion").add("Connectors", hasConnectors() ? connectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Connectors":
            return Optional.ofNullable(clazz.cast(connectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorDefinitionVersion, T> g) {
        return obj -> g.apply((ConnectorDefinitionVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorDefinitionVersion> {
        /**
         * A list of references to connectors in this version, with their corresponding configuration settings.
         * 
         * @param connectors
         *        A list of references to connectors in this version, with their corresponding configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(Collection<Connector> connectors);

        /**
         * A list of references to connectors in this version, with their corresponding configuration settings.
         * 
         * @param connectors
         *        A list of references to connectors in this version, with their corresponding configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(Connector... connectors);

        /**
         * A list of references to connectors in this version, with their corresponding configuration settings. This is
         * a convenience that creates an instance of the {@link List<Connector>.Builder} avoiding the need to create one
         * manually via {@link List<Connector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Connector>.Builder#build()} is called immediately and its
         * result is passed to {@link #connectors(List<Connector>)}.
         * 
         * @param connectors
         *        a consumer that will call methods on {@link List<Connector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectors(List<Connector>)
         */
        Builder connectors(Consumer<Connector.Builder>... connectors);
    }

    static final class BuilderImpl implements Builder {
        private List<Connector> connectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorDefinitionVersion model) {
            connectors(model.connectors);
        }

        public final List<Connector.Builder> getConnectors() {
            List<Connector.Builder> result = ___listOfConnectorCopier.copyToBuilder(this.connectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectors(Collection<Connector.BuilderImpl> connectors) {
            this.connectors = ___listOfConnectorCopier.copyFromBuilder(connectors);
        }

        @Override
        @Transient
        public final Builder connectors(Collection<Connector> connectors) {
            this.connectors = ___listOfConnectorCopier.copy(connectors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connectors(Connector... connectors) {
            connectors(Arrays.asList(connectors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connectors(Consumer<Connector.Builder>... connectors) {
            connectors(Stream.of(connectors).map(c -> Connector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConnectorDefinitionVersion build() {
            return new ConnectorDefinitionVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
