/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSubscriptionDefinitionVersionRequest extends GreengrassRequest implements
        ToCopyableBuilder<GetSubscriptionDefinitionVersionRequest.Builder, GetSubscriptionDefinitionVersionRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetSubscriptionDefinitionVersionRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<String> SUBSCRIPTION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionDefinitionId")
            .getter(getter(GetSubscriptionDefinitionVersionRequest::subscriptionDefinitionId))
            .setter(setter(Builder::subscriptionDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SubscriptionDefinitionId").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_DEFINITION_VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionDefinitionVersionId")
            .getter(getter(GetSubscriptionDefinitionVersionRequest::subscriptionDefinitionVersionId))
            .setter(setter(Builder::subscriptionDefinitionVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SubscriptionDefinitionVersionId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SUBSCRIPTION_DEFINITION_ID_FIELD, SUBSCRIPTION_DEFINITION_VERSION_ID_FIELD));

    private final String nextToken;

    private final String subscriptionDefinitionId;

    private final String subscriptionDefinitionVersionId;

    private GetSubscriptionDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.subscriptionDefinitionId = builder.subscriptionDefinitionId;
        this.subscriptionDefinitionVersionId = builder.subscriptionDefinitionVersionId;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * The ID of the subscription definition.
     * 
     * @return The ID of the subscription definition.
     */
    public final String subscriptionDefinitionId() {
        return subscriptionDefinitionId;
    }

    /**
     * The ID of the subscription definition version. This value maps to the ''Version'' property of the corresponding
     * ''VersionInformation'' object, which is returned by ''ListSubscriptionDefinitionVersions'' requests. If the
     * version is the last one that was associated with a subscription definition, the value also maps to the
     * ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
     * 
     * @return The ID of the subscription definition version. This value maps to the ''Version'' property of the
     *         corresponding ''VersionInformation'' object, which is returned by ''ListSubscriptionDefinitionVersions''
     *         requests. If the version is the last one that was associated with a subscription definition, the value
     *         also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
     */
    public final String subscriptionDefinitionVersionId() {
        return subscriptionDefinitionVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionDefinitionVersionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubscriptionDefinitionVersionRequest)) {
            return false;
        }
        GetSubscriptionDefinitionVersionRequest other = (GetSubscriptionDefinitionVersionRequest) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(subscriptionDefinitionId(), other.subscriptionDefinitionId())
                && Objects.equals(subscriptionDefinitionVersionId(), other.subscriptionDefinitionVersionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSubscriptionDefinitionVersionRequest").add("NextToken", nextToken())
                .add("SubscriptionDefinitionId", subscriptionDefinitionId())
                .add("SubscriptionDefinitionVersionId", subscriptionDefinitionVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SubscriptionDefinitionId":
            return Optional.ofNullable(clazz.cast(subscriptionDefinitionId()));
        case "SubscriptionDefinitionVersionId":
            return Optional.ofNullable(clazz.cast(subscriptionDefinitionVersionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSubscriptionDefinitionVersionRequest, T> g) {
        return obj -> g.apply((GetSubscriptionDefinitionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSubscriptionDefinitionVersionRequest> {
        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * The ID of the subscription definition.
         * 
         * @param subscriptionDefinitionId
         *        The ID of the subscription definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionDefinitionId(String subscriptionDefinitionId);

        /**
         * The ID of the subscription definition version. This value maps to the ''Version'' property of the
         * corresponding ''VersionInformation'' object, which is returned by ''ListSubscriptionDefinitionVersions''
         * requests. If the version is the last one that was associated with a subscription definition, the value also
         * maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
         * 
         * @param subscriptionDefinitionVersionId
         *        The ID of the subscription definition version. This value maps to the ''Version'' property of the
         *        corresponding ''VersionInformation'' object, which is returned by
         *        ''ListSubscriptionDefinitionVersions'' requests. If the version is the last one that was associated
         *        with a subscription definition, the value also maps to the ''LatestVersion'' property of the
         *        corresponding ''DefinitionInformation'' object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionDefinitionVersionId(String subscriptionDefinitionVersionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String nextToken;

        private String subscriptionDefinitionId;

        private String subscriptionDefinitionVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubscriptionDefinitionVersionRequest model) {
            super(model);
            nextToken(model.nextToken);
            subscriptionDefinitionId(model.subscriptionDefinitionId);
            subscriptionDefinitionVersionId(model.subscriptionDefinitionVersionId);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSubscriptionDefinitionId() {
            return subscriptionDefinitionId;
        }

        public final void setSubscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
        }

        @Override
        @Transient
        public final Builder subscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
            return this;
        }

        public final String getSubscriptionDefinitionVersionId() {
            return subscriptionDefinitionVersionId;
        }

        public final void setSubscriptionDefinitionVersionId(String subscriptionDefinitionVersionId) {
            this.subscriptionDefinitionVersionId = subscriptionDefinitionVersionId;
        }

        @Override
        @Transient
        public final Builder subscriptionDefinitionVersionId(String subscriptionDefinitionVersionId) {
            this.subscriptionDefinitionVersionId = subscriptionDefinitionVersionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSubscriptionDefinitionVersionRequest build() {
            return new GetSubscriptionDefinitionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
