/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A container for resource data. The container takes only one of the following supported resource data types:
 * ''LocalDeviceResourceData'', ''LocalVolumeResourceData'', ''SageMakerMachineLearningModelResourceData'',
 * ''S3MachineLearningModelResourceData'', ''SecretsManagerSecretResourceData''.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDataContainer implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceDataContainer.Builder, ResourceDataContainer> {
    private static final SdkField<LocalDeviceResourceData> LOCAL_DEVICE_RESOURCE_DATA_FIELD = SdkField
            .<LocalDeviceResourceData> builder(MarshallingType.SDK_POJO).memberName("LocalDeviceResourceData")
            .getter(getter(ResourceDataContainer::localDeviceResourceData)).setter(setter(Builder::localDeviceResourceData))
            .constructor(LocalDeviceResourceData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDeviceResourceData").build())
            .build();

    private static final SdkField<LocalVolumeResourceData> LOCAL_VOLUME_RESOURCE_DATA_FIELD = SdkField
            .<LocalVolumeResourceData> builder(MarshallingType.SDK_POJO).memberName("LocalVolumeResourceData")
            .getter(getter(ResourceDataContainer::localVolumeResourceData)).setter(setter(Builder::localVolumeResourceData))
            .constructor(LocalVolumeResourceData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalVolumeResourceData").build())
            .build();

    private static final SdkField<S3MachineLearningModelResourceData> S3_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD = SdkField
            .<S3MachineLearningModelResourceData> builder(MarshallingType.SDK_POJO)
            .memberName("S3MachineLearningModelResourceData")
            .getter(getter(ResourceDataContainer::s3MachineLearningModelResourceData))
            .setter(setter(Builder::s3MachineLearningModelResourceData))
            .constructor(S3MachineLearningModelResourceData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3MachineLearningModelResourceData")
                    .build()).build();

    private static final SdkField<SageMakerMachineLearningModelResourceData> SAGE_MAKER_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD = SdkField
            .<SageMakerMachineLearningModelResourceData> builder(MarshallingType.SDK_POJO)
            .memberName("SageMakerMachineLearningModelResourceData")
            .getter(getter(ResourceDataContainer::sageMakerMachineLearningModelResourceData))
            .setter(setter(Builder::sageMakerMachineLearningModelResourceData))
            .constructor(SageMakerMachineLearningModelResourceData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SageMakerMachineLearningModelResourceData").build()).build();

    private static final SdkField<SecretsManagerSecretResourceData> SECRETS_MANAGER_SECRET_RESOURCE_DATA_FIELD = SdkField
            .<SecretsManagerSecretResourceData> builder(MarshallingType.SDK_POJO)
            .memberName("SecretsManagerSecretResourceData")
            .getter(getter(ResourceDataContainer::secretsManagerSecretResourceData))
            .setter(setter(Builder::secretsManagerSecretResourceData))
            .constructor(SecretsManagerSecretResourceData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretResourceData")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_DEVICE_RESOURCE_DATA_FIELD, LOCAL_VOLUME_RESOURCE_DATA_FIELD, S3_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD,
            SAGE_MAKER_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD, SECRETS_MANAGER_SECRET_RESOURCE_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final LocalDeviceResourceData localDeviceResourceData;

    private final LocalVolumeResourceData localVolumeResourceData;

    private final S3MachineLearningModelResourceData s3MachineLearningModelResourceData;

    private final SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData;

    private final SecretsManagerSecretResourceData secretsManagerSecretResourceData;

    private ResourceDataContainer(BuilderImpl builder) {
        this.localDeviceResourceData = builder.localDeviceResourceData;
        this.localVolumeResourceData = builder.localVolumeResourceData;
        this.s3MachineLearningModelResourceData = builder.s3MachineLearningModelResourceData;
        this.sageMakerMachineLearningModelResourceData = builder.sageMakerMachineLearningModelResourceData;
        this.secretsManagerSecretResourceData = builder.secretsManagerSecretResourceData;
    }

    /**
     * Attributes that define the local device resource.
     * 
     * @return Attributes that define the local device resource.
     */
    public final LocalDeviceResourceData localDeviceResourceData() {
        return localDeviceResourceData;
    }

    /**
     * Attributes that define the local volume resource.
     * 
     * @return Attributes that define the local volume resource.
     */
    public final LocalVolumeResourceData localVolumeResourceData() {
        return localVolumeResourceData;
    }

    /**
     * Attributes that define an Amazon S3 machine learning resource.
     * 
     * @return Attributes that define an Amazon S3 machine learning resource.
     */
    public final S3MachineLearningModelResourceData s3MachineLearningModelResourceData() {
        return s3MachineLearningModelResourceData;
    }

    /**
     * Attributes that define an Amazon SageMaker machine learning resource.
     * 
     * @return Attributes that define an Amazon SageMaker machine learning resource.
     */
    public final SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData() {
        return sageMakerMachineLearningModelResourceData;
    }

    /**
     * Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
     * 
     * @return Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
     */
    public final SecretsManagerSecretResourceData secretsManagerSecretResourceData() {
        return secretsManagerSecretResourceData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localDeviceResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(localVolumeResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(s3MachineLearningModelResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerMachineLearningModelResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecretResourceData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataContainer)) {
            return false;
        }
        ResourceDataContainer other = (ResourceDataContainer) obj;
        return Objects.equals(localDeviceResourceData(), other.localDeviceResourceData())
                && Objects.equals(localVolumeResourceData(), other.localVolumeResourceData())
                && Objects.equals(s3MachineLearningModelResourceData(), other.s3MachineLearningModelResourceData())
                && Objects.equals(sageMakerMachineLearningModelResourceData(), other.sageMakerMachineLearningModelResourceData())
                && Objects.equals(secretsManagerSecretResourceData(), other.secretsManagerSecretResourceData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDataContainer").add("LocalDeviceResourceData", localDeviceResourceData())
                .add("LocalVolumeResourceData", localVolumeResourceData())
                .add("S3MachineLearningModelResourceData", s3MachineLearningModelResourceData())
                .add("SageMakerMachineLearningModelResourceData", sageMakerMachineLearningModelResourceData())
                .add("SecretsManagerSecretResourceData", secretsManagerSecretResourceData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalDeviceResourceData":
            return Optional.ofNullable(clazz.cast(localDeviceResourceData()));
        case "LocalVolumeResourceData":
            return Optional.ofNullable(clazz.cast(localVolumeResourceData()));
        case "S3MachineLearningModelResourceData":
            return Optional.ofNullable(clazz.cast(s3MachineLearningModelResourceData()));
        case "SageMakerMachineLearningModelResourceData":
            return Optional.ofNullable(clazz.cast(sageMakerMachineLearningModelResourceData()));
        case "SecretsManagerSecretResourceData":
            return Optional.ofNullable(clazz.cast(secretsManagerSecretResourceData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataContainer, T> g) {
        return obj -> g.apply((ResourceDataContainer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDataContainer> {
        /**
         * Attributes that define the local device resource.
         * 
         * @param localDeviceResourceData
         *        Attributes that define the local device resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDeviceResourceData(LocalDeviceResourceData localDeviceResourceData);

        /**
         * Attributes that define the local device resource. This is a convenience that creates an instance of the
         * {@link LocalDeviceResourceData.Builder} avoiding the need to create one manually via
         * {@link LocalDeviceResourceData#builder()}.
         *
         * When the {@link Consumer} completes, {@link LocalDeviceResourceData.Builder#build()} is called immediately
         * and its result is passed to {@link #localDeviceResourceData(LocalDeviceResourceData)}.
         * 
         * @param localDeviceResourceData
         *        a consumer that will call methods on {@link LocalDeviceResourceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localDeviceResourceData(LocalDeviceResourceData)
         */
        default Builder localDeviceResourceData(Consumer<LocalDeviceResourceData.Builder> localDeviceResourceData) {
            return localDeviceResourceData(LocalDeviceResourceData.builder().applyMutation(localDeviceResourceData).build());
        }

        /**
         * Attributes that define the local volume resource.
         * 
         * @param localVolumeResourceData
         *        Attributes that define the local volume resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localVolumeResourceData(LocalVolumeResourceData localVolumeResourceData);

        /**
         * Attributes that define the local volume resource. This is a convenience that creates an instance of the
         * {@link LocalVolumeResourceData.Builder} avoiding the need to create one manually via
         * {@link LocalVolumeResourceData#builder()}.
         *
         * When the {@link Consumer} completes, {@link LocalVolumeResourceData.Builder#build()} is called immediately
         * and its result is passed to {@link #localVolumeResourceData(LocalVolumeResourceData)}.
         * 
         * @param localVolumeResourceData
         *        a consumer that will call methods on {@link LocalVolumeResourceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localVolumeResourceData(LocalVolumeResourceData)
         */
        default Builder localVolumeResourceData(Consumer<LocalVolumeResourceData.Builder> localVolumeResourceData) {
            return localVolumeResourceData(LocalVolumeResourceData.builder().applyMutation(localVolumeResourceData).build());
        }

        /**
         * Attributes that define an Amazon S3 machine learning resource.
         * 
         * @param s3MachineLearningModelResourceData
         *        Attributes that define an Amazon S3 machine learning resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3MachineLearningModelResourceData(S3MachineLearningModelResourceData s3MachineLearningModelResourceData);

        /**
         * Attributes that define an Amazon S3 machine learning resource. This is a convenience that creates an instance
         * of the {@link S3MachineLearningModelResourceData.Builder} avoiding the need to create one manually via
         * {@link S3MachineLearningModelResourceData#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3MachineLearningModelResourceData.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #s3MachineLearningModelResourceData(S3MachineLearningModelResourceData)}.
         * 
         * @param s3MachineLearningModelResourceData
         *        a consumer that will call methods on {@link S3MachineLearningModelResourceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3MachineLearningModelResourceData(S3MachineLearningModelResourceData)
         */
        default Builder s3MachineLearningModelResourceData(
                Consumer<S3MachineLearningModelResourceData.Builder> s3MachineLearningModelResourceData) {
            return s3MachineLearningModelResourceData(S3MachineLearningModelResourceData.builder()
                    .applyMutation(s3MachineLearningModelResourceData).build());
        }

        /**
         * Attributes that define an Amazon SageMaker machine learning resource.
         * 
         * @param sageMakerMachineLearningModelResourceData
         *        Attributes that define an Amazon SageMaker machine learning resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerMachineLearningModelResourceData(
                SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData);

        /**
         * Attributes that define an Amazon SageMaker machine learning resource. This is a convenience that creates an
         * instance of the {@link SageMakerMachineLearningModelResourceData.Builder} avoiding the need to create one
         * manually via {@link SageMakerMachineLearningModelResourceData#builder()}.
         *
         * When the {@link Consumer} completes, {@link SageMakerMachineLearningModelResourceData.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceData)}.
         * 
         * @param sageMakerMachineLearningModelResourceData
         *        a consumer that will call methods on {@link SageMakerMachineLearningModelResourceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceData)
         */
        default Builder sageMakerMachineLearningModelResourceData(
                Consumer<SageMakerMachineLearningModelResourceData.Builder> sageMakerMachineLearningModelResourceData) {
            return sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceData.builder()
                    .applyMutation(sageMakerMachineLearningModelResourceData).build());
        }

        /**
         * Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
         * 
         * @param secretsManagerSecretResourceData
         *        Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecretResourceData(SecretsManagerSecretResourceData secretsManagerSecretResourceData);

        /**
         * Attributes that define a secret resource, which references a secret from AWS Secrets Manager. This is a
         * convenience that creates an instance of the {@link SecretsManagerSecretResourceData.Builder} avoiding the
         * need to create one manually via {@link SecretsManagerSecretResourceData#builder()}.
         *
         * When the {@link Consumer} completes, {@link SecretsManagerSecretResourceData.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #secretsManagerSecretResourceData(SecretsManagerSecretResourceData)}.
         * 
         * @param secretsManagerSecretResourceData
         *        a consumer that will call methods on {@link SecretsManagerSecretResourceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManagerSecretResourceData(SecretsManagerSecretResourceData)
         */
        default Builder secretsManagerSecretResourceData(
                Consumer<SecretsManagerSecretResourceData.Builder> secretsManagerSecretResourceData) {
            return secretsManagerSecretResourceData(SecretsManagerSecretResourceData.builder()
                    .applyMutation(secretsManagerSecretResourceData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LocalDeviceResourceData localDeviceResourceData;

        private LocalVolumeResourceData localVolumeResourceData;

        private S3MachineLearningModelResourceData s3MachineLearningModelResourceData;

        private SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData;

        private SecretsManagerSecretResourceData secretsManagerSecretResourceData;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataContainer model) {
            localDeviceResourceData(model.localDeviceResourceData);
            localVolumeResourceData(model.localVolumeResourceData);
            s3MachineLearningModelResourceData(model.s3MachineLearningModelResourceData);
            sageMakerMachineLearningModelResourceData(model.sageMakerMachineLearningModelResourceData);
            secretsManagerSecretResourceData(model.secretsManagerSecretResourceData);
        }

        public final LocalDeviceResourceData.Builder getLocalDeviceResourceData() {
            return localDeviceResourceData != null ? localDeviceResourceData.toBuilder() : null;
        }

        public final void setLocalDeviceResourceData(LocalDeviceResourceData.BuilderImpl localDeviceResourceData) {
            this.localDeviceResourceData = localDeviceResourceData != null ? localDeviceResourceData.build() : null;
        }

        @Override
        @Transient
        public final Builder localDeviceResourceData(LocalDeviceResourceData localDeviceResourceData) {
            this.localDeviceResourceData = localDeviceResourceData;
            return this;
        }

        public final LocalVolumeResourceData.Builder getLocalVolumeResourceData() {
            return localVolumeResourceData != null ? localVolumeResourceData.toBuilder() : null;
        }

        public final void setLocalVolumeResourceData(LocalVolumeResourceData.BuilderImpl localVolumeResourceData) {
            this.localVolumeResourceData = localVolumeResourceData != null ? localVolumeResourceData.build() : null;
        }

        @Override
        @Transient
        public final Builder localVolumeResourceData(LocalVolumeResourceData localVolumeResourceData) {
            this.localVolumeResourceData = localVolumeResourceData;
            return this;
        }

        public final S3MachineLearningModelResourceData.Builder getS3MachineLearningModelResourceData() {
            return s3MachineLearningModelResourceData != null ? s3MachineLearningModelResourceData.toBuilder() : null;
        }

        public final void setS3MachineLearningModelResourceData(
                S3MachineLearningModelResourceData.BuilderImpl s3MachineLearningModelResourceData) {
            this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData != null ? s3MachineLearningModelResourceData
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder s3MachineLearningModelResourceData(
                S3MachineLearningModelResourceData s3MachineLearningModelResourceData) {
            this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData;
            return this;
        }

        public final SageMakerMachineLearningModelResourceData.Builder getSageMakerMachineLearningModelResourceData() {
            return sageMakerMachineLearningModelResourceData != null ? sageMakerMachineLearningModelResourceData.toBuilder()
                    : null;
        }

        public final void setSageMakerMachineLearningModelResourceData(
                SageMakerMachineLearningModelResourceData.BuilderImpl sageMakerMachineLearningModelResourceData) {
            this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData != null ? sageMakerMachineLearningModelResourceData
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder sageMakerMachineLearningModelResourceData(
                SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData) {
            this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData;
            return this;
        }

        public final SecretsManagerSecretResourceData.Builder getSecretsManagerSecretResourceData() {
            return secretsManagerSecretResourceData != null ? secretsManagerSecretResourceData.toBuilder() : null;
        }

        public final void setSecretsManagerSecretResourceData(
                SecretsManagerSecretResourceData.BuilderImpl secretsManagerSecretResourceData) {
            this.secretsManagerSecretResourceData = secretsManagerSecretResourceData != null ? secretsManagerSecretResourceData
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder secretsManagerSecretResourceData(SecretsManagerSecretResourceData secretsManagerSecretResourceData) {
            this.secretsManagerSecretResourceData = secretsManagerSecretResourceData;
            return this;
        }

        @Override
        public ResourceDataContainer build() {
            return new ResourceDataContainer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
