/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType;
import software.amazon.awssdk.services.groundstation.model.ConfigDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Source
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Source> {
    private static final SdkField<ConfigDetails> CONFIG_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configDetails").getter(Source.getter(Source::configDetails)).setter(Source.setter(Builder::configDetails)).constructor(ConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configDetails").build()}).build();
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configId").getter(Source.getter(Source::configId)).setter(Source.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()}).build();
    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configType").getter(Source.getter(Source::configTypeAsString)).setter(Source.setter(Builder::configType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configType").build()}).build();
    private static final SdkField<String> DATAFLOW_SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataflowSourceRegion").getter(Source.getter(Source::dataflowSourceRegion)).setter(Source.setter(Builder::dataflowSourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowSourceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_DETAILS_FIELD, CONFIG_ID_FIELD, CONFIG_TYPE_FIELD, DATAFLOW_SOURCE_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Source.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ConfigDetails configDetails;
    private final String configId;
    private final String configType;
    private final String dataflowSourceRegion;

    private Source(BuilderImpl builder) {
        this.configDetails = builder.configDetails;
        this.configId = builder.configId;
        this.configType = builder.configType;
        this.dataflowSourceRegion = builder.dataflowSourceRegion;
    }

    public final ConfigDetails configDetails() {
        return this.configDetails;
    }

    public final String configId() {
        return this.configId;
    }

    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(this.configType);
    }

    public final String configTypeAsString() {
        return this.configType;
    }

    public final String dataflowSourceRegion() {
        return this.dataflowSourceRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataflowSourceRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.configDetails(), other.configDetails()) && Objects.equals(this.configId(), other.configId()) && Objects.equals(this.configTypeAsString(), other.configTypeAsString()) && Objects.equals(this.dataflowSourceRegion(), other.dataflowSourceRegion());
    }

    public final String toString() {
        return ToString.builder((String)"Source").add("ConfigDetails", (Object)this.configDetails()).add("ConfigId", (Object)this.configId()).add("ConfigType", (Object)this.configTypeAsString()).add("DataflowSourceRegion", (Object)this.dataflowSourceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configDetails": {
                return Optional.ofNullable(clazz.cast(this.configDetails()));
            }
            case "configId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "configType": {
                return Optional.ofNullable(clazz.cast(this.configTypeAsString()));
            }
            case "dataflowSourceRegion": {
                return Optional.ofNullable(clazz.cast(this.dataflowSourceRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configDetails", CONFIG_DETAILS_FIELD);
        map.put("configId", CONFIG_ID_FIELD);
        map.put("configType", CONFIG_TYPE_FIELD);
        map.put("dataflowSourceRegion", DATAFLOW_SOURCE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConfigDetails configDetails;
        private String configId;
        private String configType;
        private String dataflowSourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.configDetails(model.configDetails);
            this.configId(model.configId);
            this.configType(model.configType);
            this.dataflowSourceRegion(model.dataflowSourceRegion);
        }

        public final ConfigDetails.Builder getConfigDetails() {
            return this.configDetails != null ? this.configDetails.toBuilder() : null;
        }

        public final void setConfigDetails(ConfigDetails.BuilderImpl configDetails) {
            this.configDetails = configDetails != null ? configDetails.build() : null;
        }

        @Override
        public final Builder configDetails(ConfigDetails configDetails) {
            this.configDetails = configDetails;
            return this;
        }

        public final String getConfigId() {
            return this.configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getConfigType() {
            return this.configType;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final String getDataflowSourceRegion() {
            return this.dataflowSourceRegion;
        }

        public final void setDataflowSourceRegion(String dataflowSourceRegion) {
            this.dataflowSourceRegion = dataflowSourceRegion;
        }

        @Override
        public final Builder dataflowSourceRegion(String dataflowSourceRegion) {
            this.dataflowSourceRegion = dataflowSourceRegion;
            return this;
        }

        public Source build() {
            return new Source(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Source> {
        public Builder configDetails(ConfigDetails var1);

        default public Builder configDetails(Consumer<ConfigDetails.Builder> configDetails) {
            return this.configDetails((ConfigDetails)((ConfigDetails.Builder)ConfigDetails.builder().applyMutation(configDetails)).build());
        }

        public Builder configId(String var1);

        public Builder configType(String var1);

        public Builder configType(ConfigCapabilityType var1);

        public Builder dataflowSourceRegion(String var1);
    }
}

