/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BandwidthUnits {
    G_HZ("GHz"),
    M_HZ("MHz"),
    K_HZ("kHz"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BandwidthUnits> VALUE_MAP;
    private final String value;

    private BandwidthUnits(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BandwidthUnits fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BandwidthUnits> knownValues() {
        EnumSet<BandwidthUnits> knownValues = EnumSet.allOf(BandwidthUnits.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BandwidthUnits.class, BandwidthUnits::toString);
    }
}

