/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EphemerisType {
    TLE("TLE"),
    OEM("OEM"),
    AZ_EL("AZ_EL"),
    SERVICE_MANAGED("SERVICE_MANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EphemerisType> VALUE_MAP;
    private final String value;

    private EphemerisType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EphemerisType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EphemerisType> knownValues() {
        EnumSet<EphemerisType> knownValues = EnumSet.allOf(EphemerisType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EphemerisType.class, EphemerisType::toString);
    }
}

