/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.DataflowEdgeListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.KmsKey;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMissionProfileResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, GetMissionProfileResponse> {
    private static final SdkField<String> MISSION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileId").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::missionProfileId)).setter(GetMissionProfileResponse.setter(Builder::missionProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileId").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileArn").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::missionProfileArn)).setter(GetMissionProfileResponse.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::name)).setter(GetMissionProfileResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::region)).setter(GetMissionProfileResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("contactPrePassDurationSeconds").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::contactPrePassDurationSeconds)).setter(GetMissionProfileResponse.setter(Builder::contactPrePassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds").build()}).build();
    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("contactPostPassDurationSeconds").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::contactPostPassDurationSeconds)).setter(GetMissionProfileResponse.setter(Builder::contactPostPassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds").build()}).build();
    private static final SdkField<Integer> MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumViableContactDurationSeconds").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::minimumViableContactDurationSeconds)).setter(GetMissionProfileResponse.setter(Builder::minimumViableContactDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumViableContactDurationSeconds").build()}).build();
    private static final SdkField<List<List<String>>> DATAFLOW_EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataflowEdges").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::dataflowEdges)).setter(GetMissionProfileResponse.setter(Builder::dataflowEdges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEdges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TRACKING_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackingConfigArn").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::trackingConfigArn)).setter(GetMissionProfileResponse.setter(Builder::trackingConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingConfigArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::tags)).setter(GetMissionProfileResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<KmsKey> STREAMS_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamsKmsKey").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::streamsKmsKey)).setter(GetMissionProfileResponse.setter(Builder::streamsKmsKey)).constructor(KmsKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamsKmsKey").build()}).build();
    private static final SdkField<String> STREAMS_KMS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamsKmsRole").getter(GetMissionProfileResponse.getter(GetMissionProfileResponse::streamsKmsRole)).setter(GetMissionProfileResponse.setter(Builder::streamsKmsRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamsKmsRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MISSION_PROFILE_ID_FIELD, MISSION_PROFILE_ARN_FIELD, NAME_FIELD, REGION_FIELD, CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, CONTACT_POST_PASS_DURATION_SECONDS_FIELD, MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD, DATAFLOW_EDGES_FIELD, TRACKING_CONFIG_ARN_FIELD, TAGS_FIELD, STREAMS_KMS_KEY_FIELD, STREAMS_KMS_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMissionProfileResponse.memberNameToFieldInitializer();
    private final String missionProfileId;
    private final String missionProfileArn;
    private final String name;
    private final String region;
    private final Integer contactPrePassDurationSeconds;
    private final Integer contactPostPassDurationSeconds;
    private final Integer minimumViableContactDurationSeconds;
    private final List<List<String>> dataflowEdges;
    private final String trackingConfigArn;
    private final Map<String, String> tags;
    private final KmsKey streamsKmsKey;
    private final String streamsKmsRole;

    private GetMissionProfileResponse(BuilderImpl builder) {
        super(builder);
        this.missionProfileId = builder.missionProfileId;
        this.missionProfileArn = builder.missionProfileArn;
        this.name = builder.name;
        this.region = builder.region;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.minimumViableContactDurationSeconds = builder.minimumViableContactDurationSeconds;
        this.dataflowEdges = builder.dataflowEdges;
        this.trackingConfigArn = builder.trackingConfigArn;
        this.tags = builder.tags;
        this.streamsKmsKey = builder.streamsKmsKey;
        this.streamsKmsRole = builder.streamsKmsRole;
    }

    public final String missionProfileId() {
        return this.missionProfileId;
    }

    public final String missionProfileArn() {
        return this.missionProfileArn;
    }

    public final String name() {
        return this.name;
    }

    public final String region() {
        return this.region;
    }

    public final Integer contactPrePassDurationSeconds() {
        return this.contactPrePassDurationSeconds;
    }

    public final Integer contactPostPassDurationSeconds() {
        return this.contactPostPassDurationSeconds;
    }

    public final Integer minimumViableContactDurationSeconds() {
        return this.minimumViableContactDurationSeconds;
    }

    public final boolean hasDataflowEdges() {
        return this.dataflowEdges != null && !(this.dataflowEdges instanceof SdkAutoConstructList);
    }

    public final List<List<String>> dataflowEdges() {
        return this.dataflowEdges;
    }

    public final String trackingConfigArn() {
        return this.trackingConfigArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final KmsKey streamsKmsKey() {
        return this.streamsKmsKey;
    }

    public final String streamsKmsRole() {
        return this.streamsKmsRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumViableContactDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataflowEdges() ? this.dataflowEdges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.streamsKmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamsKmsRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMissionProfileResponse)) {
            return false;
        }
        GetMissionProfileResponse other = (GetMissionProfileResponse)((Object)obj);
        return Objects.equals(this.missionProfileId(), other.missionProfileId()) && Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds()) && Objects.equals(this.contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds()) && Objects.equals(this.minimumViableContactDurationSeconds(), other.minimumViableContactDurationSeconds()) && this.hasDataflowEdges() == other.hasDataflowEdges() && Objects.equals(this.dataflowEdges(), other.dataflowEdges()) && Objects.equals(this.trackingConfigArn(), other.trackingConfigArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.streamsKmsKey(), other.streamsKmsKey()) && Objects.equals(this.streamsKmsRole(), other.streamsKmsRole());
    }

    public final String toString() {
        return ToString.builder((String)"GetMissionProfileResponse").add("MissionProfileId", (Object)this.missionProfileId()).add("MissionProfileArn", (Object)this.missionProfileArn()).add("Name", (Object)this.name()).add("Region", (Object)this.region()).add("ContactPrePassDurationSeconds", (Object)this.contactPrePassDurationSeconds()).add("ContactPostPassDurationSeconds", (Object)this.contactPostPassDurationSeconds()).add("MinimumViableContactDurationSeconds", (Object)this.minimumViableContactDurationSeconds()).add("DataflowEdges", this.hasDataflowEdges() ? this.dataflowEdges() : null).add("TrackingConfigArn", (Object)this.trackingConfigArn()).add("Tags", this.hasTags() ? this.tags() : null).add("StreamsKmsKey", (Object)this.streamsKmsKey()).add("StreamsKmsRole", (Object)this.streamsKmsRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "missionProfileId": {
                return Optional.ofNullable(clazz.cast(this.missionProfileId()));
            }
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "contactPrePassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPrePassDurationSeconds()));
            }
            case "contactPostPassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPostPassDurationSeconds()));
            }
            case "minimumViableContactDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.minimumViableContactDurationSeconds()));
            }
            case "dataflowEdges": {
                return Optional.ofNullable(clazz.cast(this.dataflowEdges()));
            }
            case "trackingConfigArn": {
                return Optional.ofNullable(clazz.cast(this.trackingConfigArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "streamsKmsKey": {
                return Optional.ofNullable(clazz.cast(this.streamsKmsKey()));
            }
            case "streamsKmsRole": {
                return Optional.ofNullable(clazz.cast(this.streamsKmsRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("missionProfileId", MISSION_PROFILE_ID_FIELD);
        map.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("region", REGION_FIELD);
        map.put("contactPrePassDurationSeconds", CONTACT_PRE_PASS_DURATION_SECONDS_FIELD);
        map.put("contactPostPassDurationSeconds", CONTACT_POST_PASS_DURATION_SECONDS_FIELD);
        map.put("minimumViableContactDurationSeconds", MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD);
        map.put("dataflowEdges", DATAFLOW_EDGES_FIELD);
        map.put("trackingConfigArn", TRACKING_CONFIG_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("streamsKmsKey", STREAMS_KMS_KEY_FIELD);
        map.put("streamsKmsRole", STREAMS_KMS_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMissionProfileResponse, T> g) {
        return obj -> g.apply((GetMissionProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String missionProfileId;
        private String missionProfileArn;
        private String name;
        private String region;
        private Integer contactPrePassDurationSeconds;
        private Integer contactPostPassDurationSeconds;
        private Integer minimumViableContactDurationSeconds;
        private List<List<String>> dataflowEdges = DefaultSdkAutoConstructList.getInstance();
        private String trackingConfigArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private KmsKey streamsKmsKey;
        private String streamsKmsRole;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMissionProfileResponse model) {
            super(model);
            this.missionProfileId(model.missionProfileId);
            this.missionProfileArn(model.missionProfileArn);
            this.name(model.name);
            this.region(model.region);
            this.contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            this.contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            this.minimumViableContactDurationSeconds(model.minimumViableContactDurationSeconds);
            this.dataflowEdges(model.dataflowEdges);
            this.trackingConfigArn(model.trackingConfigArn);
            this.tags(model.tags);
            this.streamsKmsKey(model.streamsKmsKey);
            this.streamsKmsRole(model.streamsKmsRole);
        }

        public final String getMissionProfileId() {
            return this.missionProfileId;
        }

        public final void setMissionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
        }

        @Override
        public final Builder missionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
            return this;
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return this.contactPrePassDurationSeconds;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final Integer getContactPostPassDurationSeconds() {
            return this.contactPostPassDurationSeconds;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final Integer getMinimumViableContactDurationSeconds() {
            return this.minimumViableContactDurationSeconds;
        }

        public final void setMinimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
        }

        @Override
        public final Builder minimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
            return this;
        }

        public final Collection<? extends Collection<String>> getDataflowEdges() {
            if (this.dataflowEdges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataflowEdges;
        }

        public final void setDataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
        }

        @Override
        public final Builder dataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEdges(Collection<String> ... dataflowEdges) {
            this.dataflowEdges((Collection<? extends Collection<String>>)Arrays.asList(dataflowEdges));
            return this;
        }

        public final String getTrackingConfigArn() {
            return this.trackingConfigArn;
        }

        public final void setTrackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
        }

        @Override
        public final Builder trackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final KmsKey.Builder getStreamsKmsKey() {
            return this.streamsKmsKey != null ? this.streamsKmsKey.toBuilder() : null;
        }

        public final void setStreamsKmsKey(KmsKey.BuilderImpl streamsKmsKey) {
            this.streamsKmsKey = streamsKmsKey != null ? streamsKmsKey.build() : null;
        }

        @Override
        public final Builder streamsKmsKey(KmsKey streamsKmsKey) {
            this.streamsKmsKey = streamsKmsKey;
            return this;
        }

        public final String getStreamsKmsRole() {
            return this.streamsKmsRole;
        }

        public final void setStreamsKmsRole(String streamsKmsRole) {
            this.streamsKmsRole = streamsKmsRole;
        }

        @Override
        public final Builder streamsKmsRole(String streamsKmsRole) {
            this.streamsKmsRole = streamsKmsRole;
            return this;
        }

        @Override
        public GetMissionProfileResponse build() {
            return new GetMissionProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMissionProfileResponse> {
        public Builder missionProfileId(String var1);

        public Builder missionProfileArn(String var1);

        public Builder name(String var1);

        public Builder region(String var1);

        public Builder contactPrePassDurationSeconds(Integer var1);

        public Builder contactPostPassDurationSeconds(Integer var1);

        public Builder minimumViableContactDurationSeconds(Integer var1);

        public Builder dataflowEdges(Collection<? extends Collection<String>> var1);

        public Builder dataflowEdges(Collection<String> ... var1);

        public Builder trackingConfigArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder streamsKmsKey(KmsKey var1);

        default public Builder streamsKmsKey(Consumer<KmsKey.Builder> streamsKmsKey) {
            return this.streamsKmsKey((KmsKey)((KmsKey.Builder)KmsKey.builder().applyMutation(streamsKmsKey)).build());
        }

        public Builder streamsKmsRole(String var1);
    }
}

