/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.ContactStatus;
import software.amazon.awssdk.services.groundstation.model.EphemerisFilter;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.services.groundstation.model.StatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactsRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, ListContactsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListContactsRequest.getter(ListContactsRequest::maxResults)).setter(ListContactsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListContactsRequest.getter(ListContactsRequest::nextToken)).setter(ListContactsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusList").getter(ListContactsRequest.getter(ListContactsRequest::statusListAsStrings)).setter(ListContactsRequest.setter(Builder::statusListWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListContactsRequest.getter(ListContactsRequest::startTime)).setter(ListContactsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListContactsRequest.getter(ListContactsRequest::endTime)).setter(ListContactsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groundStation").getter(ListContactsRequest.getter(ListContactsRequest::groundStation)).setter(ListContactsRequest.setter(Builder::groundStation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteArn").getter(ListContactsRequest.getter(ListContactsRequest::satelliteArn)).setter(ListContactsRequest.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileArn").getter(ListContactsRequest.getter(ListContactsRequest::missionProfileArn)).setter(ListContactsRequest.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<EphemerisFilter> EPHEMERIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ephemeris").getter(ListContactsRequest.getter(ListContactsRequest::ephemeris)).setter(ListContactsRequest.setter(Builder::ephemeris)).constructor(EphemerisFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeris").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STATUS_LIST_FIELD, START_TIME_FIELD, END_TIME_FIELD, GROUND_STATION_FIELD, SATELLITE_ARN_FIELD, MISSION_PROFILE_ARN_FIELD, EPHEMERIS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListContactsRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> statusList;
    private final Instant startTime;
    private final Instant endTime;
    private final String groundStation;
    private final String satelliteArn;
    private final String missionProfileArn;
    private final EphemerisFilter ephemeris;

    private ListContactsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.statusList = builder.statusList;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.groundStation = builder.groundStation;
        this.satelliteArn = builder.satelliteArn;
        this.missionProfileArn = builder.missionProfileArn;
        this.ephemeris = builder.ephemeris;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<ContactStatus> statusList() {
        return StatusListCopier.copyStringToEnum(this.statusList);
    }

    public final boolean hasStatusList() {
        return this.statusList != null && !(this.statusList instanceof SdkAutoConstructList);
    }

    public final List<String> statusListAsStrings() {
        return this.statusList;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String groundStation() {
        return this.groundStation;
    }

    public final String satelliteArn() {
        return this.satelliteArn;
    }

    public final String missionProfileArn() {
        return this.missionProfileArn;
    }

    public final EphemerisFilter ephemeris() {
        return this.ephemeris;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusList() ? this.statusListAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeris());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsRequest)) {
            return false;
        }
        ListContactsRequest other = (ListContactsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasStatusList() == other.hasStatusList() && Objects.equals(this.statusListAsStrings(), other.statusListAsStrings()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.groundStation(), other.groundStation()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.ephemeris(), other.ephemeris());
    }

    public final String toString() {
        return ToString.builder((String)"ListContactsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("StatusList", this.hasStatusList() ? this.statusListAsStrings() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("GroundStation", (Object)this.groundStation()).add("SatelliteArn", (Object)this.satelliteArn()).add("MissionProfileArn", (Object)this.missionProfileArn()).add("Ephemeris", (Object)this.ephemeris()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "statusList": {
                return Optional.ofNullable(clazz.cast(this.statusListAsStrings()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "groundStation": {
                return Optional.ofNullable(clazz.cast(this.groundStation()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "ephemeris": {
                return Optional.ofNullable(clazz.cast(this.ephemeris()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("statusList", STATUS_LIST_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("groundStation", GROUND_STATION_FIELD);
        map.put("satelliteArn", SATELLITE_ARN_FIELD);
        map.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
        map.put("ephemeris", EPHEMERIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContactsRequest, T> g) {
        return obj -> g.apply((ListContactsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private List<String> statusList = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private String groundStation;
        private String satelliteArn;
        private String missionProfileArn;
        private EphemerisFilter ephemeris;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.statusListWithStrings(model.statusList);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.groundStation(model.groundStation);
            this.satelliteArn(model.satelliteArn);
            this.missionProfileArn(model.missionProfileArn);
            this.ephemeris(model.ephemeris);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getStatusList() {
            if (this.statusList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusList;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = StatusListCopier.copy(statusList);
        }

        @Override
        public final Builder statusListWithStrings(Collection<String> statusList) {
            this.statusList = StatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusListWithStrings(String ... statusList) {
            this.statusListWithStrings(Arrays.asList(statusList));
            return this;
        }

        @Override
        public final Builder statusList(Collection<ContactStatus> statusList) {
            this.statusList = StatusListCopier.copyEnumToString(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(ContactStatus ... statusList) {
            this.statusList(Arrays.asList(statusList));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getGroundStation() {
            return this.groundStation;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final EphemerisFilter.Builder getEphemeris() {
            return this.ephemeris != null ? this.ephemeris.toBuilder() : null;
        }

        public final void setEphemeris(EphemerisFilter.BuilderImpl ephemeris) {
            this.ephemeris = ephemeris != null ? ephemeris.build() : null;
        }

        @Override
        public final Builder ephemeris(EphemerisFilter ephemeris) {
            this.ephemeris = ephemeris;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactsRequest build() {
            return new ListContactsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder statusListWithStrings(Collection<String> var1);

        public Builder statusListWithStrings(String ... var1);

        public Builder statusList(Collection<ContactStatus> var1);

        public Builder statusList(ContactStatus ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder groundStation(String var1);

        public Builder satelliteArn(String var1);

        public Builder missionProfileArn(String var1);

        public Builder ephemeris(EphemerisFilter var1);

        default public Builder ephemeris(Consumer<EphemerisFilter.Builder> ephemeris) {
            return this.ephemeris((EphemerisFilter)((EphemerisFilter.Builder)EphemerisFilter.builder().applyMutation(ephemeris)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

