/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.services.groundstation.model.TrackingOverrides;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReserveContactRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, ReserveContactRequest> {
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileArn").getter(ReserveContactRequest.getter(ReserveContactRequest::missionProfileArn)).setter(ReserveContactRequest.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteArn").getter(ReserveContactRequest.getter(ReserveContactRequest::satelliteArn)).setter(ReserveContactRequest.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ReserveContactRequest.getter(ReserveContactRequest::startTime)).setter(ReserveContactRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ReserveContactRequest.getter(ReserveContactRequest::endTime)).setter(ReserveContactRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groundStation").getter(ReserveContactRequest.getter(ReserveContactRequest::groundStation)).setter(ReserveContactRequest.setter(Builder::groundStation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ReserveContactRequest.getter(ReserveContactRequest::tags)).setter(ReserveContactRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TrackingOverrides> TRACKING_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trackingOverrides").getter(ReserveContactRequest.getter(ReserveContactRequest::trackingOverrides)).setter(ReserveContactRequest.setter(Builder::trackingOverrides)).constructor(TrackingOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingOverrides").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MISSION_PROFILE_ARN_FIELD, SATELLITE_ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, GROUND_STATION_FIELD, TAGS_FIELD, TRACKING_OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReserveContactRequest.memberNameToFieldInitializer();
    private final String missionProfileArn;
    private final String satelliteArn;
    private final Instant startTime;
    private final Instant endTime;
    private final String groundStation;
    private final Map<String, String> tags;
    private final TrackingOverrides trackingOverrides;

    private ReserveContactRequest(BuilderImpl builder) {
        super(builder);
        this.missionProfileArn = builder.missionProfileArn;
        this.satelliteArn = builder.satelliteArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.groundStation = builder.groundStation;
        this.tags = builder.tags;
        this.trackingOverrides = builder.trackingOverrides;
    }

    public final String missionProfileArn() {
        return this.missionProfileArn;
    }

    public final String satelliteArn() {
        return this.satelliteArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String groundStation() {
        return this.groundStation;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TrackingOverrides trackingOverrides() {
        return this.trackingOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingOverrides());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReserveContactRequest)) {
            return false;
        }
        ReserveContactRequest other = (ReserveContactRequest)((Object)obj);
        return Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.groundStation(), other.groundStation()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.trackingOverrides(), other.trackingOverrides());
    }

    public final String toString() {
        return ToString.builder((String)"ReserveContactRequest").add("MissionProfileArn", (Object)this.missionProfileArn()).add("SatelliteArn", (Object)this.satelliteArn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("GroundStation", (Object)this.groundStation()).add("Tags", this.hasTags() ? this.tags() : null).add("TrackingOverrides", (Object)this.trackingOverrides()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "groundStation": {
                return Optional.ofNullable(clazz.cast(this.groundStation()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "trackingOverrides": {
                return Optional.ofNullable(clazz.cast(this.trackingOverrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
        map.put("satelliteArn", SATELLITE_ARN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("groundStation", GROUND_STATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("trackingOverrides", TRACKING_OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReserveContactRequest, T> g) {
        return obj -> g.apply((ReserveContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private String missionProfileArn;
        private String satelliteArn;
        private Instant startTime;
        private Instant endTime;
        private String groundStation;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private TrackingOverrides trackingOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(ReserveContactRequest model) {
            super(model);
            this.missionProfileArn(model.missionProfileArn);
            this.satelliteArn(model.satelliteArn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.groundStation(model.groundStation);
            this.tags(model.tags);
            this.trackingOverrides(model.trackingOverrides);
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getGroundStation() {
            return this.groundStation;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final TrackingOverrides.Builder getTrackingOverrides() {
            return this.trackingOverrides != null ? this.trackingOverrides.toBuilder() : null;
        }

        public final void setTrackingOverrides(TrackingOverrides.BuilderImpl trackingOverrides) {
            this.trackingOverrides = trackingOverrides != null ? trackingOverrides.build() : null;
        }

        @Override
        public final Builder trackingOverrides(TrackingOverrides trackingOverrides) {
            this.trackingOverrides = trackingOverrides;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReserveContactRequest build() {
            return new ReserveContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReserveContactRequest> {
        public Builder missionProfileArn(String var1);

        public Builder satelliteArn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder groundStation(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder trackingOverrides(TrackingOverrides var1);

        default public Builder trackingOverrides(Consumer<TrackingOverrides.Builder> trackingOverrides) {
            return this.trackingOverrides((TrackingOverrides)((TrackingOverrides.Builder)TrackingOverrides.builder().applyMutation(trackingOverrides)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

