/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.ContactStatus;
import software.amazon.awssdk.services.groundstation.model.Elevation;
import software.amazon.awssdk.services.groundstation.model.EphemerisResponseData;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactData> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactId").getter(ContactData.getter(ContactData::contactId)).setter(ContactData.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactId").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileArn").getter(ContactData.getter(ContactData::missionProfileArn)).setter(ContactData.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteArn").getter(ContactData.getter(ContactData::satelliteArn)).setter(ContactData.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ContactData.getter(ContactData::startTime)).setter(ContactData.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ContactData.getter(ContactData::endTime)).setter(ContactData.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Instant> PRE_PASS_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("prePassStartTime").getter(ContactData.getter(ContactData::prePassStartTime)).setter(ContactData.setter(Builder::prePassStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prePassStartTime").build()}).build();
    private static final SdkField<Instant> POST_PASS_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("postPassEndTime").getter(ContactData.getter(ContactData::postPassEndTime)).setter(ContactData.setter(Builder::postPassEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postPassEndTime").build()}).build();
    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groundStation").getter(ContactData.getter(ContactData::groundStation)).setter(ContactData.setter(Builder::groundStation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()}).build();
    private static final SdkField<String> CONTACT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactStatus").getter(ContactData.getter(ContactData::contactStatusAsString)).setter(ContactData.setter(Builder::contactStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactStatus").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(ContactData.getter(ContactData::errorMessage)).setter(ContactData.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<Elevation> MAXIMUM_ELEVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maximumElevation").getter(ContactData.getter(ContactData::maximumElevation)).setter(ContactData.setter(Builder::maximumElevation)).constructor(Elevation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumElevation").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(ContactData.getter(ContactData::region)).setter(ContactData.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ContactData.getter(ContactData::tags)).setter(ContactData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> VISIBILITY_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("visibilityStartTime").getter(ContactData.getter(ContactData::visibilityStartTime)).setter(ContactData.setter(Builder::visibilityStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStartTime").build()}).build();
    private static final SdkField<Instant> VISIBILITY_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("visibilityEndTime").getter(ContactData.getter(ContactData::visibilityEndTime)).setter(ContactData.setter(Builder::visibilityEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityEndTime").build()}).build();
    private static final SdkField<EphemerisResponseData> EPHEMERIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ephemeris").getter(ContactData.getter(ContactData::ephemeris)).setter(ContactData.setter(Builder::ephemeris)).constructor(EphemerisResponseData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeris").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, MISSION_PROFILE_ARN_FIELD, SATELLITE_ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, PRE_PASS_START_TIME_FIELD, POST_PASS_END_TIME_FIELD, GROUND_STATION_FIELD, CONTACT_STATUS_FIELD, ERROR_MESSAGE_FIELD, MAXIMUM_ELEVATION_FIELD, REGION_FIELD, TAGS_FIELD, VISIBILITY_START_TIME_FIELD, VISIBILITY_END_TIME_FIELD, EPHEMERIS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final String missionProfileArn;
    private final String satelliteArn;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant prePassStartTime;
    private final Instant postPassEndTime;
    private final String groundStation;
    private final String contactStatus;
    private final String errorMessage;
    private final Elevation maximumElevation;
    private final String region;
    private final Map<String, String> tags;
    private final Instant visibilityStartTime;
    private final Instant visibilityEndTime;
    private final EphemerisResponseData ephemeris;

    private ContactData(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.missionProfileArn = builder.missionProfileArn;
        this.satelliteArn = builder.satelliteArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.prePassStartTime = builder.prePassStartTime;
        this.postPassEndTime = builder.postPassEndTime;
        this.groundStation = builder.groundStation;
        this.contactStatus = builder.contactStatus;
        this.errorMessage = builder.errorMessage;
        this.maximumElevation = builder.maximumElevation;
        this.region = builder.region;
        this.tags = builder.tags;
        this.visibilityStartTime = builder.visibilityStartTime;
        this.visibilityEndTime = builder.visibilityEndTime;
        this.ephemeris = builder.ephemeris;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String missionProfileArn() {
        return this.missionProfileArn;
    }

    public final String satelliteArn() {
        return this.satelliteArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant prePassStartTime() {
        return this.prePassStartTime;
    }

    public final Instant postPassEndTime() {
        return this.postPassEndTime;
    }

    public final String groundStation() {
        return this.groundStation;
    }

    public final ContactStatus contactStatus() {
        return ContactStatus.fromValue(this.contactStatus);
    }

    public final String contactStatusAsString() {
        return this.contactStatus;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Elevation maximumElevation() {
        return this.maximumElevation;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant visibilityStartTime() {
        return this.visibilityStartTime;
    }

    public final Instant visibilityEndTime() {
        return this.visibilityEndTime;
    }

    public final EphemerisResponseData ephemeris() {
        return this.ephemeris;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.prePassStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.postPassEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumElevation());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeris());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactData)) {
            return false;
        }
        ContactData other = (ContactData)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.prePassStartTime(), other.prePassStartTime()) && Objects.equals(this.postPassEndTime(), other.postPassEndTime()) && Objects.equals(this.groundStation(), other.groundStation()) && Objects.equals(this.contactStatusAsString(), other.contactStatusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.maximumElevation(), other.maximumElevation()) && Objects.equals(this.region(), other.region()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.visibilityStartTime(), other.visibilityStartTime()) && Objects.equals(this.visibilityEndTime(), other.visibilityEndTime()) && Objects.equals(this.ephemeris(), other.ephemeris());
    }

    public final String toString() {
        return ToString.builder((String)"ContactData").add("ContactId", (Object)this.contactId()).add("MissionProfileArn", (Object)this.missionProfileArn()).add("SatelliteArn", (Object)this.satelliteArn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("PrePassStartTime", (Object)this.prePassStartTime()).add("PostPassEndTime", (Object)this.postPassEndTime()).add("GroundStation", (Object)this.groundStation()).add("ContactStatus", (Object)this.contactStatusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("MaximumElevation", (Object)this.maximumElevation()).add("Region", (Object)this.region()).add("Tags", this.hasTags() ? this.tags() : null).add("VisibilityStartTime", (Object)this.visibilityStartTime()).add("VisibilityEndTime", (Object)this.visibilityEndTime()).add("Ephemeris", (Object)this.ephemeris()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "prePassStartTime": {
                return Optional.ofNullable(clazz.cast(this.prePassStartTime()));
            }
            case "postPassEndTime": {
                return Optional.ofNullable(clazz.cast(this.postPassEndTime()));
            }
            case "groundStation": {
                return Optional.ofNullable(clazz.cast(this.groundStation()));
            }
            case "contactStatus": {
                return Optional.ofNullable(clazz.cast(this.contactStatusAsString()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "maximumElevation": {
                return Optional.ofNullable(clazz.cast(this.maximumElevation()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "visibilityStartTime": {
                return Optional.ofNullable(clazz.cast(this.visibilityStartTime()));
            }
            case "visibilityEndTime": {
                return Optional.ofNullable(clazz.cast(this.visibilityEndTime()));
            }
            case "ephemeris": {
                return Optional.ofNullable(clazz.cast(this.ephemeris()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contactId", CONTACT_ID_FIELD);
        map.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
        map.put("satelliteArn", SATELLITE_ARN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("prePassStartTime", PRE_PASS_START_TIME_FIELD);
        map.put("postPassEndTime", POST_PASS_END_TIME_FIELD);
        map.put("groundStation", GROUND_STATION_FIELD);
        map.put("contactStatus", CONTACT_STATUS_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("maximumElevation", MAXIMUM_ELEVATION_FIELD);
        map.put("region", REGION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("visibilityStartTime", VISIBILITY_START_TIME_FIELD);
        map.put("visibilityEndTime", VISIBILITY_END_TIME_FIELD);
        map.put("ephemeris", EPHEMERIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactData, T> g) {
        return obj -> g.apply((ContactData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private String missionProfileArn;
        private String satelliteArn;
        private Instant startTime;
        private Instant endTime;
        private Instant prePassStartTime;
        private Instant postPassEndTime;
        private String groundStation;
        private String contactStatus;
        private String errorMessage;
        private Elevation maximumElevation;
        private String region;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant visibilityStartTime;
        private Instant visibilityEndTime;
        private EphemerisResponseData ephemeris;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactData model) {
            this.contactId(model.contactId);
            this.missionProfileArn(model.missionProfileArn);
            this.satelliteArn(model.satelliteArn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.prePassStartTime(model.prePassStartTime);
            this.postPassEndTime(model.postPassEndTime);
            this.groundStation(model.groundStation);
            this.contactStatus(model.contactStatus);
            this.errorMessage(model.errorMessage);
            this.maximumElevation(model.maximumElevation);
            this.region(model.region);
            this.tags(model.tags);
            this.visibilityStartTime(model.visibilityStartTime);
            this.visibilityEndTime(model.visibilityEndTime);
            this.ephemeris(model.ephemeris);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getPrePassStartTime() {
            return this.prePassStartTime;
        }

        public final void setPrePassStartTime(Instant prePassStartTime) {
            this.prePassStartTime = prePassStartTime;
        }

        @Override
        public final Builder prePassStartTime(Instant prePassStartTime) {
            this.prePassStartTime = prePassStartTime;
            return this;
        }

        public final Instant getPostPassEndTime() {
            return this.postPassEndTime;
        }

        public final void setPostPassEndTime(Instant postPassEndTime) {
            this.postPassEndTime = postPassEndTime;
        }

        @Override
        public final Builder postPassEndTime(Instant postPassEndTime) {
            this.postPassEndTime = postPassEndTime;
            return this;
        }

        public final String getGroundStation() {
            return this.groundStation;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final String getContactStatus() {
            return this.contactStatus;
        }

        public final void setContactStatus(String contactStatus) {
            this.contactStatus = contactStatus;
        }

        @Override
        public final Builder contactStatus(String contactStatus) {
            this.contactStatus = contactStatus;
            return this;
        }

        @Override
        public final Builder contactStatus(ContactStatus contactStatus) {
            this.contactStatus(contactStatus == null ? null : contactStatus.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Elevation.Builder getMaximumElevation() {
            return this.maximumElevation != null ? this.maximumElevation.toBuilder() : null;
        }

        public final void setMaximumElevation(Elevation.BuilderImpl maximumElevation) {
            this.maximumElevation = maximumElevation != null ? maximumElevation.build() : null;
        }

        @Override
        public final Builder maximumElevation(Elevation maximumElevation) {
            this.maximumElevation = maximumElevation;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Instant getVisibilityStartTime() {
            return this.visibilityStartTime;
        }

        public final void setVisibilityStartTime(Instant visibilityStartTime) {
            this.visibilityStartTime = visibilityStartTime;
        }

        @Override
        public final Builder visibilityStartTime(Instant visibilityStartTime) {
            this.visibilityStartTime = visibilityStartTime;
            return this;
        }

        public final Instant getVisibilityEndTime() {
            return this.visibilityEndTime;
        }

        public final void setVisibilityEndTime(Instant visibilityEndTime) {
            this.visibilityEndTime = visibilityEndTime;
        }

        @Override
        public final Builder visibilityEndTime(Instant visibilityEndTime) {
            this.visibilityEndTime = visibilityEndTime;
            return this;
        }

        public final EphemerisResponseData.Builder getEphemeris() {
            return this.ephemeris != null ? this.ephemeris.toBuilder() : null;
        }

        public final void setEphemeris(EphemerisResponseData.BuilderImpl ephemeris) {
            this.ephemeris = ephemeris != null ? ephemeris.build() : null;
        }

        @Override
        public final Builder ephemeris(EphemerisResponseData ephemeris) {
            this.ephemeris = ephemeris;
            return this;
        }

        public ContactData build() {
            return new ContactData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactData> {
        public Builder contactId(String var1);

        public Builder missionProfileArn(String var1);

        public Builder satelliteArn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder prePassStartTime(Instant var1);

        public Builder postPassEndTime(Instant var1);

        public Builder groundStation(String var1);

        public Builder contactStatus(String var1);

        public Builder contactStatus(ContactStatus var1);

        public Builder errorMessage(String var1);

        public Builder maximumElevation(Elevation var1);

        default public Builder maximumElevation(Consumer<Elevation.Builder> maximumElevation) {
            return this.maximumElevation((Elevation)((Elevation.Builder)Elevation.builder().applyMutation(maximumElevation)).build());
        }

        public Builder region(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder visibilityStartTime(Instant var1);

        public Builder visibilityEndTime(Instant var1);

        public Builder ephemeris(EphemerisResponseData var1);

        default public Builder ephemeris(Consumer<EphemerisResponseData.Builder> ephemeris) {
            return this.ephemeris((EphemerisResponseData)((EphemerisResponseData.Builder)EphemerisResponseData.builder().applyMutation(ephemeris)).build());
        }
    }
}

