/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.EphemerisErrorReason;
import software.amazon.awssdk.services.groundstation.model.EphemerisErrorReasonListCopier;
import software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason;
import software.amazon.awssdk.services.groundstation.model.EphemerisStatus;
import software.amazon.awssdk.services.groundstation.model.EphemerisTypeDescription;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEphemerisResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, DescribeEphemerisResponse> {
    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ephemerisId").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::ephemerisId)).setter(DescribeEphemerisResponse.setter(Builder::ephemerisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisId").build()}).build();
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteId").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::satelliteId)).setter(DescribeEphemerisResponse.setter(Builder::satelliteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::statusAsString)).setter(DescribeEphemerisResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::priority)).setter(DescribeEphemerisResponse.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::creationTime)).setter(DescribeEphemerisResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::enabled)).setter(DescribeEphemerisResponse.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::name)).setter(DescribeEphemerisResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::tags)).setter(DescribeEphemerisResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EphemerisTypeDescription> SUPPLIED_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("suppliedData").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::suppliedData)).setter(DescribeEphemerisResponse.setter(Builder::suppliedData)).constructor(EphemerisTypeDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppliedData").build()}).build();
    private static final SdkField<String> INVALID_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invalidReason").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::invalidReasonAsString)).setter(DescribeEphemerisResponse.setter(Builder::invalidReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidReason").build()}).build();
    private static final SdkField<List<EphemerisErrorReason>> ERROR_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorReasons").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::errorReasons)).setter(DescribeEphemerisResponse.setter(Builder::errorReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EphemerisErrorReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPHEMERIS_ID_FIELD, SATELLITE_ID_FIELD, STATUS_FIELD, PRIORITY_FIELD, CREATION_TIME_FIELD, ENABLED_FIELD, NAME_FIELD, TAGS_FIELD, SUPPLIED_DATA_FIELD, INVALID_REASON_FIELD, ERROR_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEphemerisResponse.memberNameToFieldInitializer();
    private final String ephemerisId;
    private final String satelliteId;
    private final String status;
    private final Integer priority;
    private final Instant creationTime;
    private final Boolean enabled;
    private final String name;
    private final Map<String, String> tags;
    private final EphemerisTypeDescription suppliedData;
    private final String invalidReason;
    private final List<EphemerisErrorReason> errorReasons;

    private DescribeEphemerisResponse(BuilderImpl builder) {
        super(builder);
        this.ephemerisId = builder.ephemerisId;
        this.satelliteId = builder.satelliteId;
        this.status = builder.status;
        this.priority = builder.priority;
        this.creationTime = builder.creationTime;
        this.enabled = builder.enabled;
        this.name = builder.name;
        this.tags = builder.tags;
        this.suppliedData = builder.suppliedData;
        this.invalidReason = builder.invalidReason;
        this.errorReasons = builder.errorReasons;
    }

    public final String ephemerisId() {
        return this.ephemerisId;
    }

    public final String satelliteId() {
        return this.satelliteId;
    }

    public final EphemerisStatus status() {
        return EphemerisStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final EphemerisTypeDescription suppliedData() {
        return this.suppliedData;
    }

    public final EphemerisInvalidReason invalidReason() {
        return EphemerisInvalidReason.fromValue(this.invalidReason);
    }

    public final String invalidReasonAsString() {
        return this.invalidReason;
    }

    public final boolean hasErrorReasons() {
        return this.errorReasons != null && !(this.errorReasons instanceof SdkAutoConstructList);
    }

    public final List<EphemerisErrorReason> errorReasons() {
        return this.errorReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.suppliedData());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorReasons() ? this.errorReasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEphemerisResponse)) {
            return false;
        }
        DescribeEphemerisResponse other = (DescribeEphemerisResponse)((Object)obj);
        return Objects.equals(this.ephemerisId(), other.ephemerisId()) && Objects.equals(this.satelliteId(), other.satelliteId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.suppliedData(), other.suppliedData()) && Objects.equals(this.invalidReasonAsString(), other.invalidReasonAsString()) && this.hasErrorReasons() == other.hasErrorReasons() && Objects.equals(this.errorReasons(), other.errorReasons());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEphemerisResponse").add("EphemerisId", (Object)this.ephemerisId()).add("SatelliteId", (Object)this.satelliteId()).add("Status", (Object)this.statusAsString()).add("Priority", (Object)this.priority()).add("CreationTime", (Object)this.creationTime()).add("Enabled", (Object)this.enabled()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).add("SuppliedData", (Object)this.suppliedData()).add("InvalidReason", (Object)this.invalidReasonAsString()).add("ErrorReasons", this.hasErrorReasons() ? this.errorReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ephemerisId": {
                return Optional.ofNullable(clazz.cast(this.ephemerisId()));
            }
            case "satelliteId": {
                return Optional.ofNullable(clazz.cast(this.satelliteId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "suppliedData": {
                return Optional.ofNullable(clazz.cast(this.suppliedData()));
            }
            case "invalidReason": {
                return Optional.ofNullable(clazz.cast(this.invalidReasonAsString()));
            }
            case "errorReasons": {
                return Optional.ofNullable(clazz.cast(this.errorReasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ephemerisId", EPHEMERIS_ID_FIELD);
        map.put("satelliteId", SATELLITE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("suppliedData", SUPPLIED_DATA_FIELD);
        map.put("invalidReason", INVALID_REASON_FIELD);
        map.put("errorReasons", ERROR_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEphemerisResponse, T> g) {
        return obj -> g.apply((DescribeEphemerisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String ephemerisId;
        private String satelliteId;
        private String status;
        private Integer priority;
        private Instant creationTime;
        private Boolean enabled;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private EphemerisTypeDescription suppliedData;
        private String invalidReason;
        private List<EphemerisErrorReason> errorReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEphemerisResponse model) {
            super(model);
            this.ephemerisId(model.ephemerisId);
            this.satelliteId(model.satelliteId);
            this.status(model.status);
            this.priority(model.priority);
            this.creationTime(model.creationTime);
            this.enabled(model.enabled);
            this.name(model.name);
            this.tags(model.tags);
            this.suppliedData(model.suppliedData);
            this.invalidReason(model.invalidReason);
            this.errorReasons(model.errorReasons);
        }

        public final String getEphemerisId() {
            return this.ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final String getSatelliteId() {
            return this.satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EphemerisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final EphemerisTypeDescription.Builder getSuppliedData() {
            return this.suppliedData != null ? this.suppliedData.toBuilder() : null;
        }

        public final void setSuppliedData(EphemerisTypeDescription.BuilderImpl suppliedData) {
            this.suppliedData = suppliedData != null ? suppliedData.build() : null;
        }

        @Override
        public final Builder suppliedData(EphemerisTypeDescription suppliedData) {
            this.suppliedData = suppliedData;
            return this;
        }

        public final String getInvalidReason() {
            return this.invalidReason;
        }

        public final void setInvalidReason(String invalidReason) {
            this.invalidReason = invalidReason;
        }

        @Override
        public final Builder invalidReason(String invalidReason) {
            this.invalidReason = invalidReason;
            return this;
        }

        @Override
        public final Builder invalidReason(EphemerisInvalidReason invalidReason) {
            this.invalidReason(invalidReason == null ? null : invalidReason.toString());
            return this;
        }

        public final List<EphemerisErrorReason.Builder> getErrorReasons() {
            List<EphemerisErrorReason.Builder> result = EphemerisErrorReasonListCopier.copyToBuilder(this.errorReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorReasons(Collection<EphemerisErrorReason.BuilderImpl> errorReasons) {
            this.errorReasons = EphemerisErrorReasonListCopier.copyFromBuilder(errorReasons);
        }

        @Override
        public final Builder errorReasons(Collection<EphemerisErrorReason> errorReasons) {
            this.errorReasons = EphemerisErrorReasonListCopier.copy(errorReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorReasons(EphemerisErrorReason ... errorReasons) {
            this.errorReasons(Arrays.asList(errorReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorReasons(Consumer<EphemerisErrorReason.Builder> ... errorReasons) {
            this.errorReasons(Stream.of(errorReasons).map(c -> (EphemerisErrorReason)((EphemerisErrorReason.Builder)EphemerisErrorReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEphemerisResponse build() {
            return new DescribeEphemerisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEphemerisResponse> {
        public Builder ephemerisId(String var1);

        public Builder satelliteId(String var1);

        public Builder status(String var1);

        public Builder status(EphemerisStatus var1);

        public Builder priority(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder suppliedData(EphemerisTypeDescription var1);

        default public Builder suppliedData(Consumer<EphemerisTypeDescription.Builder> suppliedData) {
            return this.suppliedData((EphemerisTypeDescription)((EphemerisTypeDescription.Builder)EphemerisTypeDescription.builder().applyMutation(suppliedData)).build());
        }

        public Builder invalidReason(String var1);

        public Builder invalidReason(EphemerisInvalidReason var1);

        public Builder errorReasons(Collection<EphemerisErrorReason> var1);

        public Builder errorReasons(EphemerisErrorReason ... var1);

        public Builder errorReasons(Consumer<EphemerisErrorReason.Builder> ... var1);
    }
}

