/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OEMEphemeris
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OEMEphemeris> {
    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Object").getter(OEMEphemeris.getter(OEMEphemeris::s3Object)).setter(OEMEphemeris.setter(Builder::s3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Object").build()}).build();
    private static final SdkField<String> OEM_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("oemData").getter(OEMEphemeris.getter(OEMEphemeris::oemData)).setter(OEMEphemeris.setter(Builder::oemData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oemData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OBJECT_FIELD, OEM_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OEMEphemeris.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Object s3Object;
    private final String oemData;

    private OEMEphemeris(BuilderImpl builder) {
        this.s3Object = builder.s3Object;
        this.oemData = builder.oemData;
    }

    public final S3Object s3Object() {
        return this.s3Object;
    }

    public final String oemData() {
        return this.oemData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.oemData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OEMEphemeris)) {
            return false;
        }
        OEMEphemeris other = (OEMEphemeris)obj;
        return Objects.equals(this.s3Object(), other.s3Object()) && Objects.equals(this.oemData(), other.oemData());
    }

    public final String toString() {
        return ToString.builder((String)"OEMEphemeris").add("S3Object", (Object)this.s3Object()).add("OemData", (Object)this.oemData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Object": {
                return Optional.ofNullable(clazz.cast(this.s3Object()));
            }
            case "oemData": {
                return Optional.ofNullable(clazz.cast(this.oemData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3Object", S3_OBJECT_FIELD);
        map.put("oemData", OEM_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OEMEphemeris, T> g) {
        return obj -> g.apply((OEMEphemeris)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Object s3Object;
        private String oemData;

        private BuilderImpl() {
        }

        private BuilderImpl(OEMEphemeris model) {
            this.s3Object(model.s3Object);
            this.oemData(model.oemData);
        }

        public final S3Object.Builder getS3Object() {
            return this.s3Object != null ? this.s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        public final String getOemData() {
            return this.oemData;
        }

        public final void setOemData(String oemData) {
            this.oemData = oemData;
        }

        @Override
        public final Builder oemData(String oemData) {
            this.oemData = oemData;
            return this;
        }

        public OEMEphemeris build() {
            return new OEMEphemeris(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OEMEphemeris> {
        public Builder s3Object(S3Object var1);

        default public Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return this.s3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(s3Object)).build());
        }

        public Builder oemData(String var1);
    }
}

