/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConfigurationResponse extends GuardDutyResponse implements
        ToCopyableBuilder<DescribeOrganizationConfigurationResponse.Builder, DescribeOrganizationConfigurationResponse> {
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnable").getter(getter(DescribeOrganizationConfigurationResponse::autoEnable))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()).build();

    private static final SdkField<Boolean> MEMBER_ACCOUNT_LIMIT_REACHED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("MemberAccountLimitReached")
            .getter(getter(DescribeOrganizationConfigurationResponse::memberAccountLimitReached))
            .setter(setter(Builder::memberAccountLimitReached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountLimitReached").build())
            .build();

    private static final SdkField<OrganizationDataSourceConfigurationsResult> DATA_SOURCES_FIELD = SdkField
            .<OrganizationDataSourceConfigurationsResult> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(DescribeOrganizationConfigurationResponse::dataSources)).setter(setter(Builder::dataSources))
            .constructor(OrganizationDataSourceConfigurationsResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_FIELD,
            MEMBER_ACCOUNT_LIMIT_REACHED_FIELD, DATA_SOURCES_FIELD));

    private final Boolean autoEnable;

    private final Boolean memberAccountLimitReached;

    private final OrganizationDataSourceConfigurationsResult dataSources;

    private DescribeOrganizationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnable = builder.autoEnable;
        this.memberAccountLimitReached = builder.memberAccountLimitReached;
        this.dataSources = builder.dataSources;
    }

    /**
     * <p>
     * Indicates whether GuardDuty is automatically enabled for accounts added to the organization.
     * </p>
     * 
     * @return Indicates whether GuardDuty is automatically enabled for accounts added to the organization.
     */
    public final Boolean autoEnable() {
        return autoEnable;
    }

    /**
     * <p>
     * Indicates whether the maximum number of allowed member accounts are already associated with the delegated
     * administrator account for your organization.
     * </p>
     * 
     * @return Indicates whether the maximum number of allowed member accounts are already associated with the delegated
     *         administrator account for your organization.
     */
    public final Boolean memberAccountLimitReached() {
        return memberAccountLimitReached;
    }

    /**
     * <p>
     * Describes which data sources are enabled automatically for member accounts.
     * </p>
     * 
     * @return Describes which data sources are enabled automatically for member accounts.
     */
    public final OrganizationDataSourceConfigurationsResult dataSources() {
        return dataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountLimitReached());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigurationResponse)) {
            return false;
        }
        DescribeOrganizationConfigurationResponse other = (DescribeOrganizationConfigurationResponse) obj;
        return Objects.equals(autoEnable(), other.autoEnable())
                && Objects.equals(memberAccountLimitReached(), other.memberAccountLimitReached())
                && Objects.equals(dataSources(), other.dataSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrganizationConfigurationResponse").add("AutoEnable", autoEnable())
                .add("MemberAccountLimitReached", memberAccountLimitReached()).add("DataSources", dataSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnable":
            return Optional.ofNullable(clazz.cast(autoEnable()));
        case "MemberAccountLimitReached":
            return Optional.ofNullable(clazz.cast(memberAccountLimitReached()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
        /**
         * <p>
         * Indicates whether GuardDuty is automatically enabled for accounts added to the organization.
         * </p>
         * 
         * @param autoEnable
         *        Indicates whether GuardDuty is automatically enabled for accounts added to the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnable(Boolean autoEnable);

        /**
         * <p>
         * Indicates whether the maximum number of allowed member accounts are already associated with the delegated
         * administrator account for your organization.
         * </p>
         * 
         * @param memberAccountLimitReached
         *        Indicates whether the maximum number of allowed member accounts are already associated with the
         *        delegated administrator account for your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountLimitReached(Boolean memberAccountLimitReached);

        /**
         * <p>
         * Describes which data sources are enabled automatically for member accounts.
         * </p>
         * 
         * @param dataSources
         *        Describes which data sources are enabled automatically for member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(OrganizationDataSourceConfigurationsResult dataSources);

        /**
         * <p>
         * Describes which data sources are enabled automatically for member accounts.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link OrganizationDataSourceConfigurationsResult.Builder} avoiding the need to create one manually via
         * {@link OrganizationDataSourceConfigurationsResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationDataSourceConfigurationsResult.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #dataSources(OrganizationDataSourceConfigurationsResult)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link OrganizationDataSourceConfigurationsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(OrganizationDataSourceConfigurationsResult)
         */
        default Builder dataSources(Consumer<OrganizationDataSourceConfigurationsResult.Builder> dataSources) {
            return dataSources(OrganizationDataSourceConfigurationsResult.builder().applyMutation(dataSources).build());
        }
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private Boolean autoEnable;

        private Boolean memberAccountLimitReached;

        private OrganizationDataSourceConfigurationsResult dataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigurationResponse model) {
            super(model);
            autoEnable(model.autoEnable);
            memberAccountLimitReached(model.memberAccountLimitReached);
            dataSources(model.dataSources);
        }

        public final Boolean getAutoEnable() {
            return autoEnable;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        @Transient
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final Boolean getMemberAccountLimitReached() {
            return memberAccountLimitReached;
        }

        public final void setMemberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
        }

        @Override
        @Transient
        public final Builder memberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
            return this;
        }

        public final OrganizationDataSourceConfigurationsResult.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        public final void setDataSources(OrganizationDataSourceConfigurationsResult.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Transient
        public final Builder dataSources(OrganizationDataSourceConfigurationsResult dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        @Override
        public DescribeOrganizationConfigurationResponse build() {
            return new DescribeOrganizationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
