/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class S3BucketDetailsCopier {
    static List<S3BucketDetail> copy(Collection<? extends S3BucketDetail> s3BucketDetailsParam) {
        List<S3BucketDetail> list;
        if (s3BucketDetailsParam == null || s3BucketDetailsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3BucketDetail> modifiableList = new ArrayList<>();
            s3BucketDetailsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3BucketDetail> copyFromBuilder(Collection<? extends S3BucketDetail.Builder> s3BucketDetailsParam) {
        List<S3BucketDetail> list;
        if (s3BucketDetailsParam == null || s3BucketDetailsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3BucketDetail> modifiableList = new ArrayList<>();
            s3BucketDetailsParam.forEach(entry -> {
                S3BucketDetail member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3BucketDetail.Builder> copyToBuilder(Collection<? extends S3BucketDetail> s3BucketDetailsParam) {
        List<S3BucketDetail.Builder> list;
        if (s3BucketDetailsParam == null || s3BucketDetailsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3BucketDetail.Builder> modifiableList = new ArrayList<>();
            s3BucketDetailsParam.forEach(entry -> {
                S3BucketDetail.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
