/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.AgentDetails;
import software.amazon.awssdk.services.guardduty.model.ManagementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageEc2InstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoverageEc2InstanceDetails> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CoverageEc2InstanceDetails.getter(CoverageEc2InstanceDetails::instanceId)).setter(CoverageEc2InstanceDetails.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CoverageEc2InstanceDetails.getter(CoverageEc2InstanceDetails::instanceType)).setter(CoverageEc2InstanceDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(CoverageEc2InstanceDetails.getter(CoverageEc2InstanceDetails::clusterArn)).setter(CoverageEc2InstanceDetails.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<AgentDetails> AGENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AgentDetails").getter(CoverageEc2InstanceDetails.getter(CoverageEc2InstanceDetails::agentDetails)).setter(CoverageEc2InstanceDetails.setter(Builder::agentDetails)).constructor(AgentDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentDetails").build()}).build();
    private static final SdkField<String> MANAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagementType").getter(CoverageEc2InstanceDetails.getter(CoverageEc2InstanceDetails::managementTypeAsString)).setter(CoverageEc2InstanceDetails.setter(Builder::managementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, CLUSTER_ARN_FIELD, AGENT_DETAILS_FIELD, MANAGEMENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoverageEc2InstanceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String instanceType;
    private final String clusterArn;
    private final AgentDetails agentDetails;
    private final String managementType;

    private CoverageEc2InstanceDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.clusterArn = builder.clusterArn;
        this.agentDetails = builder.agentDetails;
        this.managementType = builder.managementType;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final AgentDetails agentDetails() {
        return this.agentDetails;
    }

    public final ManagementType managementType() {
        return ManagementType.fromValue(this.managementType);
    }

    public final String managementTypeAsString() {
        return this.managementType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.managementTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageEc2InstanceDetails)) {
            return false;
        }
        CoverageEc2InstanceDetails other = (CoverageEc2InstanceDetails)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.agentDetails(), other.agentDetails()) && Objects.equals(this.managementTypeAsString(), other.managementTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CoverageEc2InstanceDetails").add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceType()).add("ClusterArn", (Object)this.clusterArn()).add("AgentDetails", (Object)this.agentDetails()).add("ManagementType", (Object)this.managementTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "AgentDetails": {
                return Optional.ofNullable(clazz.cast(this.agentDetails()));
            }
            case "ManagementType": {
                return Optional.ofNullable(clazz.cast(this.managementTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("agentDetails", AGENT_DETAILS_FIELD);
        map.put("managementType", MANAGEMENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoverageEc2InstanceDetails, T> g) {
        return obj -> g.apply((CoverageEc2InstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String instanceType;
        private String clusterArn;
        private AgentDetails agentDetails;
        private String managementType;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageEc2InstanceDetails model) {
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.clusterArn(model.clusterArn);
            this.agentDetails(model.agentDetails);
            this.managementType(model.managementType);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final AgentDetails.Builder getAgentDetails() {
            return this.agentDetails != null ? this.agentDetails.toBuilder() : null;
        }

        public final void setAgentDetails(AgentDetails.BuilderImpl agentDetails) {
            this.agentDetails = agentDetails != null ? agentDetails.build() : null;
        }

        @Override
        public final Builder agentDetails(AgentDetails agentDetails) {
            this.agentDetails = agentDetails;
            return this;
        }

        public final String getManagementType() {
            return this.managementType;
        }

        public final void setManagementType(String managementType) {
            this.managementType = managementType;
        }

        @Override
        public final Builder managementType(String managementType) {
            this.managementType = managementType;
            return this;
        }

        @Override
        public final Builder managementType(ManagementType managementType) {
            this.managementType(managementType == null ? null : managementType.toString());
            return this;
        }

        public CoverageEc2InstanceDetails build() {
            return new CoverageEc2InstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoverageEc2InstanceDetails> {
        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder clusterArn(String var1);

        public Builder agentDetails(AgentDetails var1);

        default public Builder agentDetails(Consumer<AgentDetails.Builder> agentDetails) {
            return this.agentDetails((AgentDetails)((AgentDetails.Builder)AgentDetails.builder().applyMutation(agentDetails)).build());
        }

        public Builder managementType(String var1);

        public Builder managementType(ManagementType var1);
    }
}

