/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActorProcess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActorProcess> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ActorProcess.getter(ActorProcess::name)).setter(ActorProcess.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(ActorProcess.getter(ActorProcess::path)).setter(ActorProcess.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sha256").getter(ActorProcess.getter(ActorProcess::sha256)).setter(ActorProcess.setter(Builder::sha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha256").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATH_FIELD, SHA256_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActorProcess.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String path;
    private final String sha256;

    private ActorProcess(BuilderImpl builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.sha256 = builder.sha256;
    }

    public final String name() {
        return this.name;
    }

    public final String path() {
        return this.path;
    }

    public final String sha256() {
        return this.sha256;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActorProcess)) {
            return false;
        }
        ActorProcess other = (ActorProcess)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.sha256(), other.sha256());
    }

    public final String toString() {
        return ToString.builder((String)"ActorProcess").add("Name", (Object)this.name()).add("Path", (Object)this.path()).add("Sha256", (Object)this.sha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Sha256": {
                return Optional.ofNullable(clazz.cast(this.sha256()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("name", NAME_FIELD);
        map.put("path", PATH_FIELD);
        map.put("sha256", SHA256_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActorProcess, T> g) {
        return obj -> g.apply((ActorProcess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String path;
        private String sha256;

        private BuilderImpl() {
        }

        private BuilderImpl(ActorProcess model) {
            this.name(model.name);
            this.path(model.path);
            this.sha256(model.sha256);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getSha256() {
            return this.sha256;
        }

        public final void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        @Override
        public final Builder sha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        public ActorProcess build() {
            return new ActorProcess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActorProcess> {
        public Builder name(String var1);

        public Builder path(String var1);

        public Builder sha256(String var1);
    }
}

