/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerFindingResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerFindingResource> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Image").getter(ContainerFindingResource.getter(ContainerFindingResource::image)).setter(ContainerFindingResource.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> IMAGE_UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUid").getter(ContainerFindingResource.getter(ContainerFindingResource::imageUid)).setter(ContainerFindingResource.setter(Builder::imageUid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, IMAGE_UID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerFindingResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String image;
    private final String imageUid;

    private ContainerFindingResource(BuilderImpl builder) {
        this.image = builder.image;
        this.imageUid = builder.imageUid;
    }

    public final String image() {
        return this.image;
    }

    public final String imageUid() {
        return this.imageUid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerFindingResource)) {
            return false;
        }
        ContainerFindingResource other = (ContainerFindingResource)obj;
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.imageUid(), other.imageUid());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerFindingResource").add("Image", (Object)this.image()).add("ImageUid", (Object)this.imageUid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "ImageUid": {
                return Optional.ofNullable(clazz.cast(this.imageUid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("image", IMAGE_FIELD);
        map.put("imageUid", IMAGE_UID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerFindingResource, T> g) {
        return obj -> g.apply((ContainerFindingResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String image;
        private String imageUid;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerFindingResource model) {
            this.image(model.image);
            this.imageUid(model.imageUid);
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getImageUid() {
            return this.imageUid;
        }

        public final void setImageUid(String imageUid) {
            this.imageUid = imageUid;
        }

        @Override
        public final Builder imageUid(String imageUid) {
            this.imageUid = imageUid;
            return this;
        }

        public ContainerFindingResource build() {
            return new ContainerFindingResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerFindingResource> {
        public Builder image(String var1);

        public Builder imageUid(String var1);
    }
}

