/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EcsClusterStatus {
    ACTIVE("ACTIVE"),
    PROVISIONING("PROVISIONING"),
    DEPROVISIONING("DEPROVISIONING"),
    FAILED("FAILED"),
    INACTIVE("INACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EcsClusterStatus> VALUE_MAP;
    private final String value;

    private EcsClusterStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EcsClusterStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EcsClusterStatus> knownValues() {
        EnumSet<EcsClusterStatus> knownValues = EnumSet.allOf(EcsClusterStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EcsClusterStatus.class, EcsClusterStatus::toString);
    }
}

