/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionResourceType;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionScanStatus;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionScanType;
import software.amazon.awssdk.services.guardduty.model.ScanResultStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MalwareScan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MalwareScan> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(MalwareScan.getter(MalwareScan::resourceArn)).setter(MalwareScan.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(MalwareScan.getter(MalwareScan::resourceTypeAsString)).setter(MalwareScan.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanId").getter(MalwareScan.getter(MalwareScan::scanId)).setter(MalwareScan.setter(Builder::scanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanId").build()}).build();
    private static final SdkField<String> SCAN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanStatus").getter(MalwareScan.getter(MalwareScan::scanStatusAsString)).setter(MalwareScan.setter(Builder::scanStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatus").build()}).build();
    private static final SdkField<String> SCAN_RESULT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanResultStatus").getter(MalwareScan.getter(MalwareScan::scanResultStatusAsString)).setter(MalwareScan.setter(Builder::scanResultStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResultStatus").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(MalwareScan.getter(MalwareScan::scanTypeAsString)).setter(MalwareScan.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final SdkField<Instant> SCAN_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScanStartedAt").getter(MalwareScan.getter(MalwareScan::scanStartedAt)).setter(MalwareScan.setter(Builder::scanStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStartedAt").build()}).build();
    private static final SdkField<Instant> SCAN_COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScanCompletedAt").getter(MalwareScan.getter(MalwareScan::scanCompletedAt)).setter(MalwareScan.setter(Builder::scanCompletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanCompletedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, SCAN_ID_FIELD, SCAN_STATUS_FIELD, SCAN_RESULT_STATUS_FIELD, SCAN_TYPE_FIELD, SCAN_STARTED_AT_FIELD, SCAN_COMPLETED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MalwareScan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String resourceType;
    private final String scanId;
    private final String scanStatus;
    private final String scanResultStatus;
    private final String scanType;
    private final Instant scanStartedAt;
    private final Instant scanCompletedAt;

    private MalwareScan(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.scanId = builder.scanId;
        this.scanStatus = builder.scanStatus;
        this.scanResultStatus = builder.scanResultStatus;
        this.scanType = builder.scanType;
        this.scanStartedAt = builder.scanStartedAt;
        this.scanCompletedAt = builder.scanCompletedAt;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final MalwareProtectionResourceType resourceType() {
        return MalwareProtectionResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String scanId() {
        return this.scanId;
    }

    public final MalwareProtectionScanStatus scanStatus() {
        return MalwareProtectionScanStatus.fromValue(this.scanStatus);
    }

    public final String scanStatusAsString() {
        return this.scanStatus;
    }

    public final ScanResultStatus scanResultStatus() {
        return ScanResultStatus.fromValue(this.scanResultStatus);
    }

    public final String scanResultStatusAsString() {
        return this.scanResultStatus;
    }

    public final MalwareProtectionScanType scanType() {
        return MalwareProtectionScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public final Instant scanStartedAt() {
        return this.scanStartedAt;
    }

    public final Instant scanCompletedAt() {
        return this.scanCompletedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanResultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanCompletedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalwareScan)) {
            return false;
        }
        MalwareScan other = (MalwareScan)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.scanId(), other.scanId()) && Objects.equals(this.scanStatusAsString(), other.scanStatusAsString()) && Objects.equals(this.scanResultStatusAsString(), other.scanResultStatusAsString()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(this.scanStartedAt(), other.scanStartedAt()) && Objects.equals(this.scanCompletedAt(), other.scanCompletedAt());
    }

    public final String toString() {
        return ToString.builder((String)"MalwareScan").add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ScanId", (Object)this.scanId()).add("ScanStatus", (Object)this.scanStatusAsString()).add("ScanResultStatus", (Object)this.scanResultStatusAsString()).add("ScanType", (Object)this.scanTypeAsString()).add("ScanStartedAt", (Object)this.scanStartedAt()).add("ScanCompletedAt", (Object)this.scanCompletedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ScanId": {
                return Optional.ofNullable(clazz.cast(this.scanId()));
            }
            case "ScanStatus": {
                return Optional.ofNullable(clazz.cast(this.scanStatusAsString()));
            }
            case "ScanResultStatus": {
                return Optional.ofNullable(clazz.cast(this.scanResultStatusAsString()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
            case "ScanStartedAt": {
                return Optional.ofNullable(clazz.cast(this.scanStartedAt()));
            }
            case "ScanCompletedAt": {
                return Optional.ofNullable(clazz.cast(this.scanCompletedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("scanId", SCAN_ID_FIELD);
        map.put("scanStatus", SCAN_STATUS_FIELD);
        map.put("scanResultStatus", SCAN_RESULT_STATUS_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        map.put("scanStartedAt", SCAN_STARTED_AT_FIELD);
        map.put("scanCompletedAt", SCAN_COMPLETED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MalwareScan, T> g) {
        return obj -> g.apply((MalwareScan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String resourceType;
        private String scanId;
        private String scanStatus;
        private String scanResultStatus;
        private String scanType;
        private Instant scanStartedAt;
        private Instant scanCompletedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(MalwareScan model) {
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.scanId(model.scanId);
            this.scanStatus(model.scanStatus);
            this.scanResultStatus(model.scanResultStatus);
            this.scanType(model.scanType);
            this.scanStartedAt(model.scanStartedAt);
            this.scanCompletedAt(model.scanCompletedAt);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MalwareProtectionResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getScanId() {
            return this.scanId;
        }

        public final void setScanId(String scanId) {
            this.scanId = scanId;
        }

        @Override
        public final Builder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public final String getScanStatus() {
            return this.scanStatus;
        }

        public final void setScanStatus(String scanStatus) {
            this.scanStatus = scanStatus;
        }

        @Override
        public final Builder scanStatus(String scanStatus) {
            this.scanStatus = scanStatus;
            return this;
        }

        @Override
        public final Builder scanStatus(MalwareProtectionScanStatus scanStatus) {
            this.scanStatus(scanStatus == null ? null : scanStatus.toString());
            return this;
        }

        public final String getScanResultStatus() {
            return this.scanResultStatus;
        }

        public final void setScanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
        }

        @Override
        public final Builder scanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
            return this;
        }

        @Override
        public final Builder scanResultStatus(ScanResultStatus scanResultStatus) {
            this.scanResultStatus(scanResultStatus == null ? null : scanResultStatus.toString());
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(MalwareProtectionScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final Instant getScanStartedAt() {
            return this.scanStartedAt;
        }

        public final void setScanStartedAt(Instant scanStartedAt) {
            this.scanStartedAt = scanStartedAt;
        }

        @Override
        public final Builder scanStartedAt(Instant scanStartedAt) {
            this.scanStartedAt = scanStartedAt;
            return this;
        }

        public final Instant getScanCompletedAt() {
            return this.scanCompletedAt;
        }

        public final void setScanCompletedAt(Instant scanCompletedAt) {
            this.scanCompletedAt = scanCompletedAt;
        }

        @Override
        public final Builder scanCompletedAt(Instant scanCompletedAt) {
            this.scanCompletedAt = scanCompletedAt;
            return this;
        }

        public MalwareScan build() {
            return new MalwareScan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MalwareScan> {
        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(MalwareProtectionResourceType var1);

        public Builder scanId(String var1);

        public Builder scanStatus(String var1);

        public Builder scanStatus(MalwareProtectionScanStatus var1);

        public Builder scanResultStatus(String var1);

        public Builder scanResultStatus(ScanResultStatus var1);

        public Builder scanType(String var1);

        public Builder scanType(MalwareProtectionScanType var1);

        public Builder scanStartedAt(Instant var1);

        public Builder scanCompletedAt(Instant var1);
    }
}

