/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanCategory {
    FULL_SCAN("FULL_SCAN"),
    INCREMENTAL_SCAN("INCREMENTAL_SCAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanCategory> VALUE_MAP;
    private final String value;

    private ScanCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanCategory> knownValues() {
        EnumSet<ScanCategory> knownValues = EnumSet.allOf(ScanCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanCategory.class, ScanCategory::toString);
    }
}

