/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.Actor;
import software.amazon.awssdk.services.guardduty.model.ActorsCopier;
import software.amazon.awssdk.services.guardduty.model.AdditionalSequenceTypesCopier;
import software.amazon.awssdk.services.guardduty.model.Indicator;
import software.amazon.awssdk.services.guardduty.model.IndicatorsCopier;
import software.amazon.awssdk.services.guardduty.model.NetworkEndpoint;
import software.amazon.awssdk.services.guardduty.model.NetworkEndpointsCopier;
import software.amazon.awssdk.services.guardduty.model.ResourceV2;
import software.amazon.awssdk.services.guardduty.model.ResourcesCopier;
import software.amazon.awssdk.services.guardduty.model.Signal;
import software.amazon.awssdk.services.guardduty.model.SignalsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Sequence
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Sequence> {
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(Sequence.getter(Sequence::uid)).setter(Sequence.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Sequence.getter(Sequence::description)).setter(Sequence.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Actor>> ACTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actors").getter(Sequence.getter(Sequence::actors)).setter(Sequence.setter(Builder::actors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Actor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceV2>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(Sequence.getter(Sequence::resources)).setter(Sequence.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NetworkEndpoint>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(Sequence.getter(Sequence::endpoints)).setter(Sequence.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Signal>> SIGNALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Signals").getter(Sequence.getter(Sequence::signals)).setter(Sequence.setter(Builder::signals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Signal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Indicator>> SEQUENCE_INDICATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SequenceIndicators").getter(Sequence.getter(Sequence::sequenceIndicators)).setter(Sequence.setter(Builder::sequenceIndicators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceIndicators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Indicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_SEQUENCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalSequenceTypes").getter(Sequence.getter(Sequence::additionalSequenceTypes)).setter(Sequence.setter(Builder::additionalSequenceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalSequenceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, DESCRIPTION_FIELD, ACTORS_FIELD, RESOURCES_FIELD, ENDPOINTS_FIELD, SIGNALS_FIELD, SEQUENCE_INDICATORS_FIELD, ADDITIONAL_SEQUENCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Sequence.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String uid;
    private final String description;
    private final List<Actor> actors;
    private final List<ResourceV2> resources;
    private final List<NetworkEndpoint> endpoints;
    private final List<Signal> signals;
    private final List<Indicator> sequenceIndicators;
    private final List<String> additionalSequenceTypes;

    private Sequence(BuilderImpl builder) {
        this.uid = builder.uid;
        this.description = builder.description;
        this.actors = builder.actors;
        this.resources = builder.resources;
        this.endpoints = builder.endpoints;
        this.signals = builder.signals;
        this.sequenceIndicators = builder.sequenceIndicators;
        this.additionalSequenceTypes = builder.additionalSequenceTypes;
    }

    public final String uid() {
        return this.uid;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasActors() {
        return this.actors != null && !(this.actors instanceof SdkAutoConstructList);
    }

    public final List<Actor> actors() {
        return this.actors;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<ResourceV2> resources() {
        return this.resources;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<NetworkEndpoint> endpoints() {
        return this.endpoints;
    }

    public final boolean hasSignals() {
        return this.signals != null && !(this.signals instanceof SdkAutoConstructList);
    }

    public final List<Signal> signals() {
        return this.signals;
    }

    public final boolean hasSequenceIndicators() {
        return this.sequenceIndicators != null && !(this.sequenceIndicators instanceof SdkAutoConstructList);
    }

    public final List<Indicator> sequenceIndicators() {
        return this.sequenceIndicators;
    }

    public final boolean hasAdditionalSequenceTypes() {
        return this.additionalSequenceTypes != null && !(this.additionalSequenceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> additionalSequenceTypes() {
        return this.additionalSequenceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActors() ? this.actors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignals() ? this.signals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSequenceIndicators() ? this.sequenceIndicators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalSequenceTypes() ? this.additionalSequenceTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)obj;
        return Objects.equals(this.uid(), other.uid()) && Objects.equals(this.description(), other.description()) && this.hasActors() == other.hasActors() && Objects.equals(this.actors(), other.actors()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && this.hasSignals() == other.hasSignals() && Objects.equals(this.signals(), other.signals()) && this.hasSequenceIndicators() == other.hasSequenceIndicators() && Objects.equals(this.sequenceIndicators(), other.sequenceIndicators()) && this.hasAdditionalSequenceTypes() == other.hasAdditionalSequenceTypes() && Objects.equals(this.additionalSequenceTypes(), other.additionalSequenceTypes());
    }

    public final String toString() {
        return ToString.builder((String)"Sequence").add("Uid", (Object)this.uid()).add("Description", (Object)this.description()).add("Actors", this.hasActors() ? this.actors() : null).add("Resources", this.hasResources() ? this.resources() : null).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("Signals", this.hasSignals() ? this.signals() : null).add("SequenceIndicators", this.hasSequenceIndicators() ? this.sequenceIndicators() : null).add("AdditionalSequenceTypes", this.hasAdditionalSequenceTypes() ? this.additionalSequenceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Actors": {
                return Optional.ofNullable(clazz.cast(this.actors()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "Signals": {
                return Optional.ofNullable(clazz.cast(this.signals()));
            }
            case "SequenceIndicators": {
                return Optional.ofNullable(clazz.cast(this.sequenceIndicators()));
            }
            case "AdditionalSequenceTypes": {
                return Optional.ofNullable(clazz.cast(this.additionalSequenceTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uid", UID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("actors", ACTORS_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        map.put("signals", SIGNALS_FIELD);
        map.put("sequenceIndicators", SEQUENCE_INDICATORS_FIELD);
        map.put("additionalSequenceTypes", ADDITIONAL_SEQUENCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sequence, T> g) {
        return obj -> g.apply((Sequence)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uid;
        private String description;
        private List<Actor> actors = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceV2> resources = DefaultSdkAutoConstructList.getInstance();
        private List<NetworkEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();
        private List<Signal> signals = DefaultSdkAutoConstructList.getInstance();
        private List<Indicator> sequenceIndicators = DefaultSdkAutoConstructList.getInstance();
        private List<String> additionalSequenceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Sequence model) {
            this.uid(model.uid);
            this.description(model.description);
            this.actors(model.actors);
            this.resources(model.resources);
            this.endpoints(model.endpoints);
            this.signals(model.signals);
            this.sequenceIndicators(model.sequenceIndicators);
            this.additionalSequenceTypes(model.additionalSequenceTypes);
        }

        public final String getUid() {
            return this.uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Actor.Builder> getActors() {
            List<Actor.Builder> result = ActorsCopier.copyToBuilder(this.actors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActors(Collection<Actor.BuilderImpl> actors) {
            this.actors = ActorsCopier.copyFromBuilder(actors);
        }

        @Override
        public final Builder actors(Collection<Actor> actors) {
            this.actors = ActorsCopier.copy(actors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actors(Actor ... actors) {
            this.actors(Arrays.asList(actors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actors(Consumer<Actor.Builder> ... actors) {
            this.actors(Stream.of(actors).map(c -> (Actor)((Actor.Builder)Actor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceV2.Builder> getResources() {
            List<ResourceV2.Builder> result = ResourcesCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourceV2.BuilderImpl> resources) {
            this.resources = ResourcesCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ResourceV2> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ResourceV2 ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ResourceV2.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (ResourceV2)((ResourceV2.Builder)ResourceV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NetworkEndpoint.Builder> getEndpoints() {
            List<NetworkEndpoint.Builder> result = NetworkEndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<NetworkEndpoint.BuilderImpl> endpoints) {
            this.endpoints = NetworkEndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<NetworkEndpoint> endpoints) {
            this.endpoints = NetworkEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(NetworkEndpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<NetworkEndpoint.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (NetworkEndpoint)((NetworkEndpoint.Builder)NetworkEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Signal.Builder> getSignals() {
            List<Signal.Builder> result = SignalsCopier.copyToBuilder(this.signals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignals(Collection<Signal.BuilderImpl> signals) {
            this.signals = SignalsCopier.copyFromBuilder(signals);
        }

        @Override
        public final Builder signals(Collection<Signal> signals) {
            this.signals = SignalsCopier.copy(signals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signals(Signal ... signals) {
            this.signals(Arrays.asList(signals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signals(Consumer<Signal.Builder> ... signals) {
            this.signals(Stream.of(signals).map(c -> (Signal)((Signal.Builder)Signal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Indicator.Builder> getSequenceIndicators() {
            List<Indicator.Builder> result = IndicatorsCopier.copyToBuilder(this.sequenceIndicators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSequenceIndicators(Collection<Indicator.BuilderImpl> sequenceIndicators) {
            this.sequenceIndicators = IndicatorsCopier.copyFromBuilder(sequenceIndicators);
        }

        @Override
        public final Builder sequenceIndicators(Collection<Indicator> sequenceIndicators) {
            this.sequenceIndicators = IndicatorsCopier.copy(sequenceIndicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sequenceIndicators(Indicator ... sequenceIndicators) {
            this.sequenceIndicators(Arrays.asList(sequenceIndicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sequenceIndicators(Consumer<Indicator.Builder> ... sequenceIndicators) {
            this.sequenceIndicators(Stream.of(sequenceIndicators).map(c -> (Indicator)((Indicator.Builder)Indicator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAdditionalSequenceTypes() {
            if (this.additionalSequenceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalSequenceTypes;
        }

        public final void setAdditionalSequenceTypes(Collection<String> additionalSequenceTypes) {
            this.additionalSequenceTypes = AdditionalSequenceTypesCopier.copy(additionalSequenceTypes);
        }

        @Override
        public final Builder additionalSequenceTypes(Collection<String> additionalSequenceTypes) {
            this.additionalSequenceTypes = AdditionalSequenceTypesCopier.copy(additionalSequenceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSequenceTypes(String ... additionalSequenceTypes) {
            this.additionalSequenceTypes(Arrays.asList(additionalSequenceTypes));
            return this;
        }

        public Sequence build() {
            return new Sequence(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Sequence> {
        public Builder uid(String var1);

        public Builder description(String var1);

        public Builder actors(Collection<Actor> var1);

        public Builder actors(Actor ... var1);

        public Builder actors(Consumer<Actor.Builder> ... var1);

        public Builder resources(Collection<ResourceV2> var1);

        public Builder resources(ResourceV2 ... var1);

        public Builder resources(Consumer<ResourceV2.Builder> ... var1);

        public Builder endpoints(Collection<NetworkEndpoint> var1);

        public Builder endpoints(NetworkEndpoint ... var1);

        public Builder endpoints(Consumer<NetworkEndpoint.Builder> ... var1);

        public Builder signals(Collection<Signal> var1);

        public Builder signals(Signal ... var1);

        public Builder signals(Consumer<Signal.Builder> ... var1);

        public Builder sequenceIndicators(Collection<Indicator> var1);

        public Builder sequenceIndicators(Indicator ... var1);

        public Builder sequenceIndicators(Consumer<Indicator.Builder> ... var1);

        public Builder additionalSequenceTypes(Collection<String> var1);

        public Builder additionalSequenceTypes(String ... var1);
    }
}

