/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.IncrementalScanDetails;
import software.amazon.awssdk.services.guardduty.model.RecoveryPoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMalwareScanConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StartMalwareScanConfiguration> {
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(StartMalwareScanConfiguration.getter(StartMalwareScanConfiguration::role)).setter(StartMalwareScanConfiguration.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<IncrementalScanDetails> INCREMENTAL_SCAN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IncrementalScanDetails").getter(StartMalwareScanConfiguration.getter(StartMalwareScanConfiguration::incrementalScanDetails)).setter(StartMalwareScanConfiguration.setter(Builder::incrementalScanDetails)).constructor(IncrementalScanDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalScanDetails").build()}).build();
    private static final SdkField<RecoveryPoint> RECOVERY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecoveryPoint").getter(StartMalwareScanConfiguration.getter(StartMalwareScanConfiguration::recoveryPoint)).setter(StartMalwareScanConfiguration.setter(Builder::recoveryPoint)).constructor(RecoveryPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_FIELD, INCREMENTAL_SCAN_DETAILS_FIELD, RECOVERY_POINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMalwareScanConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String role;
    private final IncrementalScanDetails incrementalScanDetails;
    private final RecoveryPoint recoveryPoint;

    private StartMalwareScanConfiguration(BuilderImpl builder) {
        this.role = builder.role;
        this.incrementalScanDetails = builder.incrementalScanDetails;
        this.recoveryPoint = builder.recoveryPoint;
    }

    public final String role() {
        return this.role;
    }

    public final IncrementalScanDetails incrementalScanDetails() {
        return this.incrementalScanDetails;
    }

    public final RecoveryPoint recoveryPoint() {
        return this.recoveryPoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.incrementalScanDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMalwareScanConfiguration)) {
            return false;
        }
        StartMalwareScanConfiguration other = (StartMalwareScanConfiguration)obj;
        return Objects.equals(this.role(), other.role()) && Objects.equals(this.incrementalScanDetails(), other.incrementalScanDetails()) && Objects.equals(this.recoveryPoint(), other.recoveryPoint());
    }

    public final String toString() {
        return ToString.builder((String)"StartMalwareScanConfiguration").add("Role", (Object)this.role()).add("IncrementalScanDetails", (Object)this.incrementalScanDetails()).add("RecoveryPoint", (Object)this.recoveryPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "IncrementalScanDetails": {
                return Optional.ofNullable(clazz.cast(this.incrementalScanDetails()));
            }
            case "RecoveryPoint": {
                return Optional.ofNullable(clazz.cast(this.recoveryPoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("role", ROLE_FIELD);
        map.put("incrementalScanDetails", INCREMENTAL_SCAN_DETAILS_FIELD);
        map.put("recoveryPoint", RECOVERY_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMalwareScanConfiguration, T> g) {
        return obj -> g.apply((StartMalwareScanConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String role;
        private IncrementalScanDetails incrementalScanDetails;
        private RecoveryPoint recoveryPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMalwareScanConfiguration model) {
            this.role(model.role);
            this.incrementalScanDetails(model.incrementalScanDetails);
            this.recoveryPoint(model.recoveryPoint);
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final IncrementalScanDetails.Builder getIncrementalScanDetails() {
            return this.incrementalScanDetails != null ? this.incrementalScanDetails.toBuilder() : null;
        }

        public final void setIncrementalScanDetails(IncrementalScanDetails.BuilderImpl incrementalScanDetails) {
            this.incrementalScanDetails = incrementalScanDetails != null ? incrementalScanDetails.build() : null;
        }

        @Override
        public final Builder incrementalScanDetails(IncrementalScanDetails incrementalScanDetails) {
            this.incrementalScanDetails = incrementalScanDetails;
            return this;
        }

        public final RecoveryPoint.Builder getRecoveryPoint() {
            return this.recoveryPoint != null ? this.recoveryPoint.toBuilder() : null;
        }

        public final void setRecoveryPoint(RecoveryPoint.BuilderImpl recoveryPoint) {
            this.recoveryPoint = recoveryPoint != null ? recoveryPoint.build() : null;
        }

        @Override
        public final Builder recoveryPoint(RecoveryPoint recoveryPoint) {
            this.recoveryPoint = recoveryPoint;
            return this;
        }

        public StartMalwareScanConfiguration build() {
            return new StartMalwareScanConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StartMalwareScanConfiguration> {
        public Builder role(String var1);

        public Builder incrementalScanDetails(IncrementalScanDetails var1);

        default public Builder incrementalScanDetails(Consumer<IncrementalScanDetails.Builder> incrementalScanDetails) {
            return this.incrementalScanDetails((IncrementalScanDetails)((IncrementalScanDetails.Builder)IncrementalScanDetails.builder().applyMutation(incrementalScanDetails)).build());
        }

        public Builder recoveryPoint(RecoveryPoint var1);

        default public Builder recoveryPoint(Consumer<RecoveryPoint.Builder> recoveryPoint) {
            return this.recoveryPoint((RecoveryPoint)((RecoveryPoint.Builder)RecoveryPoint.builder().applyMutation(recoveryPoint)).build());
        }
    }
}

