/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.AdditionalInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemDetails> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ItemDetails.getter(ItemDetails::resourceArn)).setter(ItemDetails.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> ITEM_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ItemPath").getter(ItemDetails.getter(ItemDetails::itemPath)).setter(ItemDetails.setter(Builder::itemPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemPath").build()}).build();
    private static final SdkField<String> HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hash").getter(ItemDetails.getter(ItemDetails::hash)).setter(ItemDetails.setter(Builder::hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hash").build()}).build();
    private static final SdkField<AdditionalInfo> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalInfo").getter(ItemDetails.getter(ItemDetails::additionalInfo)).setter(ItemDetails.setter(Builder::additionalInfo)).constructor(AdditionalInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, ITEM_PATH_FIELD, HASH_FIELD, ADDITIONAL_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ItemDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String itemPath;
    private final String hash;
    private final AdditionalInfo additionalInfo;

    private ItemDetails(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.itemPath = builder.itemPath;
        this.hash = builder.hash;
        this.additionalInfo = builder.additionalInfo;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String itemPath() {
        return this.itemPath;
    }

    public final String hash() {
        return this.hash;
    }

    public final AdditionalInfo additionalInfo() {
        return this.additionalInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemDetails)) {
            return false;
        }
        ItemDetails other = (ItemDetails)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.itemPath(), other.itemPath()) && Objects.equals(this.hash(), other.hash()) && Objects.equals(this.additionalInfo(), other.additionalInfo());
    }

    public final String toString() {
        return ToString.builder((String)"ItemDetails").add("ResourceArn", (Object)this.resourceArn()).add("ItemPath", (Object)this.itemPath()).add("Hash", (Object)this.hash()).add("AdditionalInfo", (Object)this.additionalInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ItemPath": {
                return Optional.ofNullable(clazz.cast(this.itemPath()));
            }
            case "Hash": {
                return Optional.ofNullable(clazz.cast(this.hash()));
            }
            case "AdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("itemPath", ITEM_PATH_FIELD);
        map.put("hash", HASH_FIELD);
        map.put("additionalInfo", ADDITIONAL_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemDetails, T> g) {
        return obj -> g.apply((ItemDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String itemPath;
        private String hash;
        private AdditionalInfo additionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemDetails model) {
            this.resourceArn(model.resourceArn);
            this.itemPath(model.itemPath);
            this.hash(model.hash);
            this.additionalInfo(model.additionalInfo);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getItemPath() {
            return this.itemPath;
        }

        public final void setItemPath(String itemPath) {
            this.itemPath = itemPath;
        }

        @Override
        public final Builder itemPath(String itemPath) {
            this.itemPath = itemPath;
            return this;
        }

        public final String getHash() {
            return this.hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final AdditionalInfo.Builder getAdditionalInfo() {
            return this.additionalInfo != null ? this.additionalInfo.toBuilder() : null;
        }

        public final void setAdditionalInfo(AdditionalInfo.BuilderImpl additionalInfo) {
            this.additionalInfo = additionalInfo != null ? additionalInfo.build() : null;
        }

        @Override
        public final Builder additionalInfo(AdditionalInfo additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public ItemDetails build() {
            return new ItemDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemDetails> {
        public Builder resourceArn(String var1);

        public Builder itemPath(String var1);

        public Builder hash(String var1);

        public Builder additionalInfo(AdditionalInfo var1);

        default public Builder additionalInfo(Consumer<AdditionalInfo.Builder> additionalInfo) {
            return this.additionalInfo((AdditionalInfo)((AdditionalInfo.Builder)AdditionalInfo.builder().applyMutation(additionalInfo)).build());
        }
    }
}

