/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.AffectedEntity;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationFailedSetCopier;
import software.amazon.awssdk.services.health.model.EntityListCopier;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.services.health.model.OrganizationAffectedEntitiesErrorItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAffectedEntitiesForOrganizationResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeAffectedEntitiesForOrganizationResponse> {
    private static final SdkField<List<AffectedEntity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entities").getter(DescribeAffectedEntitiesForOrganizationResponse.getter(DescribeAffectedEntitiesForOrganizationResponse::entities)).setter(DescribeAffectedEntitiesForOrganizationResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AffectedEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OrganizationAffectedEntitiesErrorItem>> FAILED_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedSet").getter(DescribeAffectedEntitiesForOrganizationResponse.getter(DescribeAffectedEntitiesForOrganizationResponse::failedSet)).setter(DescribeAffectedEntitiesForOrganizationResponse.setter(Builder::failedSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationAffectedEntitiesErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeAffectedEntitiesForOrganizationResponse.getter(DescribeAffectedEntitiesForOrganizationResponse::nextToken)).setter(DescribeAffectedEntitiesForOrganizationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, FAILED_SET_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAffectedEntitiesForOrganizationResponse.memberNameToFieldInitializer();
    private final List<AffectedEntity> entities;
    private final List<OrganizationAffectedEntitiesErrorItem> failedSet;
    private final String nextToken;

    private DescribeAffectedEntitiesForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.failedSet = builder.failedSet;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<AffectedEntity> entities() {
        return this.entities;
    }

    public final boolean hasFailedSet() {
        return this.failedSet != null && !(this.failedSet instanceof SdkAutoConstructList);
    }

    public final List<OrganizationAffectedEntitiesErrorItem> failedSet() {
        return this.failedSet;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedSet() ? this.failedSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedEntitiesForOrganizationResponse)) {
            return false;
        }
        DescribeAffectedEntitiesForOrganizationResponse other = (DescribeAffectedEntitiesForOrganizationResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && this.hasFailedSet() == other.hasFailedSet() && Objects.equals(this.failedSet(), other.failedSet()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAffectedEntitiesForOrganizationResponse").add("Entities", this.hasEntities() ? this.entities() : null).add("FailedSet", this.hasFailedSet() ? this.failedSet() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "failedSet": {
                return Optional.ofNullable(clazz.cast(this.failedSet()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entities", ENTITIES_FIELD);
        map.put("failedSet", FAILED_SET_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAffectedEntitiesForOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeAffectedEntitiesForOrganizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<AffectedEntity> entities = DefaultSdkAutoConstructList.getInstance();
        private List<OrganizationAffectedEntitiesErrorItem> failedSet = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedEntitiesForOrganizationResponse model) {
            super(model);
            this.entities(model.entities);
            this.failedSet(model.failedSet);
            this.nextToken(model.nextToken);
        }

        public final List<AffectedEntity.Builder> getEntities() {
            List<AffectedEntity.Builder> result = EntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<AffectedEntity.BuilderImpl> entities) {
            this.entities = EntityListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<AffectedEntity> entities) {
            this.entities = EntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(AffectedEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<AffectedEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (AffectedEntity)((AffectedEntity.Builder)AffectedEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OrganizationAffectedEntitiesErrorItem.Builder> getFailedSet() {
            List<OrganizationAffectedEntitiesErrorItem.Builder> result = DescribeAffectedEntitiesForOrganizationFailedSetCopier.copyToBuilder(this.failedSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedSet(Collection<OrganizationAffectedEntitiesErrorItem.BuilderImpl> failedSet) {
            this.failedSet = DescribeAffectedEntitiesForOrganizationFailedSetCopier.copyFromBuilder(failedSet);
        }

        @Override
        public final Builder failedSet(Collection<OrganizationAffectedEntitiesErrorItem> failedSet) {
            this.failedSet = DescribeAffectedEntitiesForOrganizationFailedSetCopier.copy(failedSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(OrganizationAffectedEntitiesErrorItem ... failedSet) {
            this.failedSet(Arrays.asList(failedSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(Consumer<OrganizationAffectedEntitiesErrorItem.Builder> ... failedSet) {
            this.failedSet(Stream.of(failedSet).map(c -> (OrganizationAffectedEntitiesErrorItem)((OrganizationAffectedEntitiesErrorItem.Builder)OrganizationAffectedEntitiesErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAffectedEntitiesForOrganizationResponse build() {
            return new DescribeAffectedEntitiesForOrganizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAffectedEntitiesForOrganizationResponse> {
        public Builder entities(Collection<AffectedEntity> var1);

        public Builder entities(AffectedEntity ... var1);

        public Builder entities(Consumer<AffectedEntity.Builder> ... var1);

        public Builder failedSet(Collection<OrganizationAffectedEntitiesErrorItem> var1);

        public Builder failedSet(OrganizationAffectedEntitiesErrorItem ... var1);

        public Builder failedSet(Consumer<OrganizationAffectedEntitiesErrorItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

