/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.healthlake.HealthLakeClient;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsResponse;

public class ListFHIRImportJobsIterable
implements SdkIterable<ListFhirImportJobsResponse> {
    private final HealthLakeClient client;
    private final ListFhirImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFHIRImportJobsIterable(HealthLakeClient client, ListFhirImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFhirImportJobsResponseFetcher();
    }

    public Iterator<ListFhirImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFhirImportJobsResponseFetcher
    implements SyncPageFetcher<ListFhirImportJobsResponse> {
        private ListFhirImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListFhirImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFhirImportJobsResponse nextPage(ListFhirImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListFHIRImportJobsIterable.this.client.listFHIRImportJobs(ListFHIRImportJobsIterable.this.firstRequest);
            }
            return ListFHIRImportJobsIterable.this.client.listFHIRImportJobs((ListFhirImportJobsRequest)((Object)ListFHIRImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

