/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthorizationStrategy {
    SMART_ON_FHIR_V1("SMART_ON_FHIR_V1"),
    AWS_AUTH("AWS_AUTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthorizationStrategy> VALUE_MAP;
    private final String value;

    private AuthorizationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthorizationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthorizationStrategy> knownValues() {
        EnumSet<AuthorizationStrategy> knownValues = EnumSet.allOf(AuthorizationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthorizationStrategy.class, AuthorizationStrategy::toString);
    }
}

